/*
 * Copyright (C) 2003-2005 Atmark Techno, Inc.  All Rights Reserved.
 */

#ifndef _HERMIT_SUZAKU_FLASH_REGION_H
#define _HERMIT_SUZAKU_FLASH_REGION_H

enum FlashRegionID {
        FlashRegionIdAll,
        FlashRegionIdFpga,
        FlashRegionIdBootloader,
        FlashRegionIdImage,
        FlashRegionIdKernel,
        FlashRegionIdUser,
        FlashRegionIdConfig,
        FlashRegionIdFree1,
        FlashRegionIdFree2,
        FlashRegionIdMax,
};

unsigned int flash_region_get_start_address (enum FlashRegionID id);
unsigned int flash_region_get_end_address   (enum FlashRegionID id);
int          flash_region_get_size          (enum FlashRegionID id);
char *       flash_region_get_name          (enum FlashRegionID id);
char *       flash_region_get_blocking      (enum FlashRegionID id);

#endif /* _HERMIT_SUZAKU_FLASH_REGION_H */
