#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <signal.h>
#include "client.h"
#include "shm.h"

#define	TRUE	1
#define	FALSE	0

void	exit (int status);

int	dstSocket;
int	udpSocket;
struct	sockaddr_in	udpAddr;
struct	sockaddr_in	sndAddr;

void CloseSocket()
{
        if (dstSocket != 0){
                close(dstSocket);
                dstSocket=0;
        }
        if (udpSocket != 0){
                close(dstSocket);
                dstSocket=0;
        }
        exit(0);
}

void	test_loop(void)
{
	int	n;
	char	buf[100];
	memset (buf, 0x20, 100);

	for (n = 0 ; n < 100 ; n++)
	{
		sprintf (buf, "TEST %d",n);
                sendto (udpSocket, buf, 100, 0,
                	(struct sockaddr *)&udpAddr, sizeof(udpAddr));
		usleep(20000);
	}
        sendto (udpSocket, "end       ", 10, 0,
		(struct sockaddr *)&udpAddr, sizeof(udpAddr));
}

void	Port_Entry(void)
{
	struct	shm_form	keep_msg;
	struct	hostent	*hp;
	int	ret;

	keep_msg.type = PortEntry;
	memcpy (keep_msg.Rep1Call, client_call, 8);
        hp = gethostbyname(TrustDomainName);
        bcopy(hp->h_addr, &udpAddr.sin_addr, hp->h_length);
        udpAddr.sin_family = AF_INET;
        udpAddr.sin_port = htons(keep_port);
        ret = sendto (udpSocket, (char *)&keep_msg, sizeof(keep_msg), 0,
                 (struct sockaddr *)&udpAddr, sizeof(udpAddr));
printf (" Ack ret=%d\n",ret);
}

void    AckSend(char srcRptCall[8])
{
        struct  shm_form        ack_msg;
        struct  hostent *hp;
        int     ret;

        ack_msg.type = Ack;
        memcpy (ack_msg.Rep1Call, srcRptCall, 8);
	memcpy (ack_msg.dstCall, client_call, 8);
        hp = gethostbyname(TrustDomainName);
        bcopy(hp->h_addr, &sndAddr.sin_addr, hp->h_length);
        sndAddr.sin_family = AF_INET;
        sndAddr.sin_port = htons(keep_port);
        ret = sendto (udpSocket, (char *)&ack_msg, sizeof(ack_msg), 0,
                 (struct sockaddr *)&sndAddr, sizeof(sndAddr));
printf ("AckSend ret=%d\n",ret);
}
int main(int argc, const char **argv){

        int     ret;
        int     width;
        int     n;
	int	k;
	char	Send_Connect;
	char	Recv_Connect;
	char	SendSW;
	char	RecvSW;
        fd_set  readOk,Mask;
        struct  timeval timeout;
        socklen_t addrlen;
	struct	packet	send_packet;

	// IP アドレス，ソケット，sockaddr_in 構造体
	struct sockaddr_in dstAddr;
	struct	repMsg	reqConMsg;

	//struct sockaddr_in addr;
 	struct hostent *hp;
  	char   buf[256];
	int    numrcv;

        signal(SIGINT,CloseSocket);
        signal(SIGTERM,CloseSocket);

	config (argc, (char **)argv);

	//sockaddr_in 構造体のセット
	bzero((char *)&dstAddr, sizeof(dstAddr));
	dstAddr.sin_family = AF_INET;
	dstAddr.sin_port = htons(trust_port);
  
	hp = gethostbyname(TrustDomainName);
	bcopy(hp->h_addr, &dstAddr.sin_addr, hp->h_length);

	//ソケットの生成
	dstSocket = socket(AF_INET, SOCK_STREAM, 0);
	udpSocket = socket(AF_INET, SOCK_DGRAM, 0);

	//接続
	if (connect(dstSocket, (struct sockaddr *)&dstAddr, 
			sizeof(dstAddr)) < 0){
	printf("Does not connect to '%s'.\n",TrustDomainName);
	return(-1);
	}

	printf("Connect to '%s'.\n", TrustDomainName);

	//コールサイン入力のプロンプト
	memset (buf, 0x20, 14); 
	while (memcmp (buf,"Repeater Call:", 14) != 0)
	{
		numrcv = recv(dstSocket, buf, 64, 0);
		buf[numrcv] = 0x00;
		printf("%s\n",buf);
	}

	//コールサインの送信
	for (n = 0 ; n < 8 ; n++)
	{
		client_call[n] = toupper (client_call[n]);
	}
	send (dstSocket, client_call, 8, 0);

        //パスワード入力のプロンプト
	memset (buf, 0x20, 9);
	while (memcmp (buf, "Password:", 9) != 0)
	{
        	numrcv = recv(dstSocket, buf,  255, 0);
        	buf[numrcv] = 0x00;
		printf ("%s\n",buf);
	}

        //パスワードの送信
        send (dstSocket, client_password, strlen(client_password), 0);

        //ポート番号入力のプロンプト
	memset (buf, 0x20, 12);
        while (memcmp (buf, "Port Number:", 12) != 0)
	{
		numrcv = recv(dstSocket, buf, 255, 0);
       	 	buf[numrcv] = 0x00;
        	printf("%s\n",buf);
	}

	sprintf (buf, "%0d\0", client_port);
	//ポート番号の送信
        send (dstSocket, buf, strlen(buf), 0);


        memset (&udpAddr, 0, sizeof(struct sockaddr_in));
        udpAddr.sin_family = AF_INET;
        udpAddr.sin_port = htons(client_port);
        udpAddr.sin_addr.s_addr = htonl(INADDR_ANY);
        ret = bind(udpSocket, (struct sockaddr *)&udpAddr, sizeof(udpAddr));

	//Port_Entry();

        FD_ZERO(&Mask);
        FD_SET(dstSocket, &Mask);
	FD_SET(udpSocket, &Mask);
        FD_SET(0,&Mask);
        width = dstSocket;
	if (dstSocket < udpSocket) width = udpSocket;
	width++;
	Send_Connect = FALSE;
	Recv_Connect = FALSE;
	SendSW = FALSE;
	RecvSW = FALSE;


	while (1){
		readOk = Mask;
		timeout.tv_sec = 0;
		timeout.tv_usec = 5000;
		switch (select (width, (fd_set *)&readOk, NULL, NULL, &timeout))
		{
	
			case -1:
			case 0:
				break;
			default:
				if(FD_ISSET(dstSocket, &readOk))
				{
                        		//パケットの受信
                        		numrcv = recv(dstSocket, &reqConMsg, sizeof(reqConMsg), 0);
					if (numrcv <= 0)
                                        {
                                                reqConMsg.reqType = ReqEnd;
                                                send (dstSocket, &reqConMsg, sizeof(reqConMsg), 0);
                                                close(dstSocket);
                                                return(0);
                                        }
                        		if (reqConMsg.reqType == Ack)
                        		{
                                		printf ("%2.2x %8.8s %s %d\n", 
							reqConMsg.reqType, reqConMsg.ackConnect.call, 
							inet_ntoa (reqConMsg.ackConnect.ip),
							reqConMsg.ackConnect.port);
                                        	        udpAddr.sin_family = AF_INET;
                                                	udpAddr.sin_port = htons(reqConMsg.ackConnect.port);
                                              	  	udpAddr.sin_addr = reqConMsg.ackConnect.ip;
                                                	sendto (udpSocket, "\0\0\0\0SRCREQ UDP hole punching", 28, 0,
                                                        	(struct sockaddr *)&udpAddr, sizeof(udpAddr));
                        		}
                                        else if (reqConMsg.reqType == ReqConnect)
                                        {
                                                printf ("%2.2x %2.2x %8.8s %8.8s %s %d\n",
							reqConMsg.reqType,
                                                        reqConMsg.reqConnect.protocol,
                                                        reqConMsg.reqConnect.YourCall,
							reqConMsg.reqConnect.Rpt1Call,
                                                        inet_ntoa(reqConMsg.reqConnect.ip),
                                                        reqConMsg.reqConnect.port);

                                                        sndAddr.sin_family = AF_INET;
                                                        sndAddr.sin_port = htons(reqConMsg.ackConnect.port);
                                                        sndAddr.sin_addr = reqConMsg.ackConnect.ip;
                                                        sendto (udpSocket, "\0\0\0\0DSTREQ UDP hole punching", 28, 0,
                                                                (struct sockaddr *)&sndAddr, sizeof(sndAddr));

							AckSend(reqConMsg.reqConnect.Rpt1Call);
printf ("%d %s\n", reqConMsg.ackConnect.port, inet_ntoa (reqConMsg.ackConnect.ip));

                                        }
				}
				if(FD_ISSET(0, &readOk))
				{
                			fgets(buf, 255, stdin);
                			if (memcmp (buf, "end", 3) == 0)
					{
						reqConMsg.reqType = ReqEnd;
        					send (dstSocket, &reqConMsg, sizeof(reqConMsg), 0);
        					close(dstSocket);
        					return(0);
					}
                			memcpy (reqConMsg.reqConnect.Rpt2Call, buf, 32);
                			reqConMsg.reqConnect.port =  client_port;
                			reqConMsg.reqConnect.protocol = 0;
                			reqConMsg.reqType = ReqConnect;
                			send (dstSocket, &reqConMsg, sizeof(reqConMsg), 0);
					Send_Connect = FALSE;
					SendSW = TRUE;
				}
				if (FD_ISSET(udpSocket, &readOk))
				{
			                addrlen = sizeof(struct sockaddr_in);
			                ret=recvfrom (udpSocket, (char *)&send_packet, 56, 0,
                        			(struct sockaddr *)&udpAddr, &addrlen);
					if (memcmp ((char *)&send_packet, "\0\0\0\0DSTREQ", 10) == 0)
					{
                        			sendto (udpSocket, "\0\0\0\0DSTACK UDP hole punching", 28, 0,
                                			(struct sockaddr *)&udpAddr, sizeof(udpAddr));
					}
					if (memcmp ((char *)&send_packet, "\0\0\0\0SRCREQ", 10) == 0)
					{
						printf ("debug src ack send\n");
						printf ("port=%d ip=%s\n",htons(udpAddr.sin_port), inet_ntoa (udpAddr.sin_addr)); 
                        			sendto (udpSocket, "\0\0\0\0SRCACK UDP hole punching", 28, 0,
                                			(struct sockaddr *)&udpAddr, sizeof(udpAddr));
					}
					if (memcmp (send_packet.ID, "DSVT", 4) == 0)printf ("%4.4s %2.2x\n",send_packet.ID, send_packet.B_header.seq);
					if (memcmp(buf, "end       ", 10) == 0)
					{
						Recv_Connect = FALSE;
						RecvSW = FALSE;
						printf ("debug end\n");
					}
				}
				break;
		}
//		if (SendSW)
//		{
//  //              	udpAddr.sin_family = AF_INET;
//                	udpAddr.sin_port = htons(reqConMsg.ackConnect.port);
//                	udpAddr.sin_addr = reqConMsg.ackConnect.ip;
//                	sendto (udpSocket, "\0\0\0\0SRC UDP hole punching", 25, 0,
//                		(struct sockaddr *)&udpAddr, sizeof(udpAddr));
//			SendSW = FALSE;
//		}
//                if (RecvSW)
//                {
//                        udpAddr.sin_family = AF_INET;
//                        udpAddr.sin_port = htons(reqConMsg.reqConnect.port);
//                        udpAddr.sin_addr = reqConMsg.reqConnect.ip;
//                        sendto (udpSocket, "\0\0\0\0DST UDP hole punching", 25, 0,
//                                (struct sockaddr *)&udpAddr, sizeof(udpAddr));
//			RecvSW = FALSE;
//                }
//		if (Send_Connect && !SendSW)
//		{
//			test_loop();
//			Send_Connect = FALSE;
//			SendSW = FALSE;
//		}
  	}
}

