/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

public class AwkBuiltInTest extends AwkTestCase {

	public void testLength() {
		eqi("length(\"a\");", 1);
	}

	public void testIndex() {
		eqi("index(\"banana\", \"an\");", 2);
		eqi("index(\"banana\", \"zz\");", 0);
	}

	public void testSplit() {
		eqi("{ split(\"aaa  bbb cc\", a, \" \"); 1; }", 1);
		eqs("a[1];", "aaa");
		eqs("a[2];", "bbb");
		eqs("a[3];", "cc");
	}

	public void testGsub() {
		eqs("gsub(/a/, \"cc\", \"aba\");", "ccbcc");
		eqs("gsub(/a/, \"c&c\", \"aba\");", "cacbcac");
		eqs("gsub(/a+/, \"&&\", \"abaa\");", "aabaaaa");
		eqs("gsub(/a+/, \"\\\\&\\\\&\", \"abaa\");", "&&b&&");
		eqs("gsub(/a+/, \"\\\\a\", \"abaa\");", "\\ab\\a");
		eqs("gsub(/a*/, \"a\", \"abaaaa\");", "aabaa");
		eqs("gsub(/z/, \"cc\", \"aba\");", "aba");
		eqs("gsub(\"a+\", \"\\\\a\", \"abaa\");", "\\ab\\a");
		eqs("gsub(1, \"765\", \"121\");", "7652765");
	}

	public void testSub() {
		eqs("sub(/a/, \"cc\", \"aba\");", "ccba");
		eqs("sub(/a/, \"c&c\", \"aba\");", "cacba");
		eqs("sub(/a+/, \"&&\", \"abaa\");", "aabaa");
		eqs("sub(/a+/, \"\\\\&\\\\&\", \"abaa\");", "&&baa");
		eqs("sub(/a+/, \"\\\\a\", \"abaa\");", "\\abaa");
		eqs("sub(/a*/, \"a\", \"abaaaa\");", "abaaaa");
		eqs("sub(/z/, \"cc\", \"aba\");", "aba");
		eqs("sub(\"a+\", \"\\\\a\", \"abaa\");", "\\abaa");
		eqs("sub(1, \"765\", \"121\");", "76521");
	}

	public void testMatch() {
		eqi("match(\"abc\", /b/);", 2);
		eqi("RSTART;", 2);  eqi("RLENGTH;", 1);
		eqi("match(\"abcccde\", /c+/);", 3);
		eqi("RSTART;", 3);  eqi("RLENGTH;", 3);
		eqi("match(\"abc\", \"b\");", 2);
		eqi("RSTART;", 2);  eqi("RLENGTH;", 1);
	}

	public void testSubstr() {
		eqs("substr(\"abcdef\", 2, 3)", "bcd");
		eqs("substr(\"abcdef\", 2)", "bcdef");
		eqs("substr(\"abcdef\")", "abcdef");
	}

	public void testSprintf() {
		eqs("sprintf(\"%04d\", 765)", "0765");
		eqs("sprintf(\"%04d:%5s\", 765, \"aa\")", "0765:   aa");
		eqs("sprintf(\"Hello, world\")", "Hello, world");
		eqs("sprintf()", "");
	}

}
