/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.misc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.CharBuffer;

public class PushbackLineNumberReader extends Reader
implements PushbackLineNumberReadable {

	//
	private LineNumberReader lrd;
	private PushbackReader pbrd;

	/**
	 * 
	 * @param rd
	 */
	public PushbackLineNumberReader(Reader rd) {
		lrd  = new LineNumberReader(rd);
		pbrd = new PushbackReader(lrd);
	}

	/**
	 * 
	 * @param c
	 * @throws IOException
	 */
	public void unread(int c) throws IOException {
		pbrd.unread(c);
	}

	/**
	 * 
	 * @return
	 */
	public int getLineNumber() {
		return lrd.getLineNumber();
	}

	@Override
	public void close() throws IOException {
		pbrd.close();
	}

	@Override
	public int read(char[] cbuf, int off, int len) throws IOException {
		return pbrd.read();
	}

	@Override
	public int read(char[] cbuf) throws IOException {
		return pbrd.read(cbuf);
	}

	@Override
	public int read(CharBuffer target) throws IOException {
		return pbrd.read(target);
	}

	@Override
	public int read() throws IOException {
		return pbrd.read();
	}

	public void resetPrompt() {
		// do nothing
	}

	public boolean isNewline() {
		return false;
	}

}
