/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.parser;

/**
 * Cプリプロセッサの関係演算子です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class CpreRelop2 extends CpreOperator {

	public static final CpreRelop2 EQ =
		new CpreRelop2(CpreOperatorType.EQ, "==");
	public static final CpreRelop2 NE =
		new CpreRelop2(CpreOperatorType.NE, "!=");

	private CpreOperatorType operator;

	private CpreRelop2(CpreOperatorType op, String desc) {
		super(desc);
		operator = op;
	}

	public CpreOperatorType getRelation() {
		return operator;
	}

}
