/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 組み込み関数gensubの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/05/11
 */
public class AwkGensub extends AwkFunction {

	/**
	 * 
	 */
	public AwkGensub() {
		super("gensub", null);
	}

	static String rep1(String s, Matcher m) {
		StringBuffer b = new StringBuffer();
		boolean esc = false;
		int c, p;

		for(int i = 0; i < s.length(); i += c > 0xffff ? 2 : 1) {
			c = s.codePointAt(i);
			if(esc) {
				if(c >= '0' && c <= '9') {
					p = c - '0';
					if(p <= m.groupCount())  b.append(m.group(p));
				} else {
					if(c != '&' && c != '\\')  b.append('\\');
					b.appendCodePoint(c);
				}
				esc = false;
			} else if(c == '\\') {
				esc = true;
			} else if(c == '&') {
				b.append(m.group());
			} else {
				b.appendCodePoint(c);
			}
		}
		if(esc)  b.append('\\');
		return b.toString();
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o,
			List<AwkValue> args) {
		StringBuffer b = new StringBuffer();
		String s, t, v;
		AwkValue h;
		Pattern p;
		Matcher m;
		int i = 0, r;

		s = args.size() < 2 ? "" : args.get(1).toString(ns);
		h = args.size() < 3 ? AwkUndefined.UNDEF : args.get(2);
		t = (args.size() < 4 ?
				ns.referField(0) : args.get(3)).toString(ns);
		if(args.size() < 1) {
			return AwkString.valueOf("");
		} else {
			p = args.get(0).toRegex(ns);
			m = p.matcher(t);
			if(h.isIntegerValue()) {
				r = h.toInteger().intValue();
				r = r > 0 ? r : 1;
			} else if((v = h.toString(ns)).length() > 0 &&
					(v.charAt(0) == 'g' || v.charAt(0) == 'G')) {
				r = -1;
			} else {
				r = 1;
			}

			for(int k = 1; m.find(); k++) {
				if(r < 0 || r == k) {
					b.append(t, i, m.start());
					b.append(rep1(s, m));
					i = m.end();
					if(r > 0)  break;
				}
			}
			t = b.append(t, i, t.length()).toString();
			return AwkString.valueOf(t);
		}
	}

}
