/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.parser;

/**
 * 浮動小数点のトークンです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03/16
 */
public class CpreFloatToken extends CpreToken {

	private double value;

	/**
	 * トークンを生成します。
	 * 
	 * @param x 浮動小数点数
	 */
	public CpreFloatToken(String x) {
		super(x);
		value = Double.parseDouble(x);
	}

	/**
	 * トークンを生成します。
	 * 
	 * @param x 浮動小数点数
	 */
	public CpreFloatToken(double x) {
		super(Double.toString(x));
		value = x;
	}

	public double getFloat() {
		return value;
	}

	public int hashCode() {
		return (int)Double.doubleToRawLongBits(value);
	}

	public boolean equals(Object o) {
		if(o instanceof CpreFloatToken) {
			return value == ((CpreFloatToken)o).value;
		}
		return false;
	}

}
