/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.builtin.ShBuiltInCommands;
import net.morilib.sh.misc.XtraceStream;

public class ShTreeWhileUntil implements ShTree {

	private ShTree condition;
	private ShTree block;
	private boolean until;

	public ShTreeWhileUntil(ShTree condition, ShTree block,
			boolean until) {
		this.condition = condition;
		this.block     = block;
		this.until     = until;
	}

	public int eval(ShEnvironment env,
			ShFileSystem fs,
			ShBuiltInCommands cmds,
			ShRuntime run,
			InputStream in,
			PrintStream out,
			PrintStream err,
			XtraceStream p) throws IOException, ShSyntaxException {
		int a = 0;

		while((condition.eval(env, fs, cmds, run, in, out,
				err, p) != 0) == until) {
			a = block.eval(env, fs, cmds, run, in, out, err, p);
		}
		return a;
	}

	public void compileInternally(ShTreeExpressionMachine.Builder b,
			Object brk, Object cnt) {
		Object l1 = new Object(), l2 = new Object();

		b.addLabel(l1);
		condition.compileInternally(b, brk, cnt);
		if(until) {
			b.addJmpNZ(l2);
		} else {
			b.addJmpZ(l2);
		}
		block.compileInternally(b, l2, l1);
		b.addJmp(l1);
		b.addLabel(l2);
		b.addRes();
	}

	public String toString() {
		StringBuffer b = new StringBuffer();

		b.append(until ? "until " : "while ");
		b.append(condition).append("\ndo\n");
		b.append(block).append("\ndone");
		return b.toString();
	}

}
