/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkValue;

public class AwkArrayReferrer extends AwkExpression {

	private AwkExpression e1, e2;

	public AwkArrayReferrer(AwkExpression e1, AwkExpression e2) {
		this.e1 = e1;
		this.e2 = e2;
	}

	/**
	 * 
	 * @return
	 */
	public AwkExpression getArray() {
		return e1;
	}

	/**
	 * 
	 * @return
	 */
	public AwkExpression getIndex() {
		return e2;
	}

	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		return e1.eval(ns, o).referArray(e2.eval(ns, o));
	}

	@Override
	public void assign(AwkNamespace ns, AwkValue v, AwkFiles o) {
		AwkValue w;

		if(e1 instanceof AwkReferVariable ||
				e1 instanceof AwkArrayReferrer) {
			w = e1.eval(ns, o);
			if(!(w instanceof AwkArray)) {
				e1.assign(ns, new AwkArray(), o);
			}
		}
		e1.eval(ns, o).putArray(e2.eval(ns, o), v);
	}

	@Override
	public boolean isLvalue() {
		return true;
	}

}
