/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class AwkPrintf extends AwkExpression {

	private static final AwkValue TWO = AwkInteger.valueOf(2);

	AwkExpression[] exprs;
	AwkExpression filename, format;
	boolean append;

	public AwkPrintf(AwkExpression filename, AwkExpression format,
			List<AwkExpression> exprs, boolean append) {
		this.format   = format;
		this.filename = filename;
		this.exprs    = exprs.toArray(new AwkExpression[0]);
		this.append   = append;
	}

	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles f) {
		List<Object> l = new ArrayList<Object>();
		PrintWriter w = null;
		String ors = ns.getORS();
		AwkValue g;

		try {
			if(filename == null) {
				w = f.getStdout();
			} else if((g = filename.eval(ns, f)).equals(TWO)) {
				w = f.getStderr();
			} else if(g.equals(AwkInteger.ONE)) {
				w = f.getStdout();
			} else if(append) {
				w = f.getWriter(filename.eval(ns, f).toString());
			} else {
				w = f.openWriter(filename.eval(ns, f).toString());
			}

			for(int i = 0; i < exprs.length; i++) {
				l.add(exprs[i].eval(ns, f).toObject());
			}
			w.printf(format.eval(ns, f).toString(),
					l.toArray(new Object[0]));
			w.print(ors);
			return AwkValue.TRUE;
		} catch (IOException e1) {
			return AwkValue.FALSE;
		}
	}

}
