/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.namespace;

import net.morilib.awk.value.AwkFunction;
import net.morilib.awk.value.AwkValue;

public interface AwkNamespace {

	/**
	 * 
	 * @param s
	 * @return
	 */
	public AwkValue find(String s);

	/**
	 * 
	 * @param s
	 * @return
	 */
	public AwkFunction findFunction(String s);

	/**
	 * 
	 * @param s
	 * @param v
	 */
	public void assign(String s, AwkValue v);

	/**
	 * 
	 * @param s
	 * @param v
	 */
	public void bindFunction(String s, AwkFunction v);

	/**
	 * 
	 * @param s
	 * @return
	 */
	public boolean isReadonly(String s);

	/**
	 * 
	 * @param s
	 * @return
	 */
	public AwkNamespace subnamespace(String s);

	/**
	 * 
	 * @param s
	 * @return
	 */
	public AwkNamespace referNamespace(String s);

	/**
	 * 
	 * @param n
	 * @return
	 */
	public AwkValue referField(int n);

	/**
	 * 
	 * @return
	 */
	public int sizeOfField();

	/**
	 * 
	 * @param s
	 */
	public void setField(String s);

	/**
	 * 
	 * @return
	 */
	public String getFS();

	/**
	 * 
	 * @return
	 */
	public String getRS();

	/**
	 * 
	 * @return
	 */
	public String getOFS();

	/**
	 * 
	 * @return
	 */
	public String getORS();

}
