/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

import net.morilib.awk.expr.AwkCastException;

public class AwkArray implements AwkValue {

	private Map<AwkValue, AwkValue> map;

	public AwkArray() {
//		map = new HashMap<AwkValue, AwkValue>();
		map = new TreeMap<AwkValue, AwkValue>();
	}

	public boolean isFloat() {
		return false;
	}

	public boolean isInteger() {
		return false;
	}

	public boolean isReal() {
		return false;
	}

	public boolean isFloatValue() {
		return false;
	}

	public boolean isIntegerValue() {
		return false;
	}

	public boolean isRealValue() {
		return false;
	}

	public boolean isString() {
		return false;
	}

	public boolean isRegex() {
		return false;
	}

	public boolean isFunction() {
		return false;
	}

	public boolean toBoolean() {
		return false;
	}

	public double toFloat() {
		throw new AwkCastException();
	}

	public BigInteger toInteger() {
		throw new AwkCastException();
	}

	public Number toReal() {
		throw new AwkCastException();
	}

	public Pattern toRegex() {
		throw new AwkCastException();
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkValue#toObject()
	 */
	public Object toObject() {
		return new TreeMap<AwkValue, AwkValue>(map);
	}

	public AwkValue referArray(AwkValue v) {
		AwkValue w = map.get(v);

		return w != null ? w : AwkUndefined.UNDEF;
	}

	public AwkValue putArray(AwkValue k, AwkValue v) {
		return map.put(k, v);
	}

	public AwkValue deleteArray(AwkValue v) {
		return map.remove(v);
	}

	public Collection<AwkValue> values() {
		return map.values();
	}

	public int compareTo(AwkValue o) {
		throw new AwkCastException();
	}

	public int hashCode() {
		return map.hashCode();
	}

	public boolean equals(Object o) {
		if(o instanceof AwkArray) {
			return map.equals(((AwkArray)o).map);
		}
		return false;
	}

	public String toString() {
		return map.toString();
	}

}
