/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;

import net.morilib.awk.expr.AwkCastException;

public class AwkUndefined implements AwkValue {

	/**
	 * 
	 */
	public static final AwkUndefined UNDEF = new AwkUndefined();

	private AwkUndefined() {}

	public double toFloat() {
		return 0.0;
	}

	public BigInteger toInteger() {
		return BigInteger.ZERO;
	}

	public Number toReal() {
		return BigInteger.ZERO;
	}

	public boolean toBoolean() {
		return false;
	}

	public Pattern toRegex() {
		throw new AwkCastException();
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.value.AwkValue#toObject()
	 */
	public Object toObject() {
		return "";
	}

	public AwkValue referArray(AwkValue v) {
		return this;
	}

	public AwkValue putArray(AwkValue k, AwkValue v) {
		AwkArray r = new AwkArray();

		r.putArray(k, v);
		return r;
	}

	public AwkValue deleteArray(AwkValue v) {
		return this;
	}

	public Collection<AwkValue> values() {
		return Collections.emptyList();
	}

	public boolean isFloat() {
		return false;
	}

	public boolean isInteger() {
		return false;
	}

	public boolean isReal() {
		return false;
	}

	public boolean isFloatValue() {
		return false;
	}

	public boolean isIntegerValue() {
		return false;
	}

	public boolean isRealValue() {
		return false;
	}

	public boolean isString() {
		return false;
	}

	public boolean isRegex() {
		return false;
	}

	public boolean isFunction() {
		return false;
	}

	public String toString() {
		return "";
	}

	public int compareTo(AwkValue o) {
		return o instanceof AwkUndefined ? 0 : -1;
	}

}
