/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.value;

import java.math.BigInteger;
import java.util.Collection;
import java.util.regex.Pattern;

public interface AwkValue extends Comparable<AwkValue> {

	/**
	 * 
	 */
	public static final AwkValue TRUE = AwkInteger.ONE;

	/**
	 * 
	 */
	public static final AwkValue FALSE = AwkInteger.ZERO;

	/**
	 * 
	 */
	public static final AwkValue IOERROR = AwkInteger.valueOf(-1);

	/**
	 * 
	 * @return
	 */
	public BigInteger toInteger();

	/**
	 * 
	 * @return
	 */
	public double toFloat();

	/**
	 * 
	 * @return
	 */
	public String toString();

	/**
	 * 
	 * @return
	 */
	public boolean toBoolean();

	/**
	 * 
	 * @return
	 */
	public Number toReal();

	/**
	 * 
	 * @return
	 */
	public Pattern toRegex();

	/**
	 * 
	 * @return
	 */
	public Object toObject();

	/**
	 * 
	 * @return
	 */
	public AwkValue referArray(AwkValue v);

	/**
	 * 
	 * @return
	 */
	public AwkValue putArray(AwkValue k, AwkValue v);

	/**
	 * 
	 * @return
	 */
	public AwkValue deleteArray(AwkValue v);

	/**
	 * 
	 * @return
	 */
	public Collection<AwkValue> values();

	/**
	 * 
	 * @return
	 */
	public boolean isInteger();

	/**
	 * 
	 * @return
	 */
	public boolean isFloat();

	/**
	 * 
	 * @return
	 */
	public boolean isReal();

	/**
	 * 
	 * @return
	 */
	public boolean isIntegerValue();

	/**
	 * 
	 * @return
	 */
	public boolean isFloatValue();

	/**
	 * 
	 * @return
	 */
	public boolean isRealValue();

	/**
	 * 
	 * @return
	 */
	public boolean isString();

	/**
	 * 
	 * @return
	 */
	public boolean isRegex();

	/**
	 * 
	 * @return
	 */
	public boolean isFunction();

}
