/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

public class AwkArrayTest extends AwkTestCase {

	public void testArray3() {
		eqi("a[1,1] = 3;", 3);
		eqi("a[1,2] = 3;", 3);
		eqi("a[2,1] = 3;", 3);
		eqi("a[2,2] = 3;", 3);
	}

	public void testArray2() {
		eqi("a[2][2] = 3;", 3);
		eqi("a[2][2];", 3);
		eqi("a[2, 2];", 3);
		eqi("a[3,2,1] = 4;", 4);
		eqi("a[3][2][1] = 4;", 4);
		eqi("a[3,2,1];", 4);
		eqi("a[3,2][1];", 4);
		eqi("(a[3])[2,1];", 4);
	}

	public void testArray1() {
		eqi("a[1] = 2;", 2);
		eqi("a[1];", 2);
		eqs("a[\"aaa\"] = \"bbb\";", "bbb");
		eqs("a[\"aaa\"];", "bbb");
	}

	public void testForIn() {
		eqi("a[1] = 7;", 7);
		eqi("a[2] = 6;", 6);
		eqi("a[3] = 5;", 5);
		eqi("a[4] = 4;", 4);
		eqi("a[5] = 3;", 3);
		eqs("for(i in a)  b = b i;", "76543");
		eqi("for(i = 1; i < 4; i++)\nfor(j = 1; j < 4; j++)\nc[i,j]=i*j;", 9);
		eqs("for(j in c) for(i in j) d = d i;", "123246369");
	}

}
