/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;
import net.morilib.unix.misc.ParseDate;
import net.morilib.unix.strftime.Strftime;

public class ShDate implements ShProcess {

	public int main(ShEnvironment env, ShFileSystem fs, InputStream in,
			PrintStream out, PrintStream err,
			String... args) throws IOException {
		java.util.Date d = new java.util.Date();
		String f = "%c";
		int k = 1;

		while(k < args.length) {
			if(args[k].length() == 0) {
				break;
			} else if(args[k].equals("-d")) {
				if(++k >= args.length) {
					err.println("date: date required");
					return 2;
				}
				d = new java.util.Date(ParseDate.from(d, args[k++]));
			} else if(args[k].charAt(0) == '+') {
				f = args[k++].substring(1);
			} else if((d = ParseDate.parseMMDD(args[k++])) == null) {
				err.println("date: invalid date");
				return 2;
			}
		}
		out.println(Strftime.getInstance().format(f, d));
		return 0;
	}

}
