package net.morilib.sh.misc;

import junit.framework.TestCase;

public class SimpleExpressionParserTest extends TestCase {

	void exe(long l, String... args) {
		assertEquals(l, SimpleExpressionParser.parseExpr(args));
	}

	public void test001() {
		exe(72,  "72");
		exe(-72, "-72");
	}

	public void test002() {
		exe(163, "91", "+", "72");
		exe(19,  "91", "-", "72");
	}

	public void test003() {
		exe(144, "72", "*", "2");
		exe(36,  "72", "/", "2");
		exe(2,   "72", "%", "10");
	}

	public void test004() {
		exe(0, "91", "=",  "72");
		exe(0, "91", "==", "72");
		exe(1, "91", "!=", "72");
		exe(0, "91", "<",  "72");
		exe(1, "91", ">",  "72");
		exe(0, "91", "<=", "72");
		exe(1, "91", ">=", "72");

		exe(1, "72", "=",  "72");
		exe(1, "72", "==", "72");
		exe(0, "72", "!=", "72");
		exe(0, "72", "<",  "72");
		exe(0, "72", ">",  "72");
		exe(1, "72", "<=", "72");
		exe(1, "72", ">=", "72");

		exe(0, "72", "=",  "91");
		exe(0, "72", "==", "91");
		exe(1, "72", "!=", "91");
		exe(1, "72", "<",  "91");
		exe(0, "72", ">",  "91");
		exe(1, "72", "<=", "91");
		exe(0, "72", ">=", "91");
	}

	public void test005() {
		exe(1, "9", "&", "7");
		exe(0, "9", "&", "0");
		exe(0, "0", "&", "7");
		exe(0, "0", "&", "0");
	}

	public void test006() {
		exe(1, "9", "|", "7");
		exe(1, "9", "|", "0");
		exe(1, "0", "|", "7");
		exe(0, "0", "|", "0");
	}

	public void test007() {
		exe(72,  "(", "72", ")");
		exe(-19, "(", "72", "-", "91", ")");
	}

	public void test008() {
		exe(17,  "91", "-", "72", "-", "2");
	}

	public void test009() {
		exe(1,  "91", "/", "13", "/", "7");
	}

	public void test010() {
		exe(1,  "9", "==", "9", "==", "1");
	}

	public void test011() {
		exe(0,  "9", "&", "0", "&", "1");
	}

	public void test012() {
		exe(1,  "9", "|", "0", "|", "1");
	}

	public void test013() {
		exe(235, "91", "+", "72", "*", "2");
		exe(235, "72", "*", "2", "+", "91");
	}

	public void test014() {
		exe(0, "91", "*", "72", "=", "91", "+", "2");
	}

	public void test015() {
		exe(1, "0",  "=", "0",  "&", "2",  "=", "2");
		exe(1, "91", "*", "72", "&", "91", "+", "2");
	}

	public void test016() {
		exe(1, "2",  "&", "2",  "|", "2",  "&", "0");
		exe(1, "0",  "=", "0",  "|", "2",  "=", "0");
		exe(1, "91", "*", "72", "|", "91", "+", "2");
	}

	public void test017() {
		exe(326,  "(", "91", "+", "72", ")", "*", "2");
		exe(6696, "72", "*", "(", "2", "+", "91", ")");
	}

	public void test018() {
		exe(1,  "aaaa", ":", "aa*");
		exe(0,  "bbbb", ":", "aa*");
		exe(0,  "", ":", "aa*");
	}

	public void test019() {
		exe(0,  "aaaa", ":", "aa*", "&", "bbbb", ":", "aa*");
		exe(1,  "aaaa", ":", "aa*", "|", "bbbb", ":", "aa*");
	}

}
