/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import java.math.BigInteger;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkDivider extends AwkExpression {

	private AwkExpression e1, e2;

	public AwkDivider(AwkExpression e1, AwkExpression e2) {
		this.e1 = e1;
		this.e2 = e2;
	}

	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		AwkValue r1 = e1.eval(ns, o), r2 = e2.eval(ns, o);
		BigInteger[] a;
		BigInteger e, f;

		if(r1 instanceof AwkUndefined) {
			return AwkInteger.ZERO;
		} else if(r2 instanceof AwkUndefined) {
			throw new ArithmeticException();
		} else if(r1.isFloat() || r2.isFloat()) {
			return AwkFloat.valueOf(r1.toFloat() / r2.toFloat());
		} else if(r1.isIntegerValue() && r2.isIntegerValue()) {
			e = r1.toInteger();
			f = r2.toInteger();
			a = e.divideAndRemainder(f);
			if(a[1].signum() == 0) {
				return AwkInteger.valueOf(e.divide(f));
			}
		}
		return AwkFloat.valueOf(r1.toFloat() / r2.toFloat());
	}

}
