/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

public class AwkBuiltInMathTest extends AwkTestCase {

	public void testSin() {
		eqf("sin(0);", 0.0);
		eqf("sin(\"0\");", 0.0);
		eqf("sin();", 0.0);
	}

	public void testCos() {
		eqf("cos(0);", 1.0);
		eqf("cos(\"0\");", 1.0);
		eqf("cos();", 1.0);
	}

	public void testTan() {
		eqf("tan(0);", 0.0);
		eqf("tan(\"0\");", 0.0);
		eqf("tan();", 0.0);
	}

	public void testSqrt() {
		eqf("sqrt(961);", 31);
		eqf("sqrt(961.0);", 31.0);
		eqf("sqrt(\"961\");", 31);
		eqf("sqrt(\"961.0\");", 31.0);
		eqf("sqrt();", 0.0);
		eqf("sqrt(0);", 0);
		eqf("sqrt(0.0);", 0.0);
		eqf("sqrt(-1);", Double.NaN);
	}

	public void testSrand() {
		exe("srand(765);");
		exe("srand(\"765\");");
		exe("srand();");
	}

	public void testRand() {
		exe("rand();");
	}

	public void testExp() {
		eqf("exp(0)", 1.0);
	}

	public void testLog() {
		eqf("log(1)", 0.0);
	}

	public void testInt() {
		eqi("int(765)", 765);
		eqf("int(765.0)", 765.0);
		eqf("int(765.6)", 765.0);
		eqi("int(-765)", -765);
		eqf("int(-765.0)", -765.0);
		eqf("int(-765.6)", -765.0);
		eqi("int(0)", 0);
		eqf("int(0.0)", 0.0);
	}

	public void testAtan2() {
		eqf("atan2(0, 1)", 0);
	}

}
