/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.reader;

import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class mxGraphViewReader
extends DefaultHandler {
    protected mxICanvas canvas;
    protected double scale = 1.0;

    public abstract mxICanvas createCanvas(Hashtable var1);

    public mxICanvas getCanvas() {
        return this.canvas;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string3.toUpperCase();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string5 = attributes.getLocalName(i);
            if (string5 == null) {
                string5 = attributes.getQName(i);
            }
            hashtable.put(string5, attributes.getValue(i));
        }
        this.parseElement(string4, hashtable);
    }

    public void parseElement(String string, Hashtable hashtable) {
        if (this.canvas == null && string.equalsIgnoreCase("GRAPH")) {
            this.scale = mxUtils.getDouble(hashtable, "scale", 1.0);
            this.canvas = this.createCanvas(hashtable);
            if (this.canvas != null) {
                this.canvas.setScale(this.scale);
            }
        } else if (this.canvas != null) {
            if (string.equalsIgnoreCase("VERTEX") || string.equalsIgnoreCase("GROUP")) {
                this.drawVertex(hashtable);
            } else if (string.equalsIgnoreCase("EDGE")) {
                this.drawEdge(hashtable);
            }
            this.drawLabel(string.equalsIgnoreCase("EDGE"), hashtable);
        }
    }

    public void drawVertex(Hashtable hashtable) {
        int n = mxUtils.getInt(hashtable, "width");
        int n2 = mxUtils.getInt(hashtable, "height");
        if (n > 0 && n2 > 0) {
            int n3 = (int)Math.round(mxUtils.getDouble(hashtable, "x"));
            int n4 = (int)Math.round(mxUtils.getDouble(hashtable, "y"));
            this.canvas.drawVertex(n3, n4, n, n2, hashtable);
        }
    }

    public void drawEdge(Hashtable hashtable) {
        List list = mxGraphViewReader.parsePoints(mxUtils.getString(hashtable, "points"));
        if (list.size() > 0) {
            this.canvas.drawEdge(list, hashtable);
        }
    }

    public void drawLabel(boolean bl, Hashtable hashtable) {
        String string = mxUtils.getString(hashtable, "label");
        if (string != null && string.length() > 0) {
            int n = (int)Math.round(mxUtils.getDouble(hashtable, "offsetX"));
            int n2 = (int)Math.round(mxUtils.getDouble(hashtable, "offsetY"));
            int n3 = 0;
            int n4 = 0;
            if (!bl) {
                n += (int)Math.round(mxUtils.getDouble(hashtable, "x"));
                n2 += (int)Math.round(mxUtils.getDouble(hashtable, "y"));
                n3 = mxUtils.getInt(hashtable, "width");
                n4 = mxUtils.getInt(hashtable, "height");
            }
            mxRectangle mxRectangle2 = mxUtils.getLabelSize(string, hashtable, false);
            mxRectangle mxRectangle3 = mxUtils.getScaledLabelBounds(n, n2, mxRectangle2, n3, n4, hashtable, this.scale);
            this.canvas.drawLabel(string, n, n2, n3, n4, hashtable, false);
        }
    }

    public static List parsePoints(String string) {
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>();
        if (string != null) {
            int n = string.length();
            String string2 = "";
            String string3 = null;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == ',' || c == ' ') {
                    if (string3 == null) {
                        string3 = string2;
                    } else {
                        arrayList.add(new mxPoint(Double.parseDouble(string3), Double.parseDouble(string2)));
                        string3 = null;
                    }
                    string2 = "";
                    continue;
                }
                string2 = string2 + c;
            }
            arrayList.add(new mxPoint(Double.parseDouble(string3), Double.parseDouble(string2)));
        }
        return arrayList;
    }
}

