/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.handler.mxCellMarker;
import com.mxgraph.swing.handler.mxGraphTransferHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.swing.util.mxMouseControl;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class mxGraphHandler
extends mxMouseControl
implements DropTargetListener {
    public static Cursor DEFAULT_CURSOR = new Cursor(13);
    public static int DEFAULT_MAX_HANDLES = 100;
    protected mxGraphComponent graphComponent;
    protected boolean cloneEnabled = true;
    protected boolean imagePreview = true;
    protected int maxHandles = DEFAULT_MAX_HANDLES;
    protected boolean centerPreview = true;
    protected boolean keepOnTop = true;
    protected transient Map handlers = new LinkedHashMap();
    protected transient Object[] cells = null;
    protected transient JComponent preview;
    protected transient ImageIcon dragImage;
    protected transient Point start;
    protected transient Object cell;
    protected transient Object initialCell;
    protected transient Object[] dragCells;
    protected transient mxCellMarker marker;
    protected transient boolean canImport;
    protected transient mxRectangle cellBounds;
    protected transient mxRectangle bbox;
    protected transient mxRectangle previewBounds;
    protected transient mxRectangle previewBbox;
    protected transient mxRectangle transferBounds;
    private transient boolean gridEnabledEvent = false;
    protected transient boolean constrainedEvent = false;
    protected transient mxEventSource.mxIEventListener refreshHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, Object[] objectArray) {
            mxGraphHandler.this.refresh();
        }
    };

    public mxGraphHandler(final mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        this.marker = new mxCellMarker(mxGraphComponent2, Color.BLUE){

            public boolean isEnabled() {
                return this.graphComponent.getGraph().isDropEnabled();
            }

            public Object getCell(MouseEvent mouseEvent) {
                boolean bl;
                TransferHandler transferHandler = this.graphComponent.getTransferHandler();
                boolean bl2 = transferHandler instanceof mxGraphTransferHandler && ((mxGraphTransferHandler)transferHandler).isLocalDrag();
                Object object = super.getCell(mouseEvent);
                Object[] objectArray = bl2 ? mxGraphHandler.this.handlers.keySet().toArray() : mxGraphHandler.this.dragCells;
                mxGraph mxGraph2 = this.graphComponent.getGraph();
                object = mxGraph2.getDropTarget(objectArray, mouseEvent.getPoint(), object);
                boolean bl3 = bl = mouseEvent.isControlDown() && mxGraphHandler.this.cloneEnabled;
                if (bl2 && object != null && objectArray.length > 0 && !bl && (mxGraphHandler.this.handlers.keySet().contains(object) || mxGraph2.getModel().getParent(objectArray[0]) == object)) {
                    object = null;
                }
                return object;
            }
        };
        this.marker.setSwimlaneContentEnabled(true);
        mxGraphComponent2.getGraphControl().add((Component)this, 0);
        mxGraphComponent2.getGraphControl().addMouseListener(this);
        mxGraphComponent2.getGraphControl().addMouseMotionListener(this);
        MouseRedirector mouseRedirector = new MouseRedirector();
        this.addMouseMotionListener(mouseRedirector);
        this.addMouseListener(mouseRedirector);
        mxGraphComponent2.getGraph().getSelectionModel().addListener(mxGraphSelectionModel.EVENT_CHANGE, this.refreshHandler);
        mxGraphComponent2.getGraph().addListener(mxGraph.EVENT_REPAINT, this.refreshHandler);
        mxGraphComponent2.getGraph().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("vertexLabelsMovable") || propertyChangeEvent.getPropertyName().equals("edgeLabelsMovable")) {
                    mxGraphHandler.this.refresh();
                }
            }
        });
        DragGestureListener dragGestureListener = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                mxGraphTransferable mxGraphTransferable2;
                TransferHandler transferHandler;
                if (mxGraphComponent2.isDragEnabled() && mxGraphHandler.this.preview != null && mxGraphHandler.this.start != null && (transferHandler = mxGraphComponent2.getTransferHandler()) instanceof mxGraphTransferHandler && (mxGraphTransferable2 = (mxGraphTransferable)((mxGraphTransferHandler)transferHandler).createTransferable(mxGraphComponent2)) != null) {
                    dragGestureEvent.startDrag(null, mxConstants.EMPTY_IMAGE, new Point(), mxGraphTransferable2, new DragSourceAdapter(){

                        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                            ((mxGraphTransferHandler)transferHandler).exportDone(mxGraphComponent2, mxGraphTransferable2, 0);
                        }
                    });
                }
            }
        };
        DragSource dragSource = new DragSource();
        DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(mxGraphComponent2.getGraphControl(), 3, dragGestureListener);
        DropTarget dropTarget = mxGraphComponent2.getDropTarget();
        try {
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(this);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        this.setVisible(false);
    }

    public JComponent getPreview() {
        return this.preview;
    }

    public void setKeepOnTop(boolean bl) {
        this.keepOnTop = bl;
    }

    public boolean isKeepOnTop() {
        return this.keepOnTop;
    }

    public void setCloneEnabled(boolean bl) {
        this.cloneEnabled = bl;
    }

    public boolean isCloneEnabled() {
        return this.cloneEnabled;
    }

    public void setImagePreview(boolean bl) {
        this.imagePreview = bl;
    }

    public boolean isImagePreview() {
        return this.imagePreview;
    }

    public void setCenterPreview(boolean bl) {
        this.centerPreview = bl;
    }

    public boolean isCenterPreview() {
        return this.centerPreview;
    }

    public int getMaxHandles() {
        return this.maxHandles;
    }

    public void setMaxHandles(int n) {
        this.maxHandles = n;
    }

    protected void createPreview() {
        if (this.preview == null) {
            this.preview = new JPanel(){

                public void paint(Graphics graphics) {
                    if (mxGraphHandler.this.dragImage != null) {
                        graphics.drawImage(mxGraphHandler.this.dragImage.getImage(), 0, 0, mxGraphHandler.this.dragImage.getIconWidth(), mxGraphHandler.this.dragImage.getIconHeight(), this);
                    } else if (!mxGraphHandler.this.imagePreview) {
                        super.paint(graphics);
                    }
                }
            };
            this.preview.setOpaque(false);
            this.preview.setVisible(false);
            this.preview.setBorder(mxConstants.PREVIEW_BORDER);
            this.graphComponent.getGraphControl().add((Component)this.preview, 0);
        }
    }

    public void updateDragImage(Object[] objectArray) {
        BufferedImage bufferedImage = mxCellRenderer.createBufferedImage(this.graphComponent.getGraph(), objectArray, this.graphComponent.getGraph().getView().getScale(), null, this.graphComponent.isAntiAlias(), null, this.graphComponent.getCanvas());
        if (bufferedImage != null) {
            this.dragImage = new ImageIcon(bufferedImage);
            this.preview.setSize(this.dragImage.getIconWidth(), this.dragImage.getIconHeight());
            this.preview.getParent().setComponentZOrder(this.preview, 0);
        }
    }

    protected void destroyPreview() {
        if (this.preview != null) {
            this.preview.setVisible(false);
            this.preview.getParent().remove(this.preview);
            this.dragImage = null;
            this.preview = null;
        }
        this.marker.reset();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                ((mxCellHandler)iterator.next()).mouseMoved(mouseEvent);
            }
            if (!mouseEvent.isConsumed()) {
                this.graphComponent.getGraphControl().setCursor(this.getCursor(mouseEvent));
                mouseEvent.consume();
            }
        }
    }

    protected Cursor getCursor(MouseEvent mouseEvent) {
        Object object = this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), false);
        Cursor cursor = null;
        if (object != null) {
            if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(object, mouseEvent.getX(), mouseEvent.getY())) {
                cursor = new Cursor(12);
            } else if (this.graphComponent.getGraph().isMovable(object)) {
                cursor = DEFAULT_CURSOR;
            }
        }
        return cursor;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        block10: {
            boolean bl;
            JComponent jComponent = mxGraphHandler.getDropTarget(dropTargetDragEvent);
            TransferHandler transferHandler = jComponent.getTransferHandler();
            boolean bl2 = bl = transferHandler instanceof mxGraphTransferHandler && ((mxGraphTransferHandler)transferHandler).isLocalDrag();
            if (bl) {
                this.canImport = true;
            } else {
                boolean bl3 = this.canImport = this.graphComponent.isDropEnabled() && transferHandler.canImport(jComponent, dropTargetDragEvent.getCurrentDataFlavors());
            }
            if (this.canImport) {
                dropTargetDragEvent.acceptDrag(3);
                this.transferBounds = null;
                this.createPreview();
                try {
                    Transferable transferable = dropTargetDragEvent.getTransferable();
                    if (!transferable.isDataFlavorSupported(mxGraphTransferable.dataFlavor)) break block10;
                    mxGraphTransferable mxGraphTransferable2 = (mxGraphTransferable)transferable.getTransferData(mxGraphTransferable.dataFlavor);
                    this.dragCells = mxGraphTransferable2.getCells();
                    if (mxGraphTransferable2.getBounds() != null) {
                        mxGraph mxGraph2 = this.graphComponent.getGraph();
                        double d = mxGraph2.getView().getScale();
                        this.transferBounds = mxGraphTransferable2.getBounds();
                        mxRectangle mxRectangle2 = new mxRectangle(this.transferBounds);
                        mxRectangle2.setWidth(mxRectangle2.getWidth() * d);
                        mxRectangle2.setHeight(mxRectangle2.getHeight() * d);
                        this.preview.setBounds(mxRectangle2.getRectangle());
                        if (this.imagePreview) {
                            if (bl) {
                                this.updateDragImage(this.getMovableCells(Arrays.asList(this.dragCells)).toArray());
                            } else {
                                this.updateDragImage(this.dragCells);
                            }
                        }
                        this.preview.setVisible(true);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.graphComponent.getGraphControl().getToolTipText(SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this.graphComponent.getGraphControl()));
    }

    public String getHandleToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Iterator iterator = this.handlers.values().iterator();
        while (iterator.hasNext() && string == null) {
            string = ((mxCellHandler)iterator.next()).getToolTipText(mouseEvent);
        }
        return string;
    }

    public void dispatchMousePressed(MouseEvent mouseEvent) {
        Iterator iterator = this.handlers.values().iterator();
        while (iterator.hasNext() && !mouseEvent.isConsumed()) {
            ((mxCellHandler)iterator.next()).mousePressed(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed()) {
            this.initialCell = this.cell = this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), false);
            if (this.cell != null) {
                if (!this.graphComponent.getGraph().isSelected(this.cell) && !this.graphComponent.isToggleEvent(mouseEvent)) {
                    this.graphComponent.selectCellForEvent(this.cell, mouseEvent);
                    this.cell = null;
                }
                if (!mouseEvent.isPopupTrigger()) {
                    this.start(mouseEvent);
                    mouseEvent.consume();
                }
            } else if (mouseEvent.isPopupTrigger()) {
                this.graphComponent.getGraph().clearSelection();
            }
        }
    }

    public void start(MouseEvent mouseEvent) {
        this.start = mouseEvent.getPoint();
        this.createPreview();
        Rectangle rectangle = this.getBounds();
        rectangle.grow(-5, -5);
        this.preview.setBounds(rectangle);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.canImport) {
            this.mouseDragged(this.createEvent(dropTargetDragEvent));
            mxGraphTransferHandler mxGraphTransferHandler2 = mxGraphHandler.getGraphTransferHandler(dropTargetDragEvent);
            if (mxGraphTransferHandler2 != null) {
                double d = this.graphComponent.getGraph().getView().getScale();
                Point point = SwingUtilities.convertPoint(this.graphComponent, dropTargetDragEvent.getLocation(), this.graphComponent.getGraphControl());
                if (this.centerPreview && this.transferBounds != null) {
                    point.x = (int)((long)point.x - Math.round(this.transferBounds.getWidth() * d / 2.0));
                    point.y = (int)((long)point.y - Math.round(this.transferBounds.getHeight() * d / 2.0));
                }
                point = this.graphComponent.snapScaledPoint(new mxPoint(point)).getPoint();
                mxGraphTransferHandler2.setLocation(new Point(point));
                if (this.transferBounds != null && this.dragImage != null) {
                    int n = (int)Math.round(((double)(this.dragImage.getIconWidth() - 2) - this.transferBounds.getWidth() * d) / 2.0);
                    int n2 = (int)Math.round(((double)(this.dragImage.getIconHeight() - 2) - this.transferBounds.getHeight() * d) / 2.0);
                    point.translate(-n, -n2);
                }
                if (!mxGraphTransferHandler2.isLocalDrag()) {
                    this.preview.setLocation(point.x, point.y);
                }
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public Point convertPoint(Point point) {
        point = SwingUtilities.convertPoint(this.graphComponent, point, this.graphComponent.getGraphControl());
        point.x -= this.graphComponent.getHorizontalScrollBar().getValue();
        point.y -= this.graphComponent.getVerticalScrollBar().getValue();
        return point;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.graphComponent.getGraphControl().scrollRectToVisible(new Rectangle(mouseEvent.getPoint()));
        Iterator iterator = this.handlers.values().iterator();
        while (iterator.hasNext() && !mouseEvent.isConsumed()) {
            ((mxCellHandler)iterator.next()).mouseDragged(mouseEvent);
        }
        if (!mouseEvent.isConsumed() && this.preview != null) {
            this.gridEnabledEvent = this.graphComponent.isGridEnabledEvent(mouseEvent);
            this.constrainedEvent = this.graphComponent.isConstrainedEvent(mouseEvent);
            if (this.constrainedEvent && this.start != null) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (Math.abs(mouseEvent.getX() - this.start.x) > Math.abs(mouseEvent.getY() - this.start.y)) {
                    n2 = this.start.y;
                } else {
                    n = this.start.x;
                }
                mouseEvent = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
            if (this.preview.isVisible()) {
                this.marker.process(mouseEvent);
            } else if (this.cell != null && !this.graphComponent.getGraph().isSelected(this.cell) && this.graphComponent.isToggleEvent(mouseEvent)) {
                this.graphComponent.selectCellForEvent(this.cell, mouseEvent);
                this.cell = null;
            }
            if (this.start != null) {
                double d = mouseEvent.getX() - this.start.x;
                double d2 = mouseEvent.getY() - this.start.y;
                this.preview.setLocation(this.getPreviewLocation(mouseEvent, this.gridEnabledEvent));
                if (!this.preview.isVisible() && this.graphComponent.isSignificant(d, d2)) {
                    if (this.imagePreview && this.dragImage == null && !this.graphComponent.isDragEnabled()) {
                        this.updateDragImage(this.cells);
                    }
                    this.preview.setVisible(true);
                }
                mouseEvent.consume();
            }
        }
    }

    protected Point getPreviewLocation(MouseEvent mouseEvent, boolean bl) {
        int n = 0;
        int n2 = 0;
        if (this.start != null && this.previewBounds != null) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            double d = mxGraph2.getView().getScale();
            mxPoint mxPoint2 = mxGraph2.getView().getTranslate();
            double d2 = mouseEvent.getX() - this.start.x;
            double d3 = mouseEvent.getY() - this.start.y;
            double d4 = (this.previewBounds.getX() + d2) / d - mxPoint2.getX();
            double d5 = (this.previewBounds.getY() + d3) / d - mxPoint2.getY();
            if (this.gridEnabledEvent) {
                d4 = mxGraph2.snap(d4);
                d5 = mxGraph2.snap(d5);
            }
            n = (int)Math.round((d4 + mxPoint2.getX()) * d) + (int)Math.round(this.previewBbox.getX()) - (int)Math.round(this.previewBounds.getX());
            n2 = (int)Math.round((d5 + mxPoint2.getY()) * d) + (int)Math.round(this.previewBbox.getY()) - (int)Math.round(this.previewBounds.getY());
        }
        return new Point(n, n2);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        mxGraphTransferHandler mxGraphTransferHandler2 = mxGraphHandler.getGraphTransferHandler(dropTargetEvent);
        if (mxGraphTransferHandler2 != null) {
            mxGraphTransferHandler2.setLocation(null);
        }
        this.dragCells = null;
        this.destroyPreview();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.canImport) {
            mxGraphTransferHandler mxGraphTransferHandler2 = mxGraphHandler.getGraphTransferHandler(dropTargetDropEvent);
            MouseEvent mouseEvent = this.createEvent(dropTargetDropEvent);
            if (mxGraphTransferHandler2 != null && !mxGraphTransferHandler2.isLocalDrag()) {
                mouseEvent.consume();
            }
            this.mouseReleased(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            Iterator iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                ((mxCellHandler)iterator.next()).mouseReleased(mouseEvent);
            }
            if (!mouseEvent.isConsumed()) {
                double d = 0.0;
                double d2 = 0.0;
                if (this.start != null && this.cellBounds != null) {
                    double d3 = mxGraph2.getView().getScale();
                    mxPoint mxPoint2 = mxGraph2.getView().getTranslate();
                    d = mouseEvent.getX() - this.start.x;
                    d2 = mouseEvent.getY() - this.start.y;
                    double d4 = (this.cellBounds.getX() + d) / d3 - mxPoint2.getX();
                    double d5 = (this.cellBounds.getY() + d2) / d3 - mxPoint2.getY();
                    if (this.gridEnabledEvent) {
                        d4 = mxGraph2.snap(d4);
                        d5 = mxGraph2.snap(d5);
                    }
                    double d6 = (d4 + mxPoint2.getX()) * d3 + this.bbox.getX() - this.cellBounds.getX();
                    double d7 = (d5 + mxPoint2.getY()) * d3 + this.bbox.getY() - this.cellBounds.getY();
                    d = Math.round((d6 - this.bbox.getX()) / d3);
                    d2 = Math.round((d7 - this.bbox.getY()) / d3);
                }
                if (this.preview != null && this.preview.isVisible()) {
                    if (this.constrainedEvent) {
                        if (Math.abs(d) > Math.abs(d2)) {
                            d2 = 0.0;
                        } else {
                            d = 0.0;
                        }
                    }
                    this.move(this.cells, d, d2, mouseEvent);
                    mouseEvent.consume();
                } else if (this.start == null || !this.graphComponent.isSignificant(mouseEvent.getX() - this.start.x, mouseEvent.getY() - this.start.y)) {
                    if (this.cell != null && !mouseEvent.isPopupTrigger() && this.start != null) {
                        this.graphComponent.selectCellForEvent(this.cell, mouseEvent);
                    }
                    if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(this.initialCell, mouseEvent.getX(), mouseEvent.getY())) {
                        this.fold(this.initialCell);
                    } else {
                        Object object = this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY(), this.graphComponent.isSwimlaneSelectionEnabled());
                        if (this.cell == null && this.start == null) {
                            if (object == null) {
                                mxGraph2.clearSelection();
                            } else if (mxGraph2.isSwimlane(object) && this.graphComponent.getCanvas().hitSwimlaneContent(this.graphComponent, mxGraph2.getView().getState(object), mouseEvent.getX(), mouseEvent.getY())) {
                                this.graphComponent.selectCellForEvent(object, mouseEvent);
                            }
                        }
                        if (this.graphComponent.isFoldingEnabled() && this.graphComponent.hitFoldingIcon(object, mouseEvent.getX(), mouseEvent.getY())) {
                            this.fold(object);
                            mouseEvent.consume();
                        }
                    }
                }
            }
            this.reset();
        }
    }

    protected void fold(Object object) {
        if (this.graphComponent.getGraph().isCellCollapsed(object)) {
            this.graphComponent.getGraph().expand(new Object[]{object});
        } else {
            this.graphComponent.getGraph().collapse(new Object[]{object});
        }
    }

    public void reset() {
        Iterator iterator = this.handlers.values().iterator();
        while (iterator.hasNext()) {
            ((mxCellHandler)iterator.next()).reset();
        }
        this.destroyPreview();
        this.initialCell = null;
        this.dragCells = null;
        this.start = null;
        this.cell = null;
    }

    protected void move(Object[] objectArray, double d, double d2, MouseEvent mouseEvent) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        mxCellState mxCellState2 = this.marker.getValidState();
        Object object = mxCellState2 != null ? mxCellState2.getCell() : null;
        boolean bl = mouseEvent.isControlDown() && this.cloneEnabled;
        Object[] objectArray2 = mxGraph2.move(objectArray, d, d2, bl, object, mouseEvent.getPoint());
        if (bl && objectArray2.length == objectArray.length) {
            mxGraph2.setSelectionCells(objectArray2);
        } else {
            this.refresh();
        }
    }

    public mxCellHandler getHandler(Object object) {
        return (mxCellHandler)this.handlers.get(object);
    }

    public void refresh() {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        this.handlers.clear();
        Object[] objectArray = mxGraph2.getSelectionCells();
        boolean bl = objectArray.length <= this.maxHandles;
        for (int i = 0; i < objectArray.length; ++i) {
            mxCellState mxCellState2 = mxGraph2.getView().getState(objectArray[i]);
            if (mxCellState2 == null) continue;
            mxCellHandler mxCellHandler2 = this.graphComponent.createHandler(mxCellState2);
            mxCellHandler2.setHandlesVisible(bl);
            if (mxCellHandler2 == null) continue;
            this.handlers.put(objectArray[i], mxCellHandler2);
        }
        this.cells = this.getMovableCells(this.handlers.keySet()).toArray();
        this.setVisible(!this.handlers.isEmpty());
        if (this.isVisible()) {
            if (this.keepOnTop) {
                this.getParent().setComponentZOrder(this, 0);
            }
            this.cellBounds = mxGraph2.getView().getBounds(objectArray);
            this.bbox = mxGraph2.getView().getBoundingBox(objectArray);
            this.previewBounds = mxGraph2.getView().getBounds(this.cells);
            this.previewBbox = mxGraph2.getView().getBoundingBox(this.cells);
            if (this.bbox != null) {
                Rectangle rectangle = this.bbox.getRectangle();
                int n = Math.round(mxConstants.HANDLE_SIZE / 2) + 1;
                rectangle.grow(n, n);
                this.setBounds(rectangle);
            } else {
                this.setBounds(this.graphComponent.getViewport().getVisibleRect());
            }
            this.repaint();
        }
    }

    protected final Collection getMovableCells(Collection collection) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        Iterator iterator = collection.iterator();
        ArrayList arrayList = new ArrayList(collection.size());
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!mxGraph2.isMovable(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.translate(-this.getX(), -this.getY());
        Iterator iterator = this.handlers.values().iterator();
        while (iterator.hasNext()) {
            ((mxCellHandler)iterator.next()).paint(graphics);
        }
        graphics.translate(this.getX(), this.getY());
    }

    protected MouseEvent createEvent(DropTargetEvent dropTargetEvent) {
        JComponent jComponent = mxGraphHandler.getDropTarget(dropTargetEvent);
        Point point = null;
        int n = 0;
        if (dropTargetEvent instanceof DropTargetDropEvent) {
            point = ((DropTargetDropEvent)dropTargetEvent).getLocation();
            n = ((DropTargetDropEvent)dropTargetEvent).getDropAction();
        } else if (dropTargetEvent instanceof DropTargetDragEvent) {
            point = ((DropTargetDragEvent)dropTargetEvent).getLocation();
            n = ((DropTargetDragEvent)dropTargetEvent).getDropAction();
        }
        if (point != null) {
            point = this.convertPoint(point);
            Rectangle rectangle = this.graphComponent.getViewport().getViewRect();
            point.translate(rectangle.x, rectangle.y);
        }
        int n2 = n == 1 ? 2 : 0;
        return new MouseEvent(jComponent, 0, System.currentTimeMillis(), n2, (int)point.getX(), (int)point.getY(), 1, false, 1);
    }

    protected static final mxGraphTransferHandler getGraphTransferHandler(DropTargetEvent dropTargetEvent) {
        JComponent jComponent = mxGraphHandler.getDropTarget(dropTargetEvent);
        TransferHandler transferHandler = jComponent.getTransferHandler();
        if (transferHandler instanceof mxGraphTransferHandler) {
            return (mxGraphTransferHandler)transferHandler;
        }
        return null;
    }

    protected static final JComponent getDropTarget(DropTargetEvent dropTargetEvent) {
        return (JComponent)dropTargetEvent.getDropTargetContext().getComponent();
    }

    public class MouseRedirector
    implements MouseListener,
    MouseMotionListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            mxGraphHandler.this.graphComponent.getGraphControl().dispatchEvent(SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, mxGraphHandler.this.graphComponent.getGraphControl()));
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.mouseClicked(mouseEvent);
        }
    }
}

