/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.handler.mxConnectionHandler;
import com.mxgraph.swing.handler.mxEdgeHandler;
import com.mxgraph.swing.handler.mxElbowEdgeHandler;
import com.mxgraph.swing.handler.mxGraphHandler;
import com.mxgraph.swing.handler.mxGraphTransferHandler;
import com.mxgraph.swing.handler.mxPanningHandler;
import com.mxgraph.swing.handler.mxVertexHandler;
import com.mxgraph.swing.util.mxIOverlay;
import com.mxgraph.swing.util.mxOverlay;
import com.mxgraph.swing.view.mxCellEditor;
import com.mxgraph.swing.view.mxICellEditor;
import com.mxgraph.swing.view.mxInteractiveCanvas;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class mxGraphComponent
extends JScrollPane
implements Printable {
    public static final String EVENT_BEFORE_LABELCHANGED = "beforelabelchanged";
    public static final String EVENT_LABELCHANGED = "labelchanged";
    public static final String EVENT_AFTER_LABELCHANGED = "afterlabelchanged";
    public static final String EVENT_ADDOVERLAY = "addoverlay";
    public static final String EVENT_REMOVEOVERLAY = "removeoverlay";
    public static final String EVENT_BEFOREPAINT = "beforePaint";
    public static final String EVENT_AFTERPAINT = "afterPaint";
    public static final int GRID_STYLE_DOT = 0;
    public static final int GRID_STYLE_CROSS = 1;
    public static final int GRID_STYLE_LINE = 2;
    public static final int GRID_STYLE_DASHED = 3;
    public static final int ZOOM_POLICY_NONE = 0;
    public static final int ZOOM_POLICY_PAGE = 1;
    public static final int ZOOM_POLICY_WIDTH = 2;
    public static ImageIcon DEFAULT_EXPANDED_ICON = null;
    public static ImageIcon DEFAULT_COLLAPSED_ICON = null;
    public static ImageIcon DEFAULT_WARNING_ICON = null;
    public static final double DEFAULT_PAGESCALE = 1.4;
    protected mxGraph graph;
    protected mxGraphControl graphControl;
    protected mxEventSource eventSource = new mxEventSource(this);
    protected mxICellEditor cellEditor = new mxCellEditor(this);
    protected mxConnectionHandler connectionHandler;
    protected mxPanningHandler panningHandler;
    protected mxGraphHandler graphHandler;
    protected ImageIcon backgroundImage;
    protected PageFormat pageFormat = new PageFormat();
    protected mxInteractiveCanvas canvas;
    protected BufferedImage tripleBuffer;
    protected Graphics2D tripleBufferGraphics;
    protected double pageScale = 1.4;
    protected boolean pageVisible = false;
    protected boolean preferPageSize = false;
    protected boolean pageBreakVisible = true;
    protected int horizontalPageCount = 1;
    protected int verticalPageCount = 1;
    protected boolean centerPage = true;
    protected Color pageBackgroundColor = new Color(144, 153, 174);
    protected Color pageShadowColor = new Color(110, 120, 140);
    protected Color pageBorderColor = Color.black;
    protected boolean gridVisible = false;
    protected Color gridColor = new Color(192, 192, 192);
    protected boolean dragEnabled = true;
    protected boolean dropEnabled = true;
    protected boolean foldingEnabled = true;
    protected int tolerance = 4;
    protected boolean swimlaneSelectionEnabled = true;
    protected boolean transparentSwimlaneContent = true;
    protected int gridStyle = 3;
    protected ImageIcon expandedIcon = DEFAULT_EXPANDED_ICON;
    protected ImageIcon collapsedIcon = DEFAULT_COLLAPSED_ICON;
    protected ImageIcon warningIcon = DEFAULT_WARNING_ICON;
    protected boolean antiAlias = true;
    protected boolean textAntiAlias = true;
    protected boolean escapeEnabled = true;
    protected boolean invokesStopCellEditing = true;
    protected int zoomPolicy = 1;
    private transient boolean zooming = false;
    protected double zoomFactor = 1.2;
    protected boolean keepSelectionVisibleOnZoom = false;
    protected boolean centerZoom = true;
    protected boolean tripleBuffered = false;
    public boolean showDirtyRectangle = false;
    protected Hashtable components = new Hashtable();
    protected Hashtable overlays = new Hashtable();
    private transient boolean centerOnResize = true;
    protected mxEventSource.mxIEventListener updateHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, Object[] objectArray) {
            mxGraphComponent.this.updateComponents();
            mxGraphComponent.this.graphControl.updatePreferredSize();
        }
    };
    protected mxEventSource.mxIEventListener repaintHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, Object[] objectArray) {
            Rectangle rectangle;
            mxRectangle mxRectangle2 = objectArray.length > 0 ? (mxRectangle)objectArray[0] : null;
            Rectangle rectangle2 = rectangle = mxRectangle2 != null ? mxRectangle2.getRectangle() : null;
            if (rectangle != null) {
                rectangle.grow(1, 1);
            }
            mxGraphComponent.this.repaintTripleBuffer(rectangle);
            mxGraphComponent.this.graphControl.repaint(rectangle != null ? rectangle : mxGraphComponent.this.getViewport().getViewRect());
            JPanel jPanel = (JPanel)mxGraphComponent.this.getClientProperty("dirty");
            if (mxGraphComponent.this.showDirtyRectangle) {
                if (jPanel == null) {
                    jPanel = new JPanel();
                    jPanel.setOpaque(false);
                    jPanel.setBorder(BorderFactory.createLineBorder(Color.RED));
                    mxGraphComponent.this.putClientProperty("dirty", jPanel);
                    mxGraphComponent.this.graphControl.add(jPanel);
                }
                if (mxRectangle2 != null) {
                    jPanel.setBounds(mxRectangle2.getRectangle());
                }
                jPanel.setVisible(mxRectangle2 != null);
            } else if (jPanel != null && jPanel.getParent() != null) {
                jPanel.getParent().remove(jPanel);
                mxGraphComponent.this.putClientProperty("dirty", null);
                mxGraphComponent.this.repaint();
            }
        }
    };
    protected PropertyChangeListener viewChangeHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("view")) {
                mxGraphView mxGraphView2 = (mxGraphView)propertyChangeEvent.getOldValue();
                mxGraphView mxGraphView3 = (mxGraphView)propertyChangeEvent.getNewValue();
                if (mxGraphView2 != null) {
                    mxGraphView2.removeListener(mxGraphComponent.this.updateHandler);
                }
                if (mxGraphView3 != null) {
                    mxGraphView3.addListener(mxGraphView.EVENT_SCALE, mxGraphComponent.this.updateHandler);
                    mxGraphView3.addListener(mxGraphView.EVENT_TRANSLATE, mxGraphComponent.this.updateHandler);
                    mxGraphView3.addListener(mxGraphView.EVENT_SCALE_AND_TRANSLATE, mxGraphComponent.this.updateHandler);
                    mxGraphView3.addListener(mxGraphView.EVENT_UP, mxGraphComponent.this.updateHandler);
                    mxGraphView3.addListener(mxGraphView.EVENT_DOWN, mxGraphComponent.this.updateHandler);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("model")) {
                mxGraphModel mxGraphModel2 = (mxGraphModel)propertyChangeEvent.getOldValue();
                mxGraphModel mxGraphModel3 = (mxGraphModel)propertyChangeEvent.getNewValue();
                if (mxGraphModel2 != null) {
                    mxGraphModel2.removeListener(mxGraphComponent.this.updateHandler);
                }
                if (mxGraphModel3 != null) {
                    mxGraphModel3.addListener("change", mxGraphComponent.this.updateHandler);
                }
            }
        }
    };
    protected mxEventSource.mxIEventListener scaleHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, Object[] objectArray) {
            if (!mxGraphComponent.this.zooming) {
                mxGraphComponent.this.zoomPolicy = 0;
            }
        }
    };

    public mxGraphComponent(mxGraph mxGraph2) {
        this.canvas = this.createCanvas();
        this.graphControl = this.createGraphControl();
        this.graphControl.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!mxGraphComponent.this.hasFocus()) {
                    mxGraphComponent.this.requestFocus();
                }
            }
        });
        this.graphControl.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed() && mxGraphComponent.this.isEditEvent(mouseEvent)) {
                    Object object = mxGraphComponent.this.getCellAt(mouseEvent.getX(), mouseEvent.getY(), false);
                    if (object != null) {
                        mxGraphComponent.this.edit(object, mouseEvent);
                    }
                } else {
                    mxGraphComponent.this.stopEditing(!mxGraphComponent.this.invokesStopCellEditing);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    mxGraphComponent.this.escape(keyEvent);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                mxGraphComponent.this.zoomAndCenter();
            }
        });
        this.setGraph(mxGraph2);
        this.setTransferHandler(new mxGraphTransferHandler());
        this.setViewportView(this.graphControl);
        this.createHandlers();
    }

    public void setGraph(mxGraph mxGraph2) {
        if (this.graph != null) {
            this.graph.removeListener(this.repaintHandler);
            this.graph.getModel().removeListener(this.updateHandler);
            this.graph.getView().removeListener(this.updateHandler);
            this.graph.removePropertyChangeListener(this.viewChangeHandler);
            this.graph.getView().removeListener(this.scaleHandler);
        }
        this.graph = mxGraph2;
        mxGraph2.addListener(mxGraph.EVENT_REPAINT, this.repaintHandler);
        mxGraph2.getModel().addListener("change", this.updateHandler);
        mxGraphView mxGraphView2 = mxGraph2.getView();
        mxGraphView2.addListener(mxGraphView.EVENT_SCALE, this.updateHandler);
        mxGraphView2.addListener(mxGraphView.EVENT_TRANSLATE, this.updateHandler);
        mxGraphView2.addListener(mxGraphView.EVENT_SCALE_AND_TRANSLATE, this.updateHandler);
        mxGraphView2.addListener(mxGraphView.EVENT_UP, this.updateHandler);
        mxGraphView2.addListener(mxGraphView.EVENT_DOWN, this.updateHandler);
        mxGraph2.addPropertyChangeListener(this.viewChangeHandler);
        mxGraph2.getView().addListener(mxGraphView.EVENT_SCALE, this.scaleHandler);
        mxGraph2.getView().addListener(mxGraphView.EVENT_SCALE_AND_TRANSLATE, this.scaleHandler);
        this.updateHandler.invoke(mxGraph2.getView(), null);
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    protected mxGraphControl createGraphControl() {
        return new mxGraphControl();
    }

    public mxGraphControl getGraphControl() {
        return this.graphControl;
    }

    protected void createHandlers() {
        this.connectionHandler = this.createConnectionHandler();
        this.panningHandler = this.createPanningHandler();
        this.graphHandler = this.createGraphHandler();
    }

    protected mxGraphHandler createGraphHandler() {
        return new mxGraphHandler(this);
    }

    public mxGraphHandler getGraphHandler() {
        return this.graphHandler;
    }

    protected mxConnectionHandler createConnectionHandler() {
        return new mxConnectionHandler(this);
    }

    public mxConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    protected mxPanningHandler createPanningHandler() {
        return new mxPanningHandler(this);
    }

    public mxPanningHandler getPanningHandler() {
        return this.panningHandler;
    }

    public mxICellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(mxICellEditor mxICellEditor2) {
        mxICellEditor mxICellEditor3 = this.cellEditor;
        this.cellEditor = mxICellEditor2;
        this.firePropertyChange("cellEditor", mxICellEditor3, mxICellEditor2);
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int n) {
        int n2 = this.tolerance;
        this.tolerance = n;
        this.firePropertyChange("tolerance", n2, n);
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        PageFormat pageFormat2 = this.pageFormat;
        this.pageFormat = pageFormat;
        this.firePropertyChange("pageFormat", pageFormat2, pageFormat);
    }

    public double getPageScale() {
        return this.pageScale;
    }

    public void setPageScale(double d) {
        double d2 = this.pageScale;
        this.pageScale = d;
        this.firePropertyChange("pageScale", d2, d);
    }

    public mxRectangle getLayoutAreaSize() {
        if (this.pageVisible) {
            Dimension dimension = this.getPreferredSizeForPage();
            return new mxRectangle(new Rectangle(dimension));
        }
        return new mxRectangle(new Rectangle(this.graphControl.getSize()));
    }

    public ImageIcon getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(ImageIcon imageIcon) {
        ImageIcon imageIcon2 = this.backgroundImage;
        this.backgroundImage = imageIcon;
        this.firePropertyChange("backgroundImage", imageIcon2, this.backgroundImage);
    }

    public boolean isPageVisible() {
        return this.pageVisible;
    }

    public void setPageVisible(boolean bl) {
        boolean bl2 = this.pageVisible;
        this.pageVisible = bl;
        this.firePropertyChange("pageVisible", bl2, bl);
    }

    public boolean isPreferPageSize() {
        return this.preferPageSize;
    }

    public void setPreferPageSize(boolean bl) {
        boolean bl2 = this.preferPageSize;
        this.preferPageSize = bl;
        this.firePropertyChange("preferPageSize", bl2, bl);
    }

    public boolean isPageBreakVisible() {
        return this.pageBreakVisible;
    }

    public void setPageBreakVisible(boolean bl) {
        boolean bl2 = this.pageBreakVisible;
        this.pageBreakVisible = bl;
        this.firePropertyChange("pageBreakVisible", bl2, this.pageVisible);
    }

    public void setHorizontalPageCount(int n) {
        int n2 = this.horizontalPageCount;
        this.horizontalPageCount = n;
        this.firePropertyChange("horizontalPageCount", n2, n);
    }

    public int getHorizontalPageCount() {
        return this.horizontalPageCount;
    }

    public void setVerticalPageCount(int n) {
        int n2 = this.verticalPageCount;
        this.verticalPageCount = n;
        this.firePropertyChange("verticalPageCount", n2, n);
    }

    public int getVerticalPageCount() {
        return this.horizontalPageCount;
    }

    public boolean isCenterPage() {
        return this.centerPage;
    }

    public void setCenterPage(boolean bl) {
        boolean bl2 = this.centerPage;
        this.centerPage = bl;
        this.firePropertyChange("centerPage", bl2, bl);
    }

    public Color getPageBackgroundColor() {
        return this.pageBackgroundColor;
    }

    public void setPageBackgroundColor(Color color) {
        Color color2 = this.pageBackgroundColor;
        this.pageBackgroundColor = color;
        this.firePropertyChange("pageBackgroundColor", color2, color);
    }

    public Color getPageShadowColor() {
        return this.pageShadowColor;
    }

    public void setPageShadowColor(Color color) {
        Color color2 = this.pageShadowColor;
        this.pageShadowColor = color;
        this.firePropertyChange("pageShadowColor", color2, color);
    }

    public Color getPageBorderColor() {
        return this.pageBorderColor;
    }

    public void setPageBorderColor(Color color) {
        Color color2 = this.pageBorderColor;
        this.pageBorderColor = color;
        this.firePropertyChange("pageBorderColor", color2, color);
    }

    public boolean isKeepSelectionVisibleOnZoom() {
        return this.keepSelectionVisibleOnZoom;
    }

    public void setKeepSelectionVisibleOnZoom(boolean bl) {
        boolean bl2 = this.keepSelectionVisibleOnZoom;
        this.keepSelectionVisibleOnZoom = bl;
        this.firePropertyChange("keepSelectionVisibleOnZoom", bl2, bl);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double d) {
        double d2 = this.zoomFactor;
        this.zoomFactor = d;
        this.firePropertyChange("zoomFactor", d2, d);
    }

    public boolean isCenterZoom() {
        return this.centerZoom;
    }

    public void setCenterZoom(boolean bl) {
        boolean bl2 = this.centerZoom;
        this.centerZoom = bl;
        this.firePropertyChange("centerZoom", bl2, bl);
    }

    public void setZoomPolicy(int n) {
        int n2 = this.zoomPolicy;
        this.zoomPolicy = n;
        if (n != 0) {
            this.zoom(n == 1, true);
        }
        this.firePropertyChange("zoomPolicy", n2, n);
    }

    public int getZoomPolicy() {
        return this.zoomPolicy;
    }

    public void escape(KeyEvent keyEvent) {
        if (this.escapeEnabled) {
            this.cellEditor.stopEditing(true);
            this.graphHandler.reset();
            this.connectionHandler.reset();
        }
    }

    public Object[] importCells(Object[] objectArray, double d, double d2, Object object, Point point) {
        return this.graph.move(objectArray, d, d2, true, object, point);
    }

    public void refresh() {
        this.graph.refresh();
        this.graphHandler.refresh();
    }

    public mxPoint getPointForEvent(MouseEvent mouseEvent) {
        double d = this.graph.getView().getScale();
        mxPoint mxPoint2 = this.graph.getView().getTranslate();
        double d2 = this.graph.snap((double)mouseEvent.getX() / d - mxPoint2.getX() - (double)(this.graph.getGridSize() / 2));
        double d3 = this.graph.snap((double)mouseEvent.getY() / d - mxPoint2.getY() - (double)(this.graph.getGridSize() / 2));
        return new mxPoint(d2, d3);
    }

    public void edit() {
        this.edit(null);
    }

    public void edit(EventObject eventObject) {
        this.edit(null, eventObject);
    }

    public void edit(Object object, EventObject eventObject) {
        if (object == null) {
            object = this.graph.getSelectionCell();
        }
        if (object != null && this.graph.isEditable(object)) {
            this.startEditingAtCell(object, eventObject);
        }
    }

    public void startEditingAtCell(Object object, EventObject eventObject) {
        this.cellEditor.startEditing(object, eventObject);
    }

    public String getEditingValue(Object object, EventObject eventObject) {
        return this.graph.convertValueToString(object);
    }

    public void stopEditing(boolean bl) {
        this.cellEditor.stopEditing(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void labelChanged(Object object, Object object2, EventObject eventObject) {
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        Object object3 = mxIGraphModel2.getValue(object);
        this.eventSource.fireEvent(EVENT_BEFORE_LABELCHANGED, new Object[]{object, object3, object2, eventObject});
        mxIGraphModel2.beginUpdate();
        try {
            this.setLabelForCell(object, object2);
            if (this.graph.isUpdateSize(object)) {
                this.graph.updateSize(object);
            }
            this.eventSource.fireEvent(EVENT_LABELCHANGED, new Object[]{object, object3, object2, eventObject});
        }
        finally {
            mxIGraphModel2.endUpdate();
        }
        this.eventSource.fireEvent(EVENT_AFTER_LABELCHANGED, new Object[]{object, object3, object2, eventObject});
    }

    protected void setLabelForCell(Object object, Object object2) {
        this.graph.getModel().setValue(object, object2);
    }

    protected Dimension getPreferredSizeForPage() {
        return new Dimension((int)Math.round(this.pageFormat.getWidth() * this.pageScale * (double)this.horizontalPageCount), (int)Math.round(this.pageFormat.getHeight() * this.pageScale * (double)this.verticalPageCount));
    }

    public int getVerticalPageBorder() {
        return (int)Math.round(this.pageFormat.getWidth() * this.pageScale);
    }

    public int getHorizontalPageBorder() {
        return (int)Math.round(0.5 * this.pageFormat.getHeight() * this.pageScale);
    }

    protected Dimension getScaledPreferredSizeForGraph() {
        mxRectangle mxRectangle2 = this.graph.getBounds();
        int n = this.graph.getBorder();
        return new Dimension((int)Math.round(mxRectangle2.getWidth()) + n + 1, (int)Math.round(mxRectangle2.getHeight()) + n + 1);
    }

    protected mxPoint getPageTranslate(double d) {
        Dimension dimension = this.getPreferredSizeForPage();
        Dimension dimension2 = new Dimension(dimension);
        if (!this.preferPageSize) {
            dimension2.width += 2 * this.getHorizontalPageBorder();
            dimension2.height += 2 * this.getVerticalPageBorder();
        }
        double d2 = Math.max((double)dimension2.width, (double)(this.getViewport().getWidth() - 8) / d);
        double d3 = Math.max((double)dimension2.height, (double)(this.getViewport().getHeight() - 8) / d);
        double d4 = Math.max(0.0, (d2 - (double)dimension.width) / 2.0);
        double d5 = Math.max(0.0, (d3 - (double)dimension.height) / 2.0);
        return new mxPoint(d4, d5);
    }

    public void zoomAndCenter() {
        if (this.zoomPolicy != 0) {
            this.zoom(this.zoomPolicy == 1, this.centerOnResize || this.zoomPolicy == 1);
            this.centerOnResize = false;
        } else if (this.pageVisible && this.centerPage) {
            mxPoint mxPoint2 = this.getPageTranslate(this.graph.getView().getScale());
            this.graph.getView().setTranslate(mxPoint2);
        } else {
            this.getGraphControl().updatePreferredSize();
        }
    }

    public void zoomIn() {
        mxGraphView mxGraphView2 = this.graph.getView();
        double d = (double)((int)(mxGraphView2.getScale() * 100.0 * this.zoomFactor)) / 100.0;
        if (d == mxGraphView2.getScale()) {
            d += 0.01;
        }
        if (d > 0.0) {
            mxPoint mxPoint2 = this.pageVisible && this.centerPage ? this.getPageTranslate(d) : new mxPoint();
            this.graph.getView().scaleAndTranslate(d, mxPoint2.getX(), mxPoint2.getY());
            if (this.keepSelectionVisibleOnZoom && !this.graph.isSelectionEmpty()) {
                this.getGraphControl().scrollRectToVisible(mxGraphView2.getBoundingBox(this.graph.getSelectionCells()).getRectangle());
            } else {
                this.maintainScrollBar(true, this.zoomFactor, this.centerZoom);
                this.maintainScrollBar(false, this.zoomFactor, this.centerZoom);
            }
        }
    }

    public void zoomOut() {
        mxGraphView mxGraphView2 = this.graph.getView();
        double d = (double)((int)(mxGraphView2.getScale() * 100.0 / this.zoomFactor)) / 100.0;
        if (d >= 0.01) {
            mxPoint mxPoint2 = this.pageVisible && this.centerPage ? this.getPageTranslate(d) : new mxPoint();
            this.graph.getView().scaleAndTranslate(d, mxPoint2.getX(), mxPoint2.getY());
            if (this.keepSelectionVisibleOnZoom && !this.graph.isSelectionEmpty()) {
                this.getGraphControl().scrollRectToVisible(mxGraphView2.getBoundingBox(this.graph.getSelectionCells()).getRectangle());
            } else {
                this.maintainScrollBar(true, 1.0 / this.zoomFactor, this.centerZoom);
                this.maintainScrollBar(false, 1.0 / this.zoomFactor, this.centerZoom);
            }
        }
    }

    public void zoomTo(final double d, final boolean bl) {
        mxGraphView mxGraphView2 = this.graph.getView();
        final double d2 = mxGraphView2.getScale();
        mxPoint mxPoint2 = this.pageVisible && this.centerPage ? this.getPageTranslate(d) : new mxPoint();
        this.graph.getView().scaleAndTranslate(d, mxPoint2.getX(), mxPoint2.getY());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                mxGraphComponent.this.maintainScrollBar(true, d / d2, bl);
                mxGraphComponent.this.maintainScrollBar(false, d / d2, bl);
            }
        });
    }

    public void zoomActual() {
        mxPoint mxPoint2 = this.pageVisible && this.centerPage ? this.getPageTranslate(1.0) : new mxPoint();
        this.graph.getView().scaleAndTranslate(1.0, mxPoint2.getX(), mxPoint2.getY());
        if (this.isPageVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JScrollBar jScrollBar;
                    Dimension dimension = mxGraphComponent.this.getPreferredSizeForPage();
                    if ((double)mxGraphComponent.this.getViewport().getWidth() > dimension.getWidth()) {
                        mxGraphComponent.this.scrollToCenter(true);
                    } else {
                        jScrollBar = mxGraphComponent.this.getHorizontalScrollBar();
                        if (jScrollBar != null) {
                            jScrollBar.setValue(jScrollBar.getMaximum() / 3 - 4);
                        }
                    }
                    if ((double)mxGraphComponent.this.getViewport().getHeight() > dimension.getHeight()) {
                        mxGraphComponent.this.scrollToCenter(false);
                    } else {
                        jScrollBar = mxGraphComponent.this.getVerticalScrollBar();
                        if (jScrollBar != null) {
                            jScrollBar.setValue(jScrollBar.getMaximum() / 4 - 4);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoom(final boolean bl, final boolean bl2) {
        if (this.pageVisible && !this.zooming) {
            this.zooming = true;
            try {
                double d = this.getViewport().getWidth() - 8;
                double d2 = this.getViewport().getHeight() - 8;
                Dimension dimension = this.getPreferredSizeForPage();
                double d3 = dimension.width;
                double d4 = dimension.height;
                double d5 = d / d3;
                double d6 = bl ? d2 / d4 : d5;
                double d7 = (double)((int)(Math.min(d5, d6) * 20.0)) / 20.0;
                if (d7 > 0.0) {
                    mxGraphView mxGraphView2 = this.graph.getView();
                    double d8 = mxGraphView2.getScale();
                    mxPoint mxPoint2 = this.centerPage ? this.getPageTranslate(d7) : new mxPoint();
                    mxGraphView2.scaleAndTranslate(d7, mxPoint2.getX(), mxPoint2.getY());
                    final double d9 = d7 / d8;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (bl2) {
                                if (bl) {
                                    mxGraphComponent.this.scrollToCenter(true);
                                    mxGraphComponent.this.scrollToCenter(false);
                                } else {
                                    mxGraphComponent.this.scrollToCenter(true);
                                    mxGraphComponent.this.maintainScrollBar(false, d9, false);
                                }
                            } else if (d9 != 1.0) {
                                mxGraphComponent.this.maintainScrollBar(true, d9, false);
                                mxGraphComponent.this.maintainScrollBar(false, d9, false);
                            }
                        }
                    });
                }
            }
            finally {
                this.zooming = false;
            }
        }
    }

    protected void maintainScrollBar(boolean bl, double d, boolean bl2) {
        JScrollBar jScrollBar;
        JScrollBar jScrollBar2 = jScrollBar = bl ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
        if (jScrollBar != null) {
            BoundedRangeModel boundedRangeModel = jScrollBar.getModel();
            int n = (int)Math.round((double)boundedRangeModel.getValue() * d) + (int)Math.round(bl2 ? (double)boundedRangeModel.getExtent() * (d - 1.0) / 2.0 : 0.0);
            boundedRangeModel.setValue(n);
        }
    }

    public void scrollToCenter(boolean bl) {
        JScrollBar jScrollBar;
        JScrollBar jScrollBar2 = jScrollBar = bl ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
        if (jScrollBar != null) {
            BoundedRangeModel boundedRangeModel = jScrollBar.getModel();
            int n = boundedRangeModel.getMaximum() / 2 - boundedRangeModel.getExtent() / 2;
            boundedRangeModel.setValue(n);
        }
    }

    public void scrollCellToVisible(Object object) {
        mxCellState mxCellState2 = this.graph.getView().getState(object);
        if (mxCellState2 != null) {
            this.scrollRectToVisible(mxCellState2.getRectangle());
        }
    }

    public Object getCellAt(int n, int n2) {
        return this.getCellAt(n, n2, true);
    }

    public Object getCellAt(int n, int n2, boolean bl) {
        return this.getCellAt(n, n2, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCellAt(int n, int n2, boolean bl, Object object) {
        if (object == null) {
            object = this.graph.getDefaultParent();
        }
        if (object != null) {
            Point point = this.canvas.getTranslate();
            double d = this.canvas.getScale();
            try {
                this.canvas.setScale(this.graph.getView().getScale());
                this.canvas.setTranslate(0, 0);
                mxIGraphModel mxIGraphModel2 = this.graph.getModel();
                mxGraphView mxGraphView2 = this.graph.getView();
                Rectangle rectangle = new Rectangle(n, n2, 1, 1);
                int n3 = mxIGraphModel2.getChildCount(object);
                for (int i = n3 - 1; i >= 0; --i) {
                    Object object2;
                    Object object3 = mxIGraphModel2.getChildAt(object, i);
                    Object object4 = this.getCellAt(n, n2, bl, object3);
                    if (object4 != null) {
                        object2 = object4;
                        return object2;
                    }
                    if (!this.graph.isCellVisible(object3) || (object2 = mxGraphView2.getState(object3)) == null || !this.canvas.intersects(this, rectangle, (mxCellState)object2) || this.graph.isSwimlane(object3) && !bl && (!this.transparentSwimlaneContent || this.canvas.hitSwimlaneContent(this, (mxCellState)object2, n, n2))) continue;
                    Object object5 = object3;
                    return object5;
                }
            }
            finally {
                this.canvas.setScale(d);
                this.canvas.setTranslate(point.x, point.y);
            }
        }
        return null;
    }

    public void setSwimlaneSelectionEnabled(boolean bl) {
        boolean bl2 = this.swimlaneSelectionEnabled;
        this.swimlaneSelectionEnabled = bl;
        this.firePropertyChange("swimlaneSelectionEnabled", bl2, bl);
    }

    public boolean isSwimlaneSelectionEnabled() {
        return this.swimlaneSelectionEnabled;
    }

    public Object[] selectRegion(Rectangle rectangle, MouseEvent mouseEvent) {
        Object[] objectArray = this.getCells(rectangle);
        if (objectArray.length > 0) {
            this.selectCellsForEvent(objectArray, mouseEvent);
        } else if (!this.graph.isSelectionEmpty() && !mouseEvent.isConsumed()) {
            this.graph.clearSelection();
        }
        return objectArray;
    }

    public Object[] getCells(Rectangle rectangle) {
        return this.getCells(rectangle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getCells(Rectangle rectangle, Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (rectangle.width > 0 || rectangle.height > 0) {
            if (object == null) {
                object = this.graph.getDefaultParent();
            }
            if (object != null) {
                Point point = this.canvas.getTranslate();
                double d = this.canvas.getScale();
                try {
                    this.canvas.setScale(this.graph.getView().getScale());
                    this.canvas.setTranslate(0, 0);
                    mxIGraphModel mxIGraphModel2 = this.graph.getModel();
                    mxGraphView mxGraphView2 = this.graph.getView();
                    int n = mxIGraphModel2.getChildCount(object);
                    for (int i = 0; i < n; ++i) {
                        Object object2 = mxIGraphModel2.getChildAt(object, i);
                        mxCellState mxCellState2 = mxGraphView2.getState(object2);
                        if (!this.graph.isCellVisible(object2) || mxCellState2 == null) continue;
                        if (this.canvas.contains(this, rectangle, mxCellState2)) {
                            arrayList.add(object2);
                            continue;
                        }
                        arrayList.addAll(Arrays.asList(this.getCells(rectangle, object2)));
                    }
                }
                finally {
                    this.canvas.setScale(d);
                    this.canvas.setTranslate(point.x, point.y);
                }
            }
        }
        return arrayList.toArray();
    }

    public void selectCellsForEvent(Object[] objectArray, MouseEvent mouseEvent) {
        if (this.isToggleEvent(mouseEvent)) {
            this.graph.getSelectionModel().addCells(objectArray);
        } else {
            this.graph.getSelectionModel().setCells(objectArray);
        }
    }

    public void selectCellForEvent(Object object, MouseEvent mouseEvent) {
        boolean bl = this.graph.isSelected(object);
        if (this.isToggleEvent(mouseEvent)) {
            if (bl) {
                this.graph.getSelectionModel().removeCell(object);
            } else {
                this.graph.getSelectionModel().addCell(object);
            }
        } else if (!bl || this.graph.getSelectionCount() != 1) {
            this.graph.setSelectionCell(object);
        }
    }

    public boolean isSignificant(double d, double d2) {
        return Math.abs(d) > (double)this.tolerance || Math.abs(d2) > (double)this.tolerance;
    }

    public ImageIcon getFoldingIcon(mxCellState mxCellState2) {
        Object object;
        boolean bl;
        if (mxCellState2 != null && ((bl = this.graph.isCellCollapsed(object = mxCellState2.getCell())) && this.graph.isExpandable(object) || !bl && this.graph.isCollapsable(object))) {
            return bl ? this.collapsedIcon : this.expandedIcon;
        }
        return null;
    }

    public Rectangle getFoldingIconBounds(mxCellState mxCellState2, ImageIcon imageIcon) {
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        boolean bl = mxIGraphModel2.isEdge(mxCellState2.getCell());
        double d = this.getGraph().getView().getScale();
        int n = (int)Math.round(mxCellState2.getX() + 4.0 * d);
        int n2 = (int)Math.round(mxCellState2.getY() + 4.0 * d);
        int n3 = (int)Math.max(8.0, (double)imageIcon.getIconWidth() * d);
        int n4 = (int)Math.max(8.0, (double)imageIcon.getIconHeight() * d);
        if (bl) {
            mxPoint mxPoint2 = this.graph.getView().getPoint(mxCellState2);
            n = (int)mxPoint2.getX() - n3 / 2;
            n2 = (int)mxPoint2.getY() - n4 / 2;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public boolean hitFoldingIcon(Object object, int n, int n2) {
        if (object != null) {
            ImageIcon imageIcon;
            mxCellState mxCellState2;
            mxIGraphModel mxIGraphModel2 = this.graph.getModel();
            boolean bl = mxIGraphModel2.isEdge(object);
            if (this.foldingEnabled && (mxIGraphModel2.isVertex(object) || bl) && (mxCellState2 = this.graph.getView().getState(object)) != null && (imageIcon = this.getFoldingIcon(mxCellState2)) != null) {
                return this.getFoldingIconBounds(mxCellState2, imageIcon).contains(n, n2);
            }
        }
        return false;
    }

    public void setToolTips(boolean bl) {
        if (bl) {
            ToolTipManager.sharedInstance().registerComponent(this.graphControl);
            ToolTipManager.sharedInstance().registerComponent(this.graphHandler);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this.graphControl);
            ToolTipManager.sharedInstance().unregisterComponent(this.graphHandler);
        }
    }

    public boolean isConnectable() {
        return this.connectionHandler.isEnabled();
    }

    public void setConnectable(boolean bl) {
        this.connectionHandler.setEnabled(bl);
    }

    public boolean isPanning() {
        return this.panningHandler.isEnabled();
    }

    public void setPanning(boolean bl) {
        this.panningHandler.setEnabled(bl);
    }

    public boolean isEscapeEnabled() {
        return this.escapeEnabled;
    }

    public void setEscapeEnabled(boolean bl) {
        boolean bl2 = this.escapeEnabled;
        this.escapeEnabled = bl;
        this.firePropertyChange("escapeEnabled", bl2, bl);
    }

    public boolean isInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public void setInvokesStopCellEditing(boolean bl) {
        boolean bl2 = this.invokesStopCellEditing;
        this.invokesStopCellEditing = bl;
        this.firePropertyChange("invokesStopCellEditing", bl2, bl);
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        boolean bl2 = this.dragEnabled;
        this.dragEnabled = bl;
        this.firePropertyChange("dragEnabled", bl2, bl);
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean bl) {
        boolean bl2 = this.gridVisible;
        this.gridVisible = bl;
        this.firePropertyChange("gridVisible", bl2, bl);
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean bl) {
        boolean bl2 = this.antiAlias;
        this.antiAlias = bl;
        this.firePropertyChange("antiAlias", bl2, bl);
    }

    public boolean isTextAntiAlias() {
        return this.antiAlias;
    }

    public void setTextAntiAlias(boolean bl) {
        boolean bl2 = this.textAntiAlias;
        this.textAntiAlias = bl;
        this.firePropertyChange("textAntiAlias", bl2, bl);
    }

    public boolean isTripleBuffered() {
        return this.tripleBuffered;
    }

    public boolean isForceTripleBuffered() {
        return false;
    }

    public void setTripleBuffered(boolean bl) {
        boolean bl2 = this.tripleBuffered;
        this.tripleBuffered = bl;
        this.firePropertyChange("tripleBuffered", bl2, bl);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        Color color2 = this.gridColor;
        this.gridColor = color;
        this.firePropertyChange("gridColor", color2, color);
    }

    public int getGridStyle() {
        return this.gridStyle;
    }

    public void setGridStyle(int n) {
        int n2 = this.gridStyle;
        this.gridStyle = n;
        this.firePropertyChange("gridStyle", n2, n);
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean bl) {
        boolean bl2 = this.dropEnabled;
        this.dropEnabled = bl;
        this.firePropertyChange("dropEnabled", bl2, bl);
    }

    public boolean isFoldingEnabled() {
        return this.foldingEnabled;
    }

    public void setFoldingEnabled(boolean bl) {
        boolean bl2 = this.foldingEnabled;
        this.foldingEnabled = bl;
        this.firePropertyChange("foldingEnabled", bl2, bl);
    }

    public boolean isEditEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? mouseEvent.getClickCount() == 2 : false;
    }

    public boolean isToggleEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? mouseEvent.isControlDown() : false;
    }

    public boolean isGridEnabledEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? !mouseEvent.isAltDown() : false;
    }

    public boolean isPanningEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? mouseEvent.isAltDown() : false;
    }

    public boolean isConstrainedEvent(MouseEvent mouseEvent) {
        return mouseEvent != null ? mouseEvent.isShiftDown() : false;
    }

    public mxPoint snapScaledPoint(mxPoint mxPoint2) {
        return this.snapScaledPoint(mxPoint2, 0.0, 0.0);
    }

    public mxPoint snapScaledPoint(mxPoint mxPoint2, double d, double d2) {
        if (mxPoint2 != null) {
            double d3 = this.graph.getView().getScale();
            mxPoint mxPoint3 = this.graph.getView().getTranslate();
            mxPoint2.setX((this.graph.snap(mxPoint2.getX() / d3 - mxPoint3.getX() + d / d3) + mxPoint3.getX()) * d3 - d);
            mxPoint2.setY((this.graph.snap(mxPoint2.getY() / d3 - mxPoint3.getY() + d2 / d3) + mxPoint3.getY()) * d3 - d2);
        }
        return mxPoint2;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        double d = 1.0;
        Dimension dimension = this.graph.getBounds().getRectangle().getSize();
        int n3 = (int)(pageFormat.getWidth() * d);
        int n4 = (int)(pageFormat.getHeight() * d);
        int n5 = (int)Math.max(Math.ceil((double)(dimension.width - 5) / (double)n3), 1.0);
        if (n < n5 * (n2 = (int)Math.max(Math.ceil((double)(dimension.height - 5) / (double)n4), 1.0))) {
            Object object;
            AffineTransform affineTransform = ((Graphics2D)graphics).getTransform();
            RepaintManager repaintManager = RepaintManager.currentManager(this);
            repaintManager.setDoubleBufferingEnabled(false);
            int n6 = (int)((double)(n % n5) * pageFormat.getWidth());
            int n7 = (int)((double)(n % n2) * pageFormat.getHeight());
            if (this.pageVisible) {
                object = this.graph.getView().getTranslate();
                double d2 = this.graph.getView().getScale();
                n6 += (int)Math.round(((mxPoint)object).getX() * d2);
                n7 += (int)Math.round(((mxPoint)object).getY() * d2);
            }
            graphics.translate(-n6, -n7);
            graphics.setClip(n6, n7, (int)((double)n6 + pageFormat.getWidth()), (int)((double)n7 + pageFormat.getHeight()));
            object = this.createCanvas();
            ((mxGraphics2DCanvas)object).setGraphics((Graphics2D)graphics);
            this.graph.draw((mxICanvas)object);
            ((Graphics2D)graphics).setTransform(affineTransform);
            repaintManager.setDoubleBufferingEnabled(true);
            return 0;
        }
        return 1;
    }

    public mxInteractiveCanvas getCanvas() {
        return this.canvas;
    }

    public BufferedImage getTripleBuffer() {
        return this.tripleBuffer;
    }

    public mxInteractiveCanvas createCanvas() {
        return new mxInteractiveCanvas();
    }

    public mxCellHandler createHandler(mxCellState mxCellState2) {
        if (this.graph.getModel().isVertex(mxCellState2.getCell())) {
            return new mxVertexHandler(this, mxCellState2);
        }
        if (this.graph.getModel().isEdge(mxCellState2.getCell())) {
            mxEdgeStyle.mxEdgeStyleFunction mxEdgeStyleFunction2 = this.graph.getView().getEdgeStyle(mxCellState2, null, null);
            if (this.graph.isLoop(mxCellState2) || mxEdgeStyleFunction2 == mxEdgeStyle.ElbowConnector || mxEdgeStyleFunction2 == mxEdgeStyle.SideToSide || mxEdgeStyleFunction2 == mxEdgeStyle.TopToBottom) {
                return new mxElbowEdgeHandler(this, mxCellState2);
            }
            return new mxEdgeHandler(this, mxCellState2);
        }
        return new mxCellHandler(this, mxCellState2);
    }

    public Component[] createComponents(mxCellState mxCellState2) {
        return null;
    }

    public void insertComponent(mxCellState mxCellState2, Component component) {
        this.getGraphControl().add(component, 0);
    }

    public void removeComponent(Component component, Object object) {
        if (component.getParent() != null) {
            component.getParent().remove(component);
        }
    }

    public void updateComponent(mxCellState mxCellState2, Component component) {
        component.setBounds((int)mxCellState2.getX(), (int)mxCellState2.getY(), (int)mxCellState2.getWidth(), (int)mxCellState2.getHeight());
    }

    public void updateComponents() {
        Object object = this.graph.getModel().getRoot();
        Hashtable hashtable = this.updateComponents(object);
        this.removeAllComponents(this.components);
        this.components = hashtable;
        if (!this.overlays.isEmpty()) {
            hashtable = this.updateOverlays(object);
            this.removeAllOverlays(this.overlays);
            this.overlays = hashtable;
        }
    }

    public void removeAllComponents(Hashtable hashtable) {
        for (Map.Entry entry : hashtable.entrySet()) {
            Component[] componentArray = (Component[])entry.getValue();
            for (int i = 0; i < componentArray.length; ++i) {
                this.removeComponent(componentArray[i], entry.getKey());
            }
        }
    }

    public void removeAllOverlays(Hashtable hashtable) {
        for (Map.Entry entry : hashtable.entrySet()) {
            mxIOverlay[] mxIOverlayArray = (mxIOverlay[])entry.getValue();
            for (int i = 0; i < mxIOverlayArray.length; ++i) {
                this.removeOverlayComponent(mxIOverlayArray[i], entry.getKey());
            }
        }
    }

    public Hashtable updateComponents(Object object) {
        int n;
        Hashtable<Object, Component[]> hashtable = new Hashtable<Object, Component[]>();
        Component[] componentArray = (Component[])this.components.remove(object);
        mxCellState mxCellState2 = this.getGraph().getView().getState(object);
        if (mxCellState2 != null) {
            if (componentArray == null && (componentArray = this.createComponents(mxCellState2)) != null) {
                for (n = 0; n < componentArray.length; ++n) {
                    this.insertComponent(mxCellState2, componentArray[n]);
                }
            }
            if (componentArray != null) {
                hashtable.put(object, componentArray);
                for (n = 0; n < componentArray.length; ++n) {
                    this.updateComponent(mxCellState2, componentArray[n]);
                }
            }
        }
        n = this.getGraph().getModel().getChildCount(object);
        for (int i = 0; i < n; ++i) {
            hashtable.putAll(this.updateComponents(this.getGraph().getModel().getChildAt(object, i)));
        }
        return hashtable;
    }

    public mxIOverlay addOverlay(Object object, mxIOverlay mxIOverlay2) {
        Object object2;
        mxIOverlay[] mxIOverlayArray = this.getOverlays(object);
        if (mxIOverlayArray == null) {
            mxIOverlayArray = new mxIOverlay[]{mxIOverlay2};
        } else {
            object2 = new mxIOverlay[mxIOverlayArray.length + 1];
            System.arraycopy(mxIOverlayArray, 0, object2, 0, mxIOverlayArray.length);
            object2[mxIOverlayArray.length] = mxIOverlay2;
            mxIOverlayArray = object2;
        }
        this.overlays.put(object, mxIOverlayArray);
        object2 = this.graph.getView().getState(object);
        if (object2 != null) {
            this.updateOverlayComponent((mxCellState)object2, mxIOverlay2);
        }
        this.eventSource.fireEvent(EVENT_ADDOVERLAY, new Object[]{object, mxIOverlay2});
        return mxIOverlay2;
    }

    public mxIOverlay[] getOverlays(Object object) {
        return (mxIOverlay[])this.overlays.get(object);
    }

    public mxIOverlay removeOverlay(Object object, mxIOverlay mxIOverlay2) {
        if (mxIOverlay2 == null) {
            this.removeOverlays(object);
        } else {
            mxIOverlay[] mxIOverlayArray = this.getOverlays(object);
            if (mxIOverlayArray != null) {
                List<mxIOverlay> list = Arrays.asList(mxIOverlayArray);
                if (list.remove(mxIOverlay2)) {
                    this.removeOverlayComponent(mxIOverlay2, object);
                }
                mxIOverlayArray = (mxIOverlay[])list.toArray();
                this.overlays.put(object, mxIOverlayArray);
            }
        }
        return mxIOverlay2;
    }

    public mxIOverlay[] removeOverlays(Object object) {
        mxIOverlay[] mxIOverlayArray = (mxIOverlay[])this.overlays.remove(object);
        if (mxIOverlayArray != null) {
            for (int i = 0; i < mxIOverlayArray.length; ++i) {
                this.removeOverlayComponent(mxIOverlayArray[i], object);
            }
        }
        return mxIOverlayArray;
    }

    protected void removeOverlayComponent(mxIOverlay mxIOverlay2, Object object) {
        Component component;
        if (mxIOverlay2 instanceof Component && (component = (Component)((Object)mxIOverlay2)).getParent() != null) {
            component.getParent().remove(component);
            this.eventSource.fireEvent(EVENT_REMOVEOVERLAY, new Object[]{object, mxIOverlay2});
        }
    }

    protected void updateOverlayComponent(mxCellState mxCellState2, mxIOverlay mxIOverlay2) {
        if (mxIOverlay2 instanceof Component) {
            mxRectangle mxRectangle2;
            Component component = (Component)((Object)mxIOverlay2);
            if (component.getParent() == null) {
                this.getGraphControl().add(component, 0);
            }
            if ((mxRectangle2 = mxIOverlay2.getBounds(mxCellState2)) != null) {
                component.setBounds(mxRectangle2.getRectangle());
                component.setVisible(true);
            } else {
                component.setVisible(false);
            }
        }
    }

    public void clearOverlays() {
        this.clearOverlays(null);
    }

    public void clearOverlays(Object object) {
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        if (object == null) {
            object = mxIGraphModel2.getRoot();
        }
        this.removeOverlays(object);
        int n = mxIGraphModel2.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = mxIGraphModel2.getChildAt(object, i);
            this.clearOverlays(object2);
        }
    }

    public mxIOverlay setWarning(Object object, String string) {
        return this.setWarning(object, string, null, false);
    }

    public mxIOverlay setWarning(Object object, String string, ImageIcon imageIcon) {
        return this.setWarning(object, string, imageIcon, false);
    }

    public mxIOverlay setWarning(final Object object, String string, ImageIcon imageIcon, boolean bl) {
        if (string != null && string.length() > 0) {
            imageIcon = imageIcon != null ? imageIcon : this.warningIcon;
            mxOverlay mxOverlay2 = new mxOverlay(imageIcon, string);
            if (bl) {
                mxOverlay2.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        mxGraphComponent.this.getGraph().setSelectionCell(object);
                    }
                });
                mxOverlay2.setCursor(new Cursor(12));
            }
            return this.addOverlay(object, mxOverlay2);
        }
        this.removeOverlays(object);
        return null;
    }

    public Hashtable updateOverlays(Object object) {
        int n;
        Hashtable<Object, mxIOverlay[]> hashtable = new Hashtable<Object, mxIOverlay[]>();
        mxIOverlay[] mxIOverlayArray = (mxIOverlay[])this.overlays.remove(object);
        mxCellState mxCellState2 = this.getGraph().getView().getState(object);
        if (mxIOverlayArray != null) {
            if (mxCellState2 != null) {
                for (n = 0; n < mxIOverlayArray.length; ++n) {
                    this.updateOverlayComponent(mxCellState2, mxIOverlayArray[n]);
                }
            } else {
                for (n = 0; n < mxIOverlayArray.length; ++n) {
                    this.removeOverlayComponent(mxIOverlayArray[n], object);
                }
            }
            hashtable.put(object, mxIOverlayArray);
        }
        n = this.getGraph().getModel().getChildCount(object);
        for (int i = 0; i < n; ++i) {
            hashtable.putAll(this.updateOverlays(this.getGraph().getModel().getChildAt(object, i)));
        }
        return hashtable;
    }

    protected void paintBackground(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.paintBackgroundPage(graphics);
        if (this.isPageVisible()) {
            graphics.clipRect(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 1, rectangle2.height - 1);
        }
        this.paintBackgroundImage(graphics);
        this.paintGrid(graphics);
        graphics.setClip(rectangle);
    }

    protected Rectangle paintBackgroundPage(Graphics graphics) {
        mxPoint mxPoint2 = this.graph.getView().getTranslate();
        double d = this.graph.getView().getScale();
        int n = (int)Math.round(mxPoint2.getX() * d) - 1;
        int n2 = (int)Math.round(mxPoint2.getY() * d) - 1;
        Dimension dimension = this.getPreferredSizeForPage();
        int n3 = (int)Math.round((double)dimension.width * d) + 2;
        int n4 = (int)Math.round((double)dimension.height * d) + 2;
        if (this.isPageVisible()) {
            graphics.setColor(this.getPageBackgroundColor());
            mxUtils.fillClippedRect(graphics, 0, 0, this.getGraphControl().getWidth(), this.getGraphControl().getHeight());
            graphics.setColor(this.getPageShadowColor());
            mxUtils.fillClippedRect(graphics, n + n3, n2 + 6, 6, n4 - 6);
            mxUtils.fillClippedRect(graphics, n + 8, n2 + n4, n3 - 2, 6);
            graphics.setColor(this.getBackground());
            mxUtils.fillClippedRect(graphics, n + 1, n2 + 1, n3, n4);
            graphics.setColor(this.getPageBorderColor());
            graphics.drawRect(n, n2, n3, n4);
        }
        if (this.isPageBreakVisible() && (this.horizontalPageCount > 1 || this.verticalPageCount > 1)) {
            int n5;
            int n6;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 2.0f}, 0.0f));
            graphics2D.setColor(Color.darkGray);
            for (n6 = 1; n6 <= this.horizontalPageCount - 1; ++n6) {
                n5 = n6 * n3 / this.horizontalPageCount;
                graphics2D.drawLine(n + n5, n2 + 1, n + n5, n2 + n4);
            }
            for (n6 = 1; n6 <= this.verticalPageCount - 1; ++n6) {
                n5 = n6 * n4 / this.verticalPageCount;
                graphics2D.drawLine(n + 1, n2 + n5, n + n3, n2 + n5);
            }
            graphics2D.setStroke(stroke);
        }
        return new Rectangle(n, n2, n3, n4);
    }

    protected void paintBackgroundImage(Graphics graphics) {
        if (this.backgroundImage != null) {
            mxPoint mxPoint2 = this.graph.getView().getTranslate();
            double d = this.graph.getView().getScale();
            graphics.drawImage(this.backgroundImage.getImage(), (int)(mxPoint2.getX() * d), (int)(mxPoint2.getY() * d), (int)((double)this.backgroundImage.getIconWidth() * d), (int)((double)this.backgroundImage.getIconHeight() * d), this);
        }
    }

    protected void paintGrid(Graphics graphics) {
        if (this.isGridVisible()) {
            int n;
            graphics.setColor(this.getGridColor());
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = this.getGraphControl().getBounds();
            }
            double d = rectangle.getX();
            double d2 = rectangle.getY();
            double d3 = d + rectangle.getWidth();
            double d4 = d2 + rectangle.getHeight();
            int n2 = this.getGridStyle();
            int n3 = n = this.graph.getGridSize();
            if (n2 == 1 || n2 == 0) {
                n3 /= 2;
            }
            mxPoint mxPoint2 = this.graph.getView().getTranslate();
            double d5 = this.graph.getView().getScale();
            double d6 = mxPoint2.getX() * d5;
            double d7 = mxPoint2.getY() * d5;
            double d8 = (double)n * d5;
            if (d8 < (double)n3) {
                int n4 = (int)Math.round(Math.ceil((double)n3 / d8) / 2.0) * 2;
                d8 = (double)n4 * d8;
            }
            double d9 = Math.floor((d - d6) / d8) * d8 + d6;
            double d10 = Math.ceil(d3 / d8) * d8;
            double d11 = Math.floor((d2 - d7) / d8) * d8 + d7;
            double d12 = Math.ceil(d4 / d8) * d8;
            switch (n2) {
                case 1: {
                    int n5 = d8 > 16.0 ? 2 : 1;
                    for (double d13 = d9; d13 <= d10; d13 += d8) {
                        for (double d14 = d11; d14 <= d12; d14 += d8) {
                            d13 = (double)Math.round((d13 - d6) / d8) * d8 + d6;
                            d14 = (double)Math.round((d14 - d7) / d8) * d8 + d7;
                            int n6 = (int)Math.round(d13);
                            int n7 = (int)Math.round(d14);
                            graphics.drawLine(n6 - n5, n7, n6 + n5, n7);
                            graphics.drawLine(n6, n7 - n5, n6, n7 + n5);
                        }
                    }
                    break;
                }
                case 2: {
                    int n8;
                    double d15;
                    int n9 = (int)Math.round(d9);
                    int n10 = (int)Math.round(d10 += (double)((int)Math.ceil(d8)));
                    int n11 = (int)Math.round(d11);
                    int n12 = (int)Math.round(d12 += (double)((int)Math.ceil(d8)));
                    for (d15 = d9; d15 <= d10; d15 += d8) {
                        d15 = (double)Math.round((d15 - d6) / d8) * d8 + d6;
                        n8 = (int)Math.round(d15);
                        graphics.drawLine(n8, n11, n8, n12);
                    }
                    for (d15 = d11; d15 <= d12; d15 += d8) {
                        d15 = (double)Math.round((d15 - d7) / d8) * d8 + d7;
                        n8 = (int)Math.round(d15);
                        graphics.drawLine(n9, n8, n10, n8);
                    }
                    break;
                }
                case 3: {
                    int n13;
                    double d16;
                    double d17;
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Stroke stroke = graphics2D.getStroke();
                    int n14 = (int)Math.round(d9);
                    int n15 = (int)Math.round(d10 += (double)((int)Math.ceil(d8)));
                    int n16 = (int)Math.round(d11);
                    int n17 = (int)Math.round(d12 += (double)((int)Math.ceil(d8)));
                    Stroke[] strokeArray = new Stroke[]{new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{3.0f, 1.0f}, Math.max(0, n16) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, n16) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 1.0f}, 0.0f), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, n16) % 4)};
                    for (d17 = d9; d17 <= d10; d17 += d8) {
                        graphics2D.setStroke(strokeArray[(int)(d17 / d8) % strokeArray.length]);
                        d16 = (double)Math.round((d17 - d6) / d8) * d8 + d6;
                        n13 = (int)Math.round(d16);
                        graphics.drawLine(n13, n16, n13, n17);
                    }
                    strokeArray = new Stroke[]{new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{3.0f, 1.0f}, Math.max(0, n14) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, n14) % 4), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 1.0f}, 0.0f), new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, Math.max(0, n14) % 4)};
                    for (d17 = d11; d17 <= d12; d17 += d8) {
                        graphics2D.setStroke(strokeArray[(int)(d17 / d8) % strokeArray.length]);
                        d16 = (double)Math.round((d17 - d7) / d8) * d8 + d7;
                        n13 = (int)Math.round(d16);
                        graphics.drawLine(n14, n13, n15, n13);
                    }
                    graphics2D.setStroke(stroke);
                    break;
                }
                default: {
                    for (double d18 = d9; d18 <= d10; d18 += d8) {
                        for (double d19 = d11; d19 <= d12; d19 += d8) {
                            d18 = (double)Math.round((d18 - d6) / d8) * d8 + d6;
                            d19 = (double)Math.round((d19 - d7) / d8) * d8 + d7;
                            int n18 = (int)Math.round(d18);
                            int n19 = (int)Math.round(d19);
                            graphics.drawLine(n18, n19, n18, n19);
                        }
                    }
                }
            }
        }
    }

    public void redraw(mxCellState mxCellState2) {
        if (mxCellState2 != null) {
            Rectangle rectangle = mxCellState2.getBoundingBox().getRectangle();
            this.repaintTripleBuffer(rectangle);
            this.repaint(rectangle);
        }
    }

    public void checkTripleBuffer() {
        mxRectangle mxRectangle2 = this.graph.getBounds();
        int n = (int)(mxRectangle2.getWidth() + 2.0);
        int n2 = (int)(mxRectangle2.getHeight() + 2.0);
        if (this.tripleBuffer != null && (this.tripleBuffer.getWidth() != n || this.tripleBuffer.getHeight() != n2)) {
            this.destroyTripleBuffer();
        }
        if (this.tripleBuffer == null) {
            this.createTripleBuffer(n, n2);
        }
    }

    protected void createTripleBuffer(int n, int n2) {
        try {
            mxRectangle mxRectangle2 = this.graph.getBounds();
            this.tripleBuffer = mxUtils.createBufferedImage(n, n2, null);
            this.tripleBufferGraphics = this.tripleBuffer.createGraphics();
            mxUtils.setAntiAlias(this.tripleBufferGraphics, this.antiAlias, this.textAntiAlias);
            this.repaintTripleBuffer(null);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    public void destroyTripleBuffer() {
        if (this.tripleBuffer != null) {
            this.tripleBuffer = null;
            this.tripleBufferGraphics.dispose();
            this.tripleBufferGraphics = null;
        }
    }

    public void repaintTripleBuffer(Rectangle rectangle) {
        if (this.tripleBuffered && this.tripleBufferGraphics != null) {
            if (rectangle == null) {
                rectangle = new Rectangle(this.tripleBuffer.getWidth(), this.tripleBuffer.getHeight());
            }
            mxUtils.clearRect(this.tripleBufferGraphics, rectangle, null);
            this.tripleBufferGraphics.setClip(rectangle);
            this.paintGraph(this.tripleBufferGraphics, true);
            this.tripleBufferGraphics.setClip(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintGraph(Graphics2D graphics2D, boolean bl) {
        Graphics2D graphics2D2 = this.canvas.getGraphics();
        boolean bl2 = this.canvas.isDrawLabels();
        Point point = this.canvas.getTranslate();
        double d = this.canvas.getScale();
        try {
            this.canvas.setScale(this.graph.getView().getScale());
            this.canvas.setDrawLabels(bl);
            this.canvas.setTranslate(0, 0);
            this.canvas.setGraphics(graphics2D);
            this.graphControl.draw(this.canvas);
        }
        finally {
            this.canvas.setScale(d);
            this.canvas.setTranslate(point.x, point.y);
            this.canvas.setDrawLabels(bl2);
            this.canvas.setGraphics(graphics2D2);
        }
    }

    public boolean isEventsEnabled() {
        return this.eventSource.isEventsEnabled();
    }

    public void setEventsEnabled(boolean bl) {
        this.eventSource.setEventsEnabled(bl);
    }

    public void addListener(String string, mxEventSource.mxIEventListener mxIEventListener2) {
        this.eventSource.addListener(string, mxIEventListener2);
    }

    public void removeListener(mxEventSource.mxIEventListener mxIEventListener2) {
        this.eventSource.removeListener(mxIEventListener2);
    }

    public void removeListener(mxEventSource.mxIEventListener mxIEventListener2, String string) {
        this.eventSource.removeListener(mxIEventListener2, string);
    }

    static {
        DEFAULT_EXPANDED_ICON = new ImageIcon(mxGraphComponent.class.getResource("/com/mxgraph/swing/images/expanded.gif"));
        DEFAULT_COLLAPSED_ICON = new ImageIcon(mxGraphComponent.class.getResource("/com/mxgraph/swing/images/collapsed.gif"));
        DEFAULT_WARNING_ICON = new ImageIcon(mxGraphComponent.class.getResource("/com/mxgraph/swing/images/warning.gif"));
    }

    public class mxGraphControl
    extends JComponent {
        public mxGraphComponent getGraphContainer() {
            return mxGraphComponent.this;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Object object;
            String string = mxGraphComponent.this.graphHandler.getHandleToolTipText(mouseEvent);
            if (string == null && (object = mxGraphComponent.this.getCellAt(mouseEvent.getX(), mouseEvent.getY())) != null) {
                string = mxGraphComponent.this.hitFoldingIcon(object, mouseEvent.getX(), mouseEvent.getY()) ? mxResources.get("collapse-expand") : mxGraphComponent.this.graph.getToolTipForCell(object);
            }
            if (string != null && string.length() > 0) {
                return string;
            }
            return super.getToolTipText(mouseEvent);
        }

        public void updatePreferredSize() {
            Cloneable cloneable;
            double d = mxGraphComponent.this.graph.getView().getScale();
            Dimension dimension = null;
            if (mxGraphComponent.this.preferPageSize || mxGraphComponent.this.pageVisible) {
                cloneable = mxGraphComponent.this.getPreferredSizeForPage();
                if (!mxGraphComponent.this.preferPageSize) {
                    ((Dimension)cloneable).width += 2 * mxGraphComponent.this.getHorizontalPageBorder();
                    ((Dimension)cloneable).height += 2 * mxGraphComponent.this.getVerticalPageBorder();
                }
                dimension = new Dimension((int)((double)((Dimension)cloneable).width * d), (int)((double)((Dimension)cloneable).height * d));
            } else {
                dimension = mxGraphComponent.this.getScaledPreferredSizeForGraph();
            }
            cloneable = mxGraphComponent.this.graph.getMinimumGraphSize();
            if (cloneable != null) {
                dimension.width = (int)Math.max((long)dimension.width, Math.round(((mxRectangle)cloneable).getWidth() * d));
                dimension.height = (int)Math.max((long)dimension.height, Math.round(((mxRectangle)cloneable).getHeight() * d));
            }
            if (!this.getPreferredSize().equals(dimension)) {
                this.setPreferredSize(dimension);
                this.setMinimumSize(dimension);
                this.revalidate();
            }
        }

        public void paint(Graphics graphics) {
            mxGraphComponent.this.eventSource.fireEvent(mxGraphComponent.EVENT_BEFOREPAINT, new Object[]{graphics});
            super.paint(graphics);
            mxGraphComponent.this.eventSource.fireEvent(mxGraphComponent.EVENT_AFTERPAINT, new Object[]{graphics});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            mxGraphComponent.this.paintBackground(graphics);
            if (mxGraphComponent.this.tripleBuffered) {
                mxGraphComponent.this.checkTripleBuffer();
            } else if (mxGraphComponent.this.tripleBuffer != null) {
                mxGraphComponent.this.destroyTripleBuffer();
            }
            if (mxGraphComponent.this.tripleBuffer != null) {
                mxUtils.drawImageClip(graphics, mxGraphComponent.this.tripleBuffer, this);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                RenderingHints renderingHints = graphics2D.getRenderingHints();
                try {
                    mxUtils.setAntiAlias(graphics2D, mxGraphComponent.this.antiAlias, mxGraphComponent.this.textAntiAlias);
                    mxGraphComponent.this.paintGraph(graphics2D, true);
                }
                finally {
                    graphics2D.setRenderingHints(renderingHints);
                }
            }
        }

        public void draw(mxICanvas mxICanvas2) {
            this.drawCell(mxICanvas2, mxGraphComponent.this.graph.getModel().getRoot());
        }

        protected String getDisplayLabelForCell(Object object) {
            return object != mxGraphComponent.this.cellEditor.getEditingCell() ? mxGraphComponent.this.graph.getLabel(object) : null;
        }

        protected boolean isCellDisplayable(Object object) {
            return object != mxGraphComponent.this.graph.getView().getCurrentRoot() && object != mxGraphComponent.this.graph.getModel().getRoot();
        }

        public void drawCell(mxICanvas mxICanvas2, Object object) {
            mxCellState mxCellState2 = mxGraphComponent.this.graph.getView().getState(object);
            if (this.isCellDisplayable(object)) {
                String string = this.getDisplayLabelForCell(object);
                mxGraphComponent.this.graph.drawStateWithLabel(mxICanvas2, mxCellState2, string);
            }
            boolean bl = mxGraphComponent.this.graph.isKeepEdgesInBackground();
            boolean bl2 = mxGraphComponent.this.graph.isKeepEdgesInForeground();
            if (bl) {
                this.drawChildren(object, true, false);
            }
            this.drawChildren(object, !bl && !bl2, true);
            if (bl2) {
                this.drawChildren(object, true, false);
            }
            if (mxCellState2 != null) {
                this.cellDrawn(mxICanvas2, mxCellState2);
            }
        }

        protected void drawChildren(Object object, boolean bl, boolean bl2) {
            mxIGraphModel mxIGraphModel2 = mxGraphComponent.this.graph.getModel();
            int n = mxIGraphModel2.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = mxIGraphModel2.getChildAt(object, i);
                boolean bl3 = mxIGraphModel2.isEdge(object2);
                if ((!bl2 || bl3) && (!bl || !bl3)) continue;
                this.drawCell(mxGraphComponent.this.canvas, mxIGraphModel2.getChildAt(object, i));
            }
        }

        protected void cellDrawn(mxICanvas mxICanvas2, mxCellState mxCellState2) {
            if (mxICanvas2 instanceof mxGraphics2DCanvas) {
                ImageIcon imageIcon;
                mxIGraphModel mxIGraphModel2 = mxGraphComponent.this.graph.getModel();
                mxGraphics2DCanvas mxGraphics2DCanvas2 = (mxGraphics2DCanvas)mxICanvas2;
                Graphics2D graphics2D = mxGraphics2DCanvas2.getGraphics();
                boolean bl = mxIGraphModel2.isEdge(mxCellState2.getCell());
                if ((mxIGraphModel2.isVertex(mxCellState2.getCell()) || bl) && mxGraphComponent.this.foldingEnabled && (imageIcon = mxGraphComponent.this.getFoldingIcon(mxCellState2)) != null) {
                    Rectangle rectangle = mxGraphComponent.this.getFoldingIconBounds(mxCellState2, imageIcon);
                    graphics2D.drawImage(imageIcon.getImage(), rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
                }
            }
        }
    }
}

