package cerot.blight.view.sequence.entity;

/**
 * 結線を示すモデルクラス。
 * @author shin
 * 
 */
public class Connector {
	/** 結線の名称 */
	private String name;

	/** 開始端点 */
	private EndPoint from;

	/** 終了端点 */
	private EndPoint to;

	/** 結線の種別 */
	private ConnectorType connectorType;

	/**
	 * 結線の名称を取得します。
	 * @return 結線の名称
	 */
	public String getName() {
		return name;
	}

	/**
	 * 結線の名称を設定します。
	 * @param name 結線の名称
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 開始端点を取得します。
	 * @return 開始端点
	 */
	public EndPoint getFrom() {
		return from;
	}

	/**
	 * 開始端点を設定します。
	 * @param from 開始端点
	 */
	public void setFrom(EndPoint from) {
		this.from = from;
	}

	/**
	 * 終了端点を取得します。
	 * @return 終了端点
	 */
	public EndPoint getTo() {
		return to;
	}

	/**
	 * 終了端点を設定します。
	 * @param to 終了端点
	 */
	public void setTo(EndPoint to) {
		this.to = to;
	}

	/**
	 * 結線の種別を取得します。
	 * @return 結線の種別
	 */
	public ConnectorType getConnectorType() {
		return connectorType;
	}

	/**
	 * 結線の種別を設定します。
	 * @param connectorType 結線の種別
	 */
	public void setConnectorType(ConnectorType connectorType) {
		this.connectorType = connectorType;
	}
}
