/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.PerfReader;
import java.net.URISyntaxException;
import sun.jvmstat.monitor.IntegerMonitor;
import sun.jvmstat.monitor.LongMonitor;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.StringMonitor;
import sun.jvmstat.monitor.VmIdentifier;

public class PerfReaderImpl
implements PerfReader {
    private volatile MonitoredVm thisVm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MonitoredVm getThisVm() {
        if (this.thisVm == null) {
            PerfReaderImpl perfReaderImpl = this;
            synchronized (perfReaderImpl) {
                if (this.thisVm == null) {
                    try {
                        MonitoredHost host = MonitoredHost.getMonitoredHost("localhost");
                        VmIdentifier ident = new VmIdentifier("0");
                        this.thisVm = host.getMonitoredVm(ident);
                    }
                    catch (URISyntaxException use) {
                        throw new RuntimeException(use);
                    }
                    catch (MonitorException me) {
                        throw new RuntimeException(me);
                    }
                }
            }
        }
        return this.thisVm;
    }

    public int perfInt(String name) {
        try {
            Monitor mon = this.getThisVm().findByName(name);
            if (mon == null) {
                throw new IllegalArgumentException("no such counter: " + name);
            }
            if (mon instanceof IntegerMonitor) {
                return ((IntegerMonitor)mon).intValue();
            }
            if (mon instanceof LongMonitor) {
                return (int)((LongMonitor)mon).longValue();
            }
            throw new IllegalArgumentException(name + " is not an int");
        }
        catch (MonitorException me) {
            throw new RuntimeException(me);
        }
    }

    public long perfLong(String name) {
        try {
            Monitor mon = this.getThisVm().findByName(name);
            if (mon == null) {
                throw new IllegalArgumentException("no such counter: " + name);
            }
            if (mon instanceof LongMonitor) {
                return ((LongMonitor)mon).longValue();
            }
            throw new IllegalArgumentException(name + " is not a long");
        }
        catch (MonitorException me) {
            throw new RuntimeException(me);
        }
    }

    public String perfString(String name) {
        try {
            Monitor mon = this.getThisVm().findByName(name);
            if (mon == null) {
                throw new IllegalArgumentException("no such counter: " + name);
            }
            if (mon instanceof StringMonitor) {
                return ((StringMonitor)mon).stringValue();
            }
            throw new IllegalArgumentException(name + " is not a string");
        }
        catch (MonitorException me) {
            throw new RuntimeException(me);
        }
    }
}

