/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.james.mime4j.message.TextBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringBody
extends AbstractContentBody
implements TextBody {
    private final byte[] content;
    private final Charset charset;

    public StringBody(String text, String mimeType, Charset charset) throws UnsupportedEncodingException {
        super(mimeType);
        if (text == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        this.content = text.getBytes(charset.name());
        this.charset = charset;
    }

    public StringBody(String text, Charset charset) throws UnsupportedEncodingException {
        this(text, "text/plain", charset);
    }

    public StringBody(String text) throws UnsupportedEncodingException {
        this(text, "text/plain", null);
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.content), this.charset);
    }

    public void writeTo(OutputStream out, int mode) throws IOException {
        int l;
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.content);
        byte[] tmp = new byte[4096];
        while ((l = in.read(tmp)) != -1) {
            out.write(tmp, 0, l);
        }
        out.flush();
    }

    public String getTransferEncoding() {
        return "8bit";
    }

    public String getCharset() {
        return this.charset.name();
    }

    @Override
    public Map<?, ?> getContentTypeParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("charset", this.charset.name());
        return map;
    }

    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public String getFilename() {
        return null;
    }
}

