/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.io.LineReaderInputStream;
import org.apache.james.mime4j.io.MaxLineLimitException;
import org.apache.james.mime4j.util.ByteArrayBuffer;

public class BufferedLineReaderInputStream
extends LineReaderInputStream {
    private byte[] buffer;
    private int bufpos;
    private int buflen;
    private final int maxLineLen;

    public BufferedLineReaderInputStream(InputStream instream, int buffersize, int maxLineLen) {
        super(instream);
        if (instream == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        if (buffersize <= 0) {
            throw new IllegalArgumentException("Buffer size may not be negative or zero");
        }
        this.buffer = new byte[buffersize];
        this.bufpos = 0;
        this.buflen = 0;
        this.maxLineLen = maxLineLen;
    }

    public BufferedLineReaderInputStream(InputStream instream, int buffersize) {
        this(instream, buffersize, -1);
    }

    private void expand(int newlen) {
        byte[] newbuffer = new byte[newlen];
        int len = this.buflen - this.bufpos;
        if (len > 0) {
            System.arraycopy(this.buffer, this.bufpos, newbuffer, this.bufpos, len);
        }
        this.buffer = newbuffer;
    }

    public void ensureCapacity(int len) {
        if (len > this.buffer.length) {
            this.expand(len);
        }
    }

    public int fillBuffer() throws IOException {
        int len;
        int off;
        int l;
        if (this.bufpos > 0) {
            int len2 = this.buflen - this.bufpos;
            if (len2 > 0) {
                System.arraycopy(this.buffer, this.bufpos, this.buffer, 0, len2);
            }
            this.bufpos = 0;
            this.buflen = len2;
        }
        if ((l = this.in.read(this.buffer, off = this.buflen, len = this.buffer.length - off)) == -1) {
            return -1;
        }
        this.buflen = off + l;
        return l;
    }

    public boolean hasBufferedData() {
        return this.bufpos < this.buflen;
    }

    public int read() throws IOException {
        int noRead = 0;
        while (!this.hasBufferedData()) {
            noRead = this.fillBuffer();
            if (noRead != -1) continue;
            return -1;
        }
        return this.buffer[this.bufpos++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            return 0;
        }
        int noRead = 0;
        while (!this.hasBufferedData()) {
            noRead = this.fillBuffer();
            if (noRead != -1) continue;
            return -1;
        }
        int chunk = this.buflen - this.bufpos;
        if (chunk > len) {
            chunk = len;
        }
        System.arraycopy(this.buffer, this.bufpos, b, off, chunk);
        this.bufpos += chunk;
        return chunk;
    }

    public int read(byte[] b) throws IOException {
        if (b == null) {
            return 0;
        }
        return this.read(b, 0, b.length);
    }

    public boolean markSupported() {
        return false;
    }

    public int readLine(ByteArrayBuffer dst) throws IOException {
        if (dst == null) {
            throw new IllegalArgumentException("Buffer may not be null");
        }
        int total = 0;
        boolean found = false;
        int bytesRead = 0;
        while (!found && (this.hasBufferedData() || (bytesRead = this.fillBuffer()) != -1)) {
            int chunk;
            int i = this.indexOf((byte)10);
            if (i != -1) {
                found = true;
                chunk = i + 1 - this.pos();
            } else {
                chunk = this.length();
            }
            if (chunk > 0) {
                dst.append(this.buf(), this.pos(), chunk);
                this.skip(chunk);
                total += chunk;
            }
            if (this.maxLineLen <= 0 || dst.length() < this.maxLineLen) continue;
            throw new MaxLineLimitException("Maximum line length limit exceeded");
        }
        if (total == 0 && bytesRead == -1) {
            return -1;
        }
        return total;
    }

    public int indexOf(byte[] pattern, int off, int len) {
        int x;
        int i;
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern may not be null");
        }
        if (off < this.bufpos || len < 0 || off + len > this.buflen) {
            throw new IndexOutOfBoundsException();
        }
        if (len < pattern.length) {
            return -1;
        }
        int[] shiftTable = new int[256];
        for (i = 0; i < shiftTable.length; ++i) {
            shiftTable[i] = pattern.length + 1;
        }
        for (i = 0; i < pattern.length; ++i) {
            int x2 = pattern[i] & 0xFF;
            shiftTable[x2] = pattern.length - i;
        }
        for (int j = 0; j <= len - pattern.length; j += shiftTable[x]) {
            int cur = off + j;
            boolean match = true;
            for (int i2 = 0; i2 < pattern.length; ++i2) {
                if (this.buffer[cur + i2] == pattern[i2]) continue;
                match = false;
                break;
            }
            if (match) {
                return cur;
            }
            int pos = cur + pattern.length;
            if (pos >= this.buffer.length) break;
            x = this.buffer[pos] & 0xFF;
        }
        return -1;
    }

    public int indexOf(byte[] pattern) {
        return this.indexOf(pattern, this.bufpos, this.buflen - this.bufpos);
    }

    public int indexOf(byte b, int off, int len) {
        if (off < this.bufpos || len < 0 || off + len > this.buflen) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = off; i < off + len; ++i) {
            if (this.buffer[i] != b) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(byte b) {
        return this.indexOf(b, this.bufpos, this.buflen - this.bufpos);
    }

    public byte charAt(int pos) {
        if (pos < this.bufpos || pos > this.buflen) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[pos];
    }

    public byte[] buf() {
        return this.buffer;
    }

    public int pos() {
        return this.bufpos;
    }

    public int limit() {
        return this.buflen;
    }

    public int length() {
        return this.buflen - this.bufpos;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int skip(int n) {
        int chunk = Math.min(n, this.buflen - this.bufpos);
        this.bufpos += chunk;
        return chunk;
    }

    public void clear() {
        this.bufpos = 0;
        this.buflen = 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[pos: ");
        buffer.append(this.bufpos);
        buffer.append("]");
        buffer.append("[limit: ");
        buffer.append(this.buflen);
        buffer.append("]");
        buffer.append("[");
        for (int i = this.bufpos; i < this.buflen; ++i) {
            buffer.append((char)this.buffer[i]);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

