package cerot.tools.taskcoach.entity.adapter;

import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * TaskCoachの日付を、{@link java.util.Date}に変換するためのアダプタクラス。
 * @author cero-t
 * 
 */
public class DateAdapter extends XmlAdapter<String, Date> {
	/** TaskCoachの日付フォーマット */
	private static final String FORMAT = "yyyy-MM-dd hh:mm:ss";

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String marshal(Date v) throws Exception {
		if (v == null) {
			return null;
		}
		return new SimpleDateFormat(FORMAT).format(v);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Date unmarshal(String v) throws Exception {
		if (v == null) {
			return null;
		}
		return new SimpleDateFormat(FORMAT).parse(v);
	}
}
