#!/bin/bash -eE
                  #// Content-Type: text/plain; charset=utf-8
                  #// -eE オプションは、エラーが起きたら中断します
                  #// -x オプションは、１行ずつコマンドを表示します

g_AllArguments="$@"
g_FuncName=${1#--*}  #// cut -- from $1

function  Main_func()
{
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD"
  if [ "$g_FuncName" == "" ]; then
    T_ReplaceTextFile_func  "$@"
    T_ReplaceTextFileLineRange_func  "$@"
    T_rm_func  "$@"
    T_mkdir_func  "$@"
    T_MakeSymbolicLink_func  "$@"
    T_Extract_func  "$@"
    T_ExtractGZ_func  "$@"
    T_AddIfNotExist_func  "$@"
    T_GetAbsPath_func  "$@"
    T_GetParentAbsPath_func  "$@"
    T_SearchParent_func  "$@"
    T_ExpandWildcard_func  "$@"
    T_Assert_func  "$@"
    T_GetUsableCommands_func  "$@"
    T_GetUsableApplicationsForMac_func  "$@"
    T_StartIn_func  "$@"
    T_Writable_func  "$@"  #// This is last test because writable is changed
  else
    $g_FuncName  "$@"
  fi
  ColorText_func  "Pass."  "Green" "Bold" ; echo_e_func  "$g_Ret"
}


 
#//*********************************************************************
#// <<< [T_Writable_func] >>>
#//*********************************************************************
function  T_Writable_func()
{
  local  exit_code
  EchoTestStart_func  ${FUNCNAME[0]}
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD/work"  ""


  #//=== Basic Test

  #// Test Main
  CheckWritable_func  "$PWD/work/a.txt"


  #//=== out of writable

  #// Test Main
  while TryStart_func; do
    CheckWritable_func  "$PWD/out/a.txt"
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" != "1" ]; then  Error_func  "Error exptected"  ;fi
  echo "This error is OK";  ErrClass.clear_method


  #//=== reduce writabile
  AppKeyClass.newWritable_method  "$AppKey"  "$PWD/work"  ""  "out"
  CheckWritable_func  "$PWD/out/a.txt"
  AppKeyClass.newWritable_method  "$AppKey"  "$PWD/work"

  #// Test Main
  while TryStart_func; do
    CheckWritable_func  "$PWD/out/a.txt"
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" != "1" ]; then  Error_func  "Error exptected"  ;fi
  echo "This error is OK";  ErrClass.clear_method
}


 
#//*********************************************************************
#// <<< [T_rm_func] >>>
#//*********************************************************************
function  T_rm_func()
{
  #//=== remove folder
  #// set up
  rm_func     "T_rm_func"
  if [ -e "T_rm_func" ];then  Error_func  ;fi
  mkdir_func  "T_rm_func/sub"

  echo  "a" > T_rm_func/a.txt
  echo  "b" > T_rm_func/sub/b.txt
  mv  "T_rm_func/sub/b.txt"  "T_rm_func/sub/b b.txt"

  #// Test Main
  rm_func     "T_rm_func"

  #// check
  if [ -e "T_rm_func" ];then  Error_func  ;fi
  echo  "Pass."


  #//=== wildcard, symbolic link
  #// set up
  mkdir_func  "T_rm_func/sub"
  echo  "a" > T_rm_func/a.txt
  echo  "b" > T_rm_func/sub/b.txt
  ln -s  "a.txt"  "T_rm_func/s.txt"
  ln -s  "dead.txt.1"  "T_rm_func/dead.txt"
  mv  "T_rm_func/sub/b.txt"  "T_rm_func/sub/b b.txt"

  #// Test Main
  rm_func  T_rm_func/*

  #// check
  if [   -e "T_rm_func/a.txt" ];then  Error_func  ;fi
  if [   -e "T_rm_func/sub/b.txt" ];then  Error_func  ;fi
  if [   -e "T_rm_func/sub" ];then  Error_func  ;fi
  if [   -e "T_rm_func/s.txt" ];then  Error_func  ;fi
  if [ ! -e "T_rm_func" ];then  Error_func  ;fi
  echo  "Pass."


  #//=== no item folder
  #// set up
  if [ `echo  T_rm_func/*` != "T_rm_func/*" ];then  Error_func  ;fi

  #// Test Main
  rm_func  T_rm_func/*

  #// check no error only
  echo  "Pass."

  #// clean
  rm_func     "T_rm_func"


  #//=== no param
  rm_func   $ThisIsNotDefinedVariable
  rm_func  "$ThisIsNotDefinedVariable"


  #// clean
  rm_func     "T_rm_func"
}


 
#//*********************************************************************
#// <<< [T_mkdir_func] >>>
#//*********************************************************************
function  T_mkdir_func()
{
  #//=== mkdir_func

  #// Test Main
  mkdir_func  "T_mkdir_func"
  mkdir_func  "T_mkdir_func"  #// no error, if already exists
  rm_func     "T_mkdir_func"


  #//=== mkdir_for_it_func

  #// set up
  if [ -d "T_mkdir_func" ];then  Error_func  ;fi

  #// Test Main
  mkdir_for_it_func  "T_mkdir_func/file.txt"

  #// check
  if [ ! -d "T_mkdir_func" ];then  Error_func  ;fi
  if [ -e "T_mkdir_func/file.txt" ];then  Error_func  ;fi

  #// clean
  rm_func  "T_mkdir_func"
}


 
#//*********************************************************************
#// <<< [T_MakeSymbolicLink_func] >>>
#//*********************************************************************
function  T_MakeSymbolicLink_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "_work_T_ln"

  #// set up
  rm_func     "_work_T_ln"
  mkdir_func  "_work_T_ln"
  echo  "a" > "_work_T_ln/a"
  echo  "b" > "_work_T_ln/b"
  mkdir       "_work_T_ln/Fo_a"
  mkdir       "_work_T_ln/Fo_b"
  echo  "a" > "_work_T_ln/Fo_a/file"
  echo  "b" > "_work_T_ln/Fo_b/file"

  #// Test Main : ファイルへリンクする
  MakeSymbolicLink_func  "_work_T_ln/link"  "a"

  #// check
  Assert_func  '`cat  "_work_T_ln/link"` == "a"'


  #// Test Main : ファイルへのリンクを上書きする
  MakeSymbolicLink_func  "_work_T_ln/link"  "b"

  #// check
  Assert_func  '`cat  "_work_T_ln/link"` == "b"'


  #// Test Main : フォルダーへリンクする
  MakeSymbolicLink_func  "_work_T_ln/Fo_link"  "Fo_a"

  #// check
  Assert_func  '`cat  "_work_T_ln/Fo_link/file"` == "a"'


  #// Test Main : フォルダーへのリンクを上書きする
  MakeSymbolicLink_func  "_work_T_ln/Fo_link"  "Fo_b"

  #// check
  Assert_func  '`cat  "_work_T_ln/Fo_link/file"` == "b"'


  #// Test Main : フォルダーと同じパスにリンクを上書きしようとするエラー
  while TryStart_func; do
    MakeSymbolicLink_func  "_work_T_ln/Fo_a"  "Fo_b"
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" == "0 " ]; then  Error_func  "Error exptected"  ;fi
  echo "${g_Err_Desc}${LF}This error is OK";  ErrClass.clear_method


  #// Test Main : writable の範囲外エラー
  while TryStart_func; do
    MakeSymbolicLink_func  "link"  "b"
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" != "1" ]; then  Error_func  "Error exptected"  ;fi
  echo "This error is OK";  ErrClass.clear_method


  #// Test Main : readlink_func
  readlink_func  "_work_T_ln/link"
  Assert_func  '"$g_Ret" == "`pwd -P`/_work_T_ln/b"'

  readlink_func  "_work_T_ln/Fo_link"
  Assert_func  '"$g_Ret" == "`pwd -P`/_work_T_ln/Fo_b"'

  readlink_func  "_work_T_ln/Fo_link/file"
  Assert_func  '"$g_Ret" == "`pwd -P`/_work_T_ln/Fo_b/file"'


  #// clean
  rm_func  "_work_T_ln"
}


 
#//*********************************************************************
#// <<< [T_chown_it_and_parent_func] >>>
#//*********************************************************************
function  T_chown_it_and_parent_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "_work_T_chown"
  local  line

  #// set up
  sudo_func  rm_func  "_work_T_chown"
  sudo  mkdir  -p  "_work_T_chown/sub"
  echo  "s" > s.txt
  sudo  chown  root:root  s.txt
  sudo  mv  "s.txt"  "_work_T_chown/sub/s.txt"

  #// Test Main
  sudo_func  chown_it_and_parent_func  $USER:$USER  "_work_T_chown/sub/s.txt"
  echo  "a" > _work_T_chown/sub/s.txt

  #// check
  line=`ls -l "_work_T_chown/sub/s.txt"`
  echo  "$line"
  StringClass.indexOf_method  "$line"  "$USER $USER"
  Assert_func  '$g_Ret -ge 0'


  #// Test Main
  sudo_func  chown_it_and_parent_func  root:root  "_work_T_chown/sub/s.txt"

  #// check
  line=`ls -l "_work_T_chown/sub/s.txt"`
  echo  "$line"
  StringClass.indexOf_method  "$line"  "root root"
  Assert_func  '$g_Ret -ge 0'


  #// set up
  sudo_func  rm_func  "_work_T_chown"

  #// Test Main - make parent folder
  sudo_func  chown_it_and_parent_func  $USER:$USER  "_work_T_chown/sub/s.txt"
  echo  "a" > _work_T_chown/sub/s.txt


  #// clean
  sudo_func  rm_func  "_work_T_chown"
}


 
#//*********************************************************************
#// <<< [T_Error_func] >>>
#//*********************************************************************
function  T_Error_func()
{
  local  exit_code

  EchoTestStart_func  ${FUNCNAME[0]}
  exit_code="0"
  ./T_File.sh  --T_Error_sub_func  || exit_code="$?"
  if [ "$exit_code" != "1" ]; then  Error_func  ;fi
  echo  "This error is OK"
  echo  "「サンプル エラーメッセージ」が表示されていること。"
  echo  "「このメッセージは表示されてはいけません。」が表示されて止まったことがないこと。"
  echo  "上記エラーメッセージに書かれている T_Error_sub2_func" \
        "の行番号が正しいこと。"
  Pause_func
}

function  T_Error_sub_func()
{
  ./T_File.sh  --T_Error_sub2_func
  echo  "このメッセージは表示されてはいけません。"  #// 直前のエラーのため
  Pause_func
}

function  T_Error_sub2_func()
{
  Error_func  サンプル エラーメッセージ
}


 
#//*********************************************************************
#// <<< [T_Assert_func] >>>
#//*********************************************************************
function  T_Assert_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  n=1
  Assert_func  "$n == 1"
  Assert_func   $n == 1
  Assert_func  `echo "ABC"` == "ABC"
}


 
#//*********************************************************************
#// <<< [T_Extract_func] >>>
#//*********************************************************************
function  T_Extract_func()
{
  local  ext_
  local  exts=( "zip"  "tar.bz2"  "tar.gz" )
  local  path_head
  local  path_heads=( "folder"  "./folder"  "."  "*" )
  local  a1
  local  a2

  EchoTestStart_func  ${FUNCNAME[0]}

  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD/_T_Extract"

  for path_head  in "${path_heads[@]}" ;do


    #//=== set up
    rm_func   "_T_Extract"
    mkdir -p  "_T_Extract/folder/sub"

    pushd  "_T_Extract" > /dev/null
    echo  "a" > folder/a.txt
    echo  "b" > folder/b.txt
    echo  "c" > folder/sub/c.txt
    echo  "d" > folder/sub/d.txt
    echo  "h" > folder/.hidden

    if [ "$path_head" == "." ];then
      pushd  "folder" > /dev/null
      tar cvjf  "../folder.tar.bz2"  "."
      tar cvzf  "../folder.tar.gz"  "."
      zip -r    "../folder.zip"  "."
      popd > /dev/null
    elif [ "$path_head" == "*" ];then
      pushd  "folder" > /dev/null
      tar cvjf  "../folder.tar.bz2"  *  .hidden
      tar cvzf  "../folder.tar.gz"   *  .hidden
      zip -r    "../folder.zip"      *  .hidden
      popd > /dev/null
    else
      tar cvjf  "folder.tar.bz2"  "$path_head"
      tar cvzf  "folder.tar.gz"   "$path_head"
      zip -r    "folder.zip"      "$path_head"
    fi


    #//=== Test Main : ListUpIn_func
    if [ "$path_head" == "folder" ];then
      MultiLine_func  $LF \
        "folder/a.txt" \
        "folder/b.txt" \
        "folder/sub/" \
        "folder/sub/c.txt" \
        "folder/sub/d.txt" \
        "folder/.hidden"
      a2="$g_Ret"

      a1=`ListUpIn_func  "folder.zip"`
      Assert_func  '"$a1" != "$a2"'

      a1=`ListUpIn_func  "folder.tar.bz2"`
      Assert_func  '"$a1" != "$a2"'

      a1=`ListUpIn_func  "folder.tar.gz"`
      Assert_func  '"$a1" != "$a2"'

    elif [ "$path_head" == "./folder" ];then
      MultiLine_func  $LF \
        "./folder/a.txt" \
        "./folder/b.txt" \
        "./folder/sub/" \
        "./folder/sub/c.txt" \
        "./folder/sub/d.txt" \
        "./folder/.hidden"
      a2="$g_Ret"

      a1=`ListUpIn_func  "folder.tar.bz2"`
      Assert_func  '"$a1" != "$a2"'

      a1=`ListUpIn_func  "folder.tar.gz"`
      Assert_func  '"$a1" != "$a2"'

    elif [ "$path_head" == "." ];then
      MultiLine_func  $LF \
        "./a.txt" \
        "./b.txt" \
        "./sub/" \
        "./sub/c.txt" \
        "./sub/d.txt" \
        "./.hidden"
      a2="$g_Ret"

      a1=`ListUpIn_func  "folder.tar.bz2"`
      Assert_func  '"$a1" != "$a2"'

      a1=`ListUpIn_func  "folder.tar.gz"`
      Assert_func  '"$a1" != "$a2"'

    elif [ "$path_head" == "*" ];then
      MultiLine_func  $LF \
        "a.txt" \
        "b.txt" \
        "sub/" \
        "sub/c.txt" \
        "sub/d.txt" \
        ".hidden"
      a2="$g_Ret"

      a1=`ListUpIn_func  "folder.tar.bz2"`
      Assert_func  '"$a1" != "$a2"'

      a1=`ListUpIn_func  "folder.tar.gz"`
      Assert_func  '"$a1" != "$a2"'
    else
      Error_func
    fi


    mv  "folder"  "folder_ans"

    for ext_  in ${exts[@]} ;do

      #//=== Test Main : カレントへ解凍
      Extract_func  "folder.$ext_"  "folder"  #//#####################
      diff  "folder"  "folder_ans"  #// raise error, if not same
      rm_func  "folder"


      #//=== Test Main : カレントと別の場所へ解凍
      Extract_func  "folder.$ext_"  "extract/folder"  #//#####################
      diff  "extract/folder"  "folder_ans"  #// raise error, if not same
      rm_func  "extract"


      #//=== Test Main : 別の名前のフォルダーに解凍
      if [ -e "folder" ];then  Error_func  ;fi
      Extract_func  "folder.$ext_"  "folder_next"  #//#####################
      diff  "folder_next"  "folder_ans"  #// raise error, if not same
      if [ -e "folder" ];then  Error_func  ;fi
      rm_func  "folder_next"


      #//=== Test Main : 別の名前のフォルダーに解凍、--transform_from オプション
      if [ x"$path_head" == x"folder"  -o  x"$path_head" == x"./folder" ];then
        Extract_func  "folder.$ext_"  "folder_next"  --transform_from="$path_head"  #//#####################
        diff  "folder_next"  "folder_ans"  #// raise error, if not same
        rm_func  "folder_next"
      fi


      #//=== Test Main : 上書きマージ解凍 - カレントへ解凍
      mkdir  "folder"
      mkdir  "folder/sub"
      echo  "x" > folder/a.txt
      echo  "x" > folder/x.txt
      echo  "x" > folder/sub/c.txt
      echo  "x" > folder/sub/x.txt

      echo  "x" > folder_ans/x.txt
      echo  "x" > folder_ans/sub/x.txt

      Extract_func  "folder.$ext_"  "folder"  #//#####################

      diff  "folder"  "folder_ans"  #// raise error, if not same
      rm_func  "folder"


      #// Test Main : 上書きマージ解凍 - カレントと別の場所へ解凍
      mkdir -p  "extract/folder"
      echo  "x" > extract/folder/x.txt
      mkdir -p   "folder"
      echo  "x" > folder/x.txt

      Extract_func  "folder.$ext_"  "extract/folder"  #//#####################

      diff  "extract/folder"  "folder_ans"  #// raise error, if not same
      rm_func  "extract"
      rm_func  "folder"


      #// Test Main : 上書きマージ解凍 - 別の名前のフォルダーに解凍
      mkdir -p  "folder_next/sub"
      echo  "x" > folder_next/a.txt
      echo  "x" > folder_next/x.txt
      echo  "x" > folder_next/sub/c.txt
      echo  "x" > folder_next/sub/x.txt
      if [ -e "folder" ];then  Error_func  ;fi

      Extract_func  "folder.$ext_"  "folder_next"  #//#####################

      diff  "folder_next"  "folder_ans"  #// raise error, if not same
      if [ -e "folder" ];then  Error_func  ;fi
      rm_func  "folder_next"

      rm  "folder_ans/x.txt"
      rm  "folder_ans/sub/x.txt"

    done ; done_func $?

    #//=== clean
    popd  > /dev/null
    rm_func   "_T_Extract"
  done ; done_func $?
}


 
#//*********************************************************************
#// <<< [T_ExtractGZ_func] >>>
#//*********************************************************************
function  T_ExtractGZ_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD" "$HOME"


  #//=== Basic Test

  #// set up
  rm_func  "ExtGZ.txt"
  rm_func  "T_ExtractGZ.txt.gz"
  cp -ap  "Files/T_ExtractGZ.txt.gz" "."

  #// Test Main
  TMPDIR=""
  ExtractGZ_func  "T_ExtractGZ.txt.gz"  "ExtGZ.txt"
  cat  "ExtGZ.txt"

  #// check
  Assert_func  `cat "ExtGZ.txt"` == "T_ExtractGZ"
  Assert_func  -e "T_ExtractGZ.txt.gz"

  #// clean
  rm_func  "ExtGZ.txt"
  rm_func  "T_ExtractGZ.txt.gz"


  #//=== at $HOME

  #// set up
  rm_func  "$HOME/T_ExtractGZ.txt"
  rm_func  "$HOME/T_ExtractGZ.txt.gz"
  cp -ap  "Files/T_ExtractGZ.txt.gz" "$HOME"

  #// Test Main
  TMPDIR=""
  ExtractGZ_func  "$HOME/T_ExtractGZ.txt.gz"  "$HOME/T_ExtractGZ.txt"

  #// check
  Assert_func  `cat "$HOME/T_ExtractGZ.txt"` == "T_ExtractGZ"
  Assert_func  -e "$HOME/T_ExtractGZ.txt.gz"

  #// clean
  rm_func  "$HOME/T_ExtractGZ.txt"
  rm_func  "$HOME/T_ExtractGZ.txt.gz"


  #//=== overwrite

  #// set up
  rm_func  "T_ExtractGZ.txt"
  rm_func  "T_ExtractGZ.txt.gz"
  cp -ap  "Files/T_ExtractGZ.txt.gz" "."

  #// Test Main
  TMPDIR=""
  ExtractGZ_func  "T_ExtractGZ.txt.gz"  "T_ExtractGZ.txt"
  ExtractGZ_func  "T_ExtractGZ.txt.gz"  "T_ExtractGZ.txt"

  ExtractGZ_func  "T_ExtractGZ.txt.gz"  "T_ExtractGZ2.txt"
  ExtractGZ_func  "T_ExtractGZ.txt.gz"  "T_ExtractGZ2.txt"

  #// check
  Assert_func  `cat "T_ExtractGZ.txt"` == "T_ExtractGZ"
  Assert_func  -e "T_ExtractGZ.txt.gz"

  #// clean
  rm_func  "T_ExtractGZ.txt"
  rm_func  "T_ExtractGZ.txt.gz"
  rm_func  "T_ExtractGZ2.txt"
}


 
#//*********************************************************************
#// <<< [T_AddIfNotExist_func] >>>
#//*********************************************************************
function  T_AddIfNotExist_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  local   str
  local   path_back="$PATH"

  #// Test Main
  AddIfNotExist_func  $PATH  "/__mybin"  ":" ; PATH="$g_Ret"
  echo  $PATH
  Assert_func  "$PATH" == "/__mybin:$path_back"

  AddIfNotExist_func  $PATH  "/__mybin"  ":" ; PATH="$g_Ret"
  echo  $PATH
  Assert_func  "$PATH" == "/__mybin:$path_back"

  AddIfNotExist_func  $PATH  "/__my"  ":" ; PATH="$g_Ret"
  echo  $PATH
  Assert_func  "$PATH" == "/__my:/__mybin:$path_back"

  AddIfNotExist_func  $PATH  ""  ":" ; PATH="$g_Ret"
  echo  $PATH
  Assert_func  "$PATH" == "/__my:/__mybin:$path_back"

  #// clean
  PATH=$path_back


  #// Test Main
  AddIfNotExist_func  "A,B,C"  "A"  "," ; str="$g_Ret"
  echo  $str
  Assert_func  "$str" == "A,B,C"

  AddIfNotExist_func  "A,B,C"  "B"  "," ; str="$g_Ret"
  echo  $str
  Assert_func  "$str" == "A,B,C"

  AddIfNotExist_func  "A,B,C"  "C"  "," ; str="$g_Ret"
  echo  $str
  Assert_func  "$str" == "A,B,C"

  AddIfNotExist_func  "A,B,C"  "D"  "," ; str="$g_Ret"
  echo  $str
  Assert_func  "$str" == "D,A,B,C"
}


 
#//*********************************************************************
#// <<< [T_ReplaceTextFile_func] >>>
#//*********************************************************************
function  T_ReplaceTextFile_func()
{
  local  from
  local  to
  local  str
  local  i_opt

  EchoTestStart_func  ${FUNCNAME[0]}

  sed_setIsAbleToNotCaseSensitive_func
  if [ "$g_sed_isAbleToNotCaseSensitive" == "1" ];then
    i_opt="-i"
  else
    i_opt=""
  fi


  #//=== Test
  echo  "abc" >  _T_sed.txt
  echo  "def" >> _T_sed.txt
  echo  "abcabc" >> _T_sed.txt

  from='b'
  to='xx'
  echo  "from=\"$from\", to=\"$to\""
  ReplaceTextFile_func  "_T_sed.txt"  "$from"  "$to"  #//*************
  str=`cat _T_sed.txt`
  Assert_func  '"$str" == "axxc${LF}def${LF}axxcaxxc"'


  #//=== Test : has /
  echo  "/a/bc" >  _T_sed.txt
  echo  "/d/ef" >> _T_sed.txt
  echo  "/a/bc/A/BC" >> _T_sed.txt

  from='b'
  to='xx'
  echo  "from=\"$from\", to=\"$to\""
  ReplaceTextFile_func  "_T_sed.txt"  "$from"  "$to"  "$i_opt"  #//*************
  str=`cat _T_sed.txt`
  if [ "$g_sed_isAbleToNotCaseSensitive" == "1" ];then
    Assert_func  '"$str" == "/a/xxc${LF}/d/ef${LF}/a/xxc/A/xxC"'
  else
    Assert_func  '"$str" == "/a/xxc${LF}/d/ef${LF}/a/xxc/A/BC"'
  fi


  #//=== Test : regular expression
  echo  "abc" >  _T_sed.txt
  echo  "#define  SymbolA  1" >> _T_sed.txt
  echo  "abc" >> _T_sed.txt

  from='^.*SymbolA.*$'
  to='xx'
  echo  "from=\"$from\", to=\"$to\""
  ReplaceTextFile_func  "_T_sed.txt"  "$from"  "$to"  #//*************
  str=`cat _T_sed.txt`
  Assert_func  '"$str" == "abc${LF}xx${LF}abc"'


  #//=== Test : from 2 lines
  echo  "abc" >  _T_sed.txt
  echo  "def" >> _T_sed.txt

  MultiLine_func  "\n" \
    "bc" \
    "de"
  from="$g_Ret"
  MultiLine_func  "\n" \
    "xx" \
    "yy" \
    "zz"
  to="$g_Ret"
  echo  "from=\"$from\", to=\"$to\""
  ReplaceTextFile_func  "_T_sed.txt"  "$from"  "$to"  #//*************
  str=`cat _T_sed.txt`
  Assert_func  '"$str" == "axx${LF}yy${LF}zzf"'


  #//=== Test : from 3 lines (error)
  echo  "abc" >  _T_sed.txt
  echo  "def" >> _T_sed.txt
  echo  "ghi" >> _T_sed.txt
  echo  "jkl" >> _T_sed.txt
  echo  "abc" >> _T_sed.txt
  echo  "def" >> _T_sed.txt
  echo  "ghi" >> _T_sed.txt
  echo  "jkl" >> _T_sed.txt

  MultiLine_func  "\n" \
    "def" \
    "ghi" \
    "jkl"
  from="$g_Ret"
  MultiLine_func  "\n" \
    "xx" \
    "yy"
  to="$g_Ret"
  echo  "from=\"$from\", to=\"$to\""

  while TryStart_func; do
    ReplaceTextFile_func  "_T_sed.txt"  "$from"  "$to"  #//*************
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  echo "${g_Err_Desc}${LF}This error is OK";  ErrClass.clear_method


  #//=== Test : execute attribute file
  rm_func  "_tmp.txt"
  echo  '#!/bin/bash'  >  _tmp.txt
  echo  "echo  abc"    >> _tmp.txt
  chmod +x "_tmp.txt"

  ReplaceTextFile_func  "_tmp.txt"  "abc"  "def"

  local  out; out=`./_tmp.txt`
  Assert_func  '"$out" == "def"'


  rm  "_T_sed.txt"
}


 
#//*********************************************************************
#// <<< [T_ReplaceTextFileLineRange_func] >>>
#//*********************************************************************
function  T_ReplaceTextFileLineRange_func()
{
  local  i_opt

  EchoTestStart_func  ${FUNCNAME[0]}

  sed_setIsAbleToNotCaseSensitive_func
  if [ "$g_sed_isAbleToNotCaseSensitive" == "1" ];then
    i_opt="-i"
  else
    i_opt=""
  fi


  #//=== Test
  echo  "abc" >  _tmp.txt
  echo  "cde" >> _tmp.txt
  echo  "efg" >> _tmp.txt
  echo  "fgh" >> _tmp.txt

  ReplaceTextFileLineRange_func  "_tmp.txt"  "c"  "f"  "x\ny"

  echo  "----"
  cat  "_tmp.txt"
  echo_e_func  "x\ny\nfgh" > _ans.txt
  diff  "_tmp.txt"  "_ans.txt"


  #//=== Test : 1 empty line
  echo  "abc" >  _tmp.txt
  echo  "cde" >> _tmp.txt
  echo  "efg" >> _tmp.txt
  echo  "fgh" >> _tmp.txt

  ReplaceTextFileLineRange_func  "_tmp.txt"  "c"  "f"  "\n"

  echo  "----"
  cat  "_tmp.txt"
  echo_e_func  "\nfgh" > _ans.txt
  diff  "_tmp.txt"  "_ans.txt"


  #//=== Test : delete lines
  echo  "ab/c"  >  _tmp.txt
  echo  "cde"   >> _tmp.txt
  echo  "e\\fg" >> _tmp.txt
  echo  "f/gh"   >> _tmp.txt

  if [ "$i_opt" == "i" ];then
    ReplaceTextFileLineRange_func  "_tmp.txt"  "/[Cd]"  '\\f'  ""  "$i_opt"
  else
    ReplaceTextFileLineRange_func  "_tmp.txt"  "/[cd]"  '\\f'  ""  "$i_opt"
  fi

  echo  "----"
  cat  "_tmp.txt"
  echo_e_func  "f/gh" > _ans.txt
  diff  "_tmp.txt"  "_ans.txt"


  #//=== Test : no replace
  echo  "abc" >  _tmp.txt
  echo  "cde" >> _tmp.txt

  ReplaceTextFileLineRange_func  "_tmp.txt"  "not found"  "not found"  "x\ny"

  echo  "----"
  cat  "_tmp.txt"
  echo_e_func  "abc\ncde" > _ans.txt
  diff  "_tmp.txt"  "_ans.txt"


  #//=== Test : replace 1 line
  echo  "abc" >  _tmp.txt
  echo  "cde" >> _tmp.txt
  echo  "efg" >> _tmp.txt

  ReplaceTextFileLineRange_func  "_tmp.txt"  "de"  ""  "RRR\nEEE"

  echo  "----"
  cat  "_tmp.txt"
  echo_e_func  "abc\nRRR\nEEE\nefg" > _ans.txt
  diff  "_tmp.txt"  "_ans.txt"


  #//=== Test : delete 1 line
  echo  "abc" >  _tmp.txt
  echo  "cde" >> _tmp.txt
  echo  "ghi" >> _tmp.txt
  echo  "efg" >> _tmp.txt

  ReplaceTextFileLineRange_func  "_tmp.txt"  "e"  ""  ""

  echo  "----"
  cat  "_tmp.txt"
  echo_e_func  "abc\nghi" > _ans.txt
  diff  "_tmp.txt"  "_ans.txt"


  #//=== Test : execute attribute file
  rm_func  "_tmp.txt"
  echo  '#!/bin/bash'  >  _tmp.txt
  echo  "echo  abc"    >> _tmp.txt
  chmod +x "_tmp.txt"

  ReplaceTextFileLineRange_func  "_tmp.txt"  "abc"  ""  "echo  def"

  local  out; out=`./_tmp.txt`
  Assert_func  '"$out" == "def"'


  #// clean
  rm  "_tmp.txt"
  rm  "_ans.txt"
}


 
#//*********************************************************************
#// <<< [T_GetAbsPath_func] >>>
#//*********************************************************************
function  T_GetAbsPath_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  T_GetAbsPathSub_func  "file1.txt"  "/folder"  "/folder/file1.txt"

  T_GetAbsPathSub_func  "../file1.txt"  "/folder/sub"  "/folder/file1.txt"
  T_GetAbsPathSub_func  "../file1.txt"  "sub"  "file1.txt"
  T_GetAbsPathSub_func  "./file1.txt"  "sub"  "sub/file1.txt"

  T_GetAbsPathSub_func  "../a/file1.txt"  "/folder/sub"  "/folder/a/file1.txt"
  T_GetAbsPathSub_func  "../a/file1.txt"  "sub"  "a/file1.txt"
  T_GetAbsPathSub_func  "./a/file1.txt"  "sub"  "sub/a/file1.txt"

  T_GetAbsPathSub_func  "/file1.txt"  "sub"  "/file1.txt"
  T_GetAbsPathSub_func  "/a/file1.txt"  "sub"  "/a/file1.txt"

  T_GetAbsPathSub_func  "sub/file1.txt"  ""  "$PWD/sub/file1.txt"

  T_GetAbsPathSub_func  ".."  "sub1/sub2/sub3"  "sub1/sub2"
  T_GetAbsPathSub_func  "."  ""  "$PWD"
  T_GetAbsPathSub_func  "~/file1.txt"  ""  "$HOME/file1.txt"
}


function  T_GetAbsPathSub_func()
{
  local  StepPath="$1"
  local  BasePath="$2"
  local  AnsAbsPath="$3"

  local  abs_path

  GetAbsPath_func  "$StepPath"  "$BasePath" ; abs_path="$g_Ret"
  echo  GetAbsPath_func  \"$StepPath\"  \"$BasePath\" = \"$abs_path\"
  Assert_func  "$abs_path" == "$AnsAbsPath"
}


 
#//*********************************************************************
#// <<< [T_GetParentAbsPath_func] >>>
#//*********************************************************************
function  T_GetParentAbsPath_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  T_GetParentAbsPathSub_func  "/sub/file1.txt"  "/sub"
  T_GetParentAbsPathSub_func  "/sub/folder/"    "/sub"
  T_GetParentAbsPathSub_func  "sub/file1.txt"   "$PWD/sub"
  T_GetParentAbsPathSub_func  "file1.txt"       "$PWD"
  T_GetParentAbsPathSub_func  "/"               "/"
  T_GetParentAbsPathSub_func  "/sub"            "/"
  T_GetParentAbsPathSub_func  ""                ""
}

function  T_GetParentAbsPathSub_func()
{
  local  Path="$1"
  local  AnsPath="$2"

  local  parent_path

  GetParentAbsPath_func  "$Path" ; parent_path="$g_Ret"
  echo  GetParentAbsPath_func  \"$Path\" = \"$parent_path\"
  Assert_func  "$parent_path" == "$AnsPath"
}


 
#//*********************************************************************
#// <<< [T_SearchParent_func] >>>
#//*********************************************************************
function  T_SearchParent_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  local  path

  mkdir -p  "sub/sub"
  cd  "sub/sub"
  SearchParent_func  "T_File.sh"
  path="$g_Ret"
  cd  "../.."
  echo  "$path"
  Assert_func  '"$PWD/T_File.sh" == "$path"'

  SearchParent_func  "noy_found________________.sh"
  Assert_func  '"$g_Ret" == ""'
  rm_func  "sub"
}


 
#//*********************************************************************
#// <<< [T_ExpandWildcard_func] >>>
#//*********************************************************************
function  T_ExpandWildcard_func()
{
  local  ans
  local  folder
  local  step_paths
  local  ans_folder
  local  ans_step_paths

  EchoTestStart_func  ${FUNCNAME[0]}


  #// set up
  rm_func  "work"

  mkdir_func           "work/T_A  dir"
  ln -s  "T_A  dir"    "work/T_A  dir_symlink"
  echo  "a" >           work/T_A\ \ 1.txt
  ln -s  "T_A  1.txt"  "work/T_A  1_symlink.txt"
  ln -s  "T_A  0.txt"  "work/T_A  deadlink.txt"

  mkdir_func           "work/T_A  dir/T_A  dir"
  ln -s  "T_A  dir"    "work/T_A  dir/T_A  dir_symlink"
  echo  "a" >           work/T_A\ \ dir/T_A\ \ 1.txt
  ln -s  "T_A  1.txt"  "work/T_A  dir/T_A  1_symlink.txt"
  ln -s  "T_A  0.txt"  "work/T_A  dir/T_A  deadlink.txt"

  #// not match items
  mkdir_func           "work/x_A  dir"
  ln -s  "T_A  dir"    "work/x_A  dir_symlink"
  echo  "a" >           work/x_A\ \ 1.txt
  ln -s  "T_A  1.txt"  "work/x_A  1_symlink.txt"
  ln -s  "T_A  0.txt"  "work/x_A  deadlink.txt"

  mkdir_func           "work/T_A  dir/x_A  dir"
  ln -s  "T_A  dir"    "work/T_A  dir/x_A  dir_symlink"
  echo  "a" >           work/T_A\ \ dir/x_A\ \ 1.txt
  ln -s  "T_A  1.txt"  "work/T_A  dir/x_A  1_symlink.txt"
  ln -s  "T_A  0.txt"  "work/T_A  dir/x_A  deadlink.txt"


  #//=== --File --SubFolder
  ExpandWildcard_func  "work/T_*"  folder  step_paths  --File --SubFolder  #//[out]folder, step_paths

  GetAbsPath_func  "work" ; ans_folder="$g_Ret"
  ans_step_paths=( "T_A  dir/T_A  1.txt" "T_A  1.txt" )

  Assert_func  '"$folder" == "$ans_folder"'
  IsSameArrayOutOfOrder_func  ${#ans_step_paths[@]}  "${ans_step_paths[@]}"  "${step_paths[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi
  echo  "${ans_step_paths[@]}"


  #//=== --Folder --SubFolder
  ExpandWildcard_func  "work/T_*"  folder  step_paths  --Folder --SubFolder  #//[out]folder, step_paths

  GetAbsPath_func  "work" ; ans_folder="$g_Ret"
  ans_step_paths=( "T_A  dir"  "T_A  dir/T_A  dir" )

  Assert_func  '"$folder" == "$ans_folder"'
  IsSameArrayOutOfOrder_func  ${#ans_step_paths[@]}  "${ans_step_paths[@]}"  "${step_paths[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi
  echo  "${ans_step_paths[@]}"


  #//=== --Link --SubFolder
  ExpandWildcard_func  "work/T_*"  folder  step_paths  --Link --SubFolder  #//[out]folder, step_paths

  GetAbsPath_func  "work" ; ans_folder="$g_Ret"
  ans_step_paths=( "T_A  dir_symlink"  "T_A  dir/T_A  dir_symlink" \
    "T_A  dir/T_A  1_symlink.txt"  "T_A  dir/T_A  deadlink.txt" \
    "T_A  1_symlink.txt"  "T_A  deadlink.txt" )

  Assert_func  '"$folder" == "$ans_folder"'
  IsSameArrayOutOfOrder_func  ${#ans_step_paths[@]}  "${ans_step_paths[@]}"  "${step_paths[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi
  echo  "${ans_step_paths[@]}"


  #//=== --SubFolder
  ExpandWildcard_func  "work/T_*"  folder  step_paths  --SubFolder  #//[out]folder, step_paths

  GetAbsPath_func  "work" ; ans_folder="$g_Ret"
  ans_step_paths=( "T_A  dir/T_A  1.txt" "T_A  1.txt" \
    "T_A  dir"  "T_A  dir/T_A  dir" \
    "T_A  dir_symlink"  "T_A  dir/T_A  dir_symlink" \
    "T_A  dir/T_A  1_symlink.txt"  "T_A  dir/T_A  deadlink.txt" \
    "T_A  1_symlink.txt"  "T_A  deadlink.txt" )

  Assert_func  '"$folder" == "$ans_folder"'
  IsSameArrayOutOfOrder_func  ${#ans_step_paths[@]}  "${ans_step_paths[@]}"  "${step_paths[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi
  echo  "${ans_step_paths[@]}"


  #//=== (no option)
  ExpandWildcard_func  "work/T_*"  folder  step_paths  #//[out]folder, step_paths

  GetAbsPath_func  "work" ; ans_folder="$g_Ret"
  ans_step_paths=( "T_A  1.txt"  "T_A  dir" \
    "T_A  dir_symlink"  "T_A  1_symlink.txt"  "T_A  deadlink.txt" )

  Assert_func  '"$folder" == "$ans_folder"'
  IsSameArrayOutOfOrder_func  ${#ans_step_paths[@]}  "${ans_step_paths[@]}"  "${step_paths[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi
  echo  "${ans_step_paths[@]}"


  #//=== search in link to folder
  MakeSymbolicLink_func  "work_link"  "work"
  ExpandWildcard_func  "work_link/T_*"  folder  step_paths  #//[out]folder, step_paths

  GetAbsPath_func  "work_link" ; ans_folder="$g_Ret"
  ans_step_paths=( "T_A  1.txt"  "T_A  dir" \
    "T_A  dir_symlink"  "T_A  1_symlink.txt"  "T_A  deadlink.txt" )

  Assert_func  '"$folder" == "$ans_folder"'
  IsSameArrayOutOfOrder_func  ${#ans_step_paths[@]}  "${ans_step_paths[@]}"  "${step_paths[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi
  echo  "${ans_step_paths[@]}"


  rm  "work_link"
  rm_func  "work"
}


 
#//*********************************************************************
#// <<< [T_ExpandWildcard_Hidden_func] >>>
#//*********************************************************************
function  T_ExpandWildcard_Hidden_func()
{
  local  ans
  local  folder
  local  step_paths
  local  ans_folder
  local  ans_step_paths

  EchoTestStart_func  ${FUNCNAME[0]}


  #// set up
  rm_func  "work"

  mkdir_func     "work/.X_folder"
  mkdir_func     "work/folder"

  echo  "a" >    "work/.X_file"
  echo  "a" >    "work/.X_folder/file"
  echo  "a" >    "work/folder/.X_file"
  echo  "a" >    "work/file"

  #// Test Main
  ExpandWildcard_func  "work/*"  folder  step_paths  --SubFolder  #//[out]folder, step_paths
  folder="$g_Ret" ; step_paths=("${g_Ret2[@]}")

  GetAbsPath_func  "work" ; ans_folder="$g_Ret"
  ans_step_paths=( "." ".X_folder"  "folder"  ".X_file"  ".X_folder/file"  "folder/.X_file"  "file" )
  Assert_func  '"$folder" == "$ans_folder"'
  IsSameArrayOutOfOrder_func  ${#ans_step_paths[@]}  "${ans_step_paths[@]}"  "${step_paths[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi
  echo  "${ans_step_paths[@]}"


  #// Test Main : "*"
  pushd  "work" > /dev/null
  ExpandWildcard_func  "*"  folder  step_paths  --SubFolder  #//[out]folder, step_paths
  folder="$g_Ret" ; step_paths=("${g_Ret2[@]}")
  popd > /dev/null

  GetAbsPath_func  "work" ; ans_folder="$g_Ret"
  ans_step_paths=( "." ".X_folder"  "folder"  ".X_file"  ".X_folder/file"  "folder/.X_file"  "file" )
  Assert_func  '"$folder" == "$ans_folder"'
  IsSameArrayOutOfOrder_func  ${#ans_step_paths[@]}  "${ans_step_paths[@]}"  "${step_paths[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi
  echo  "${ans_step_paths[@]}"


  #// Test Main : "./*"
  pushd  "work" > /dev/null
  ExpandWildcard_func  "./*"  folder  step_paths  --SubFolder  #//[out]folder, step_paths
  folder="$g_Ret" ; step_paths=("${g_Ret2[@]}")
  popd > /dev/null

  GetAbsPath_func  "work" ; ans_folder="$g_Ret"
  ans_step_paths=( "." ".X_folder"  "folder"  ".X_file"  ".X_folder/file"  "folder/.X_file"  "file" )
  Assert_func  '"$folder" == "$ans_folder"'
  IsSameArrayOutOfOrder_func  ${#ans_step_paths[@]}  "${ans_step_paths[@]}"  "${step_paths[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi
  echo  "${ans_step_paths[@]}"
}


 
#//*********************************************************************
#// <<< [T_GetUsableCommands_func] >>>
#//*********************************************************************
function  T_GetUsableCommands_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  local  apps
  local  commands

  apps=( "ls"  "not-found"  "cp" )
  GetUsableCommands_func  commands  "${apps[@]}"  #//[out] commands
  Assert_func  '"${#commands[@]}" == "2"'
  Assert_func  '"${commands[0]}" == "ls "'
  Assert_func  '"${commands[1]}" == "cp "'

  apps=( "not-found" )
  GetUsableCommands_func  commands  "${apps[@]}"  #//[out] commands
  Assert_func  '"${#commands[@]}" == "0"'
}


 
#//*********************************************************************
#// <<< [T_GetUsableApplicationsForMac_func] >>>
#//*********************************************************************
function  T_GetUsableApplicationsForMac_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  local  apps
  local  commands

  IsMac_func ; if [ "$g_Ret" == "1" ];then
    apps=( "Safari"  "not-found"  "App Store" )
    GetUsableApplicationsForMac_func  commands  "${apps[@]}"  #//[out] commands
    Assert_func  '"${#commands[@]}" == "2"'
    Assert_func  '"${commands[0]}" == "open -a \"Safari\" "'
    Assert_func  '"${commands[1]}" == "open -a \"App Store\" "'
  fi

  apps=( "not-found" )
  GetUsableApplicationsForMac_func  commands  "${apps[@]}"  #//[out] commands
  Assert_func  '"${#commands[@]}" == "0"'
}


 
#//*********************************************************************
#// <<< [T_StartIn_func] >>>
#//*********************************************************************
function  T_StartIn_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}
  local  path_back="$PATH"

  ./T_File.sh  --T_StartInSubA_func  "$PWD"

  pushd  ".." > /dev/null
  test/T_File.sh  --T_StartInSubB_func  "$PWD"
  popd > /dev/null

  export PATH=$PWD:$PATH
  T_File.sh  --T_StartInSubA_func  "$PWD"
  export PATH="$path_back"
}


function  T_StartInSubA_func()
{
  local  Parent="${g_Arguments[2]}"

  echo  " g_StartInPath=$g_StartInPath"
  echo  "   BASH_SOURCE=$BASH_SOURCE"
  echo  "           PWD=$PWD"
  echo  "g_Arguments[0]=${g_Arguments[0]}"

  Assert_func  '"$PWD" == "$Parent"'
  Assert_func  '"$g_StartInPath" == "$Parent"'
  Assert_func  '"${g_Arguments[0]}" == "$Parent/T_File.sh"'
}


function  T_StartInSubB_func()
{
  local  Parent="${g_Arguments[2]}"

  echo  " g_StartInPath=$g_StartInPath"
  echo  "   BASH_SOURCE=$BASH_SOURCE"
  echo  "           PWD=$PWD"

  Assert_func  '"$PWD" == "$Parent/test"'
  Assert_func  '"$g_StartInPath" == "$Parent"'

  cd  "ans"  #// this is trap
  echo  "           PWD=$PWD"
  echo  "g_Arguments[0]=${g_Arguments[0]}"

  Assert_func  '"$PWD" == "$Parent/test/ans"'
  Assert_func  '"${g_Arguments[0]}" == "$Parent/test/T_File.sh"'
}


 







#//--- start of bashlib include ------------------------------------------------------ 

#// <<< set up bashlib and call Main_func >>> 

#// bashlib is provided under 3-clause BSD license.
#// Copyright (C) 2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

g_BashLibPath="scriptlib/bashlib_inc.sh"; g_Ver="1.0"
g_StartInPath=`pwd`; cd "`dirname "$BASH_SOURCE"`"; g_Arguments=( "$BASH_SOURCE" "$@" )
for (( i = 0; i < 20; i ++ ));do
  if [ -e "$g_BashLibPath" ];then break ;else  g_BashLibPath="../$g_BashLibPath" ;fi ;done
if [ "$i" == "20" ];then  echo "${g_BashLibPath##*../} が見つかりません。
bashlib $g_Ver をダウンロードして scriptlib フォルダーをコピーしてください。"; exit 1 ;fi
source  "$g_BashLibPath"  #// include
CallMain_func
#//--- end of bashlib include --------------------------------------------------------
 
