#!/bin/bash -eE
                  #// Content-Type: text/plain; charset=utf-8
                  #// -eE オプションは、エラーが起きたら中断します
                  #// -x オプションは、１行ずつコマンドを表示します

g_AllArguments="$@"
g_FuncName=${1#--*}  #// cut -- from $1

g_MenuPath=""

function  Main_func()
{
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD"
  SearchParent_func  "menu" ; g_MenuPath="$g_Ret"
  if [ "$g_FuncName" == "" ]; then
    T_SearchFile_func  "$@"
    T_NewSh_func  "$@"
    T_Extract_sth_func  "$@"
    T_chmod_x_func  "$@"
    T_InputCommandOpt_func  "$@"
    T_InputOptionAuto_func  "$@"
  else
    $g_FuncName  "$@"
  fi
  ColorText_func  "Pass."  "Green" "Bold" ; echo_e_func  "$g_Ret"
}


 
#//*********************************************************************
#// <<< [T_SearchFile_func] >>>
#//*********************************************************************
function  T_SearchFile_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  local  keyword

  $g_MenuPath  SearchFile  "ans"  "*ArgCount_*"  ""  | tee "_log.txt"
  cat  "_log.txt" | grep "T_CheckMaxArgCount_ans.txt" > /dev/null   #// check the keyword in _log.txt
  rm   "_log.txt"

  $g_MenuPath  SearchFile  "ans"  ""  "T_AssertSub_func"  | tee "_log.txt"
  cat  "_log.txt" | grep "T_Assert_ans.txt:2" > /dev/null   #// check the keyword in _log.txt
  rm   "_log.txt"

  $g_MenuPath  SearchFile  "ans"  "*Not__Found*"  ""  #// no error check

  $g_MenuPath  SearchFile  "ans"  ""  "Not__Found"  #// no error check

  keyword="[CDATA["
  $g_MenuPath  SearchFile  "ans/"  ""  "$keyword"  | tee "_log.txt"
  StringEscapeUtilsClass.escapeGrep_method  "$keyword" ; keyword="$g_Ret"
  cat  "_log.txt" | grep "Expression" > /dev/null   #// check the keyword in _log.txt
  rm   "_log.txt"
}


 
#//*********************************************************************
#// <<< [T_NewSh_func] >>>
#//*********************************************************************
function  T_NewSh_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}


  #// __test-------/a.sh
  local  folder="__test-------"
  rm_func  "$folder"

  $g_MenuPath  NewSh  "$folder/aa.sh"

  if [ ! -e "$folder/aa.sh" ];then  Error_func  ;fi
  if [ -e "$folder/scriptlib" ];then  Error_func  ;fi
  rm_func  "$folder"


  #// a.sh
  rm_func  "a.sh"

  $g_MenuPath  NewSh  ""

  if [ ! -e "a.sh" ];then  Error_func  ;fi
  rm_func  "a.sh"
}


 
#//*********************************************************************
#// <<< [T_Extract_sth_func] >>>
#//*********************************************************************
function  T_Extract_sth_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  $g_MenuPath  Extract  "Files/folder.tar.bz2"  "_T_Extract_sth"

  if [ ! -e "_T_Extract_sth/sub/c.txt" ];then  Error_func  ;fi
  rm_func  "_T_Extract_sth"
}


 
#//*********************************************************************
#// <<< [T_chmod_x_func] >>>
#//*********************************************************************
function  T_chmod_x_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  local  work="_T_chmod_x"
  local  lines
  local  line
  local  a1

  #// set up
  rm_func  "$work"
  mkdir -p "$work"
  pushd  "$work"

  mkdir  sub
  echo  "a"  > a.txt
  echo  "a"  > sub/b.txt
  echo  "a"  > a.html
  echo  "a"  > sub/b.html
  echo  "a"  > a.sh
  echo  "a"  > sub/b.sh
  chmod +x  "a.txt"
  chmod +x  "sub/b.txt"
  chmod +x  "a.html"
  chmod +x  "sub/b.html"

  #// Test Main
  $g_MenuPath  chmod_x  ""  ""  ""


  #// check
  a1=`ls -l`
  ArrayClass.fromLines_method  lines  "$a1"  #//[out] lines
  for line  in "${lines[@]}" ;do
    T_chmod_x_check_mod_func  "$line"  "a.txt"   "-rw-r--r--"
    T_chmod_x_check_mod_func  "$line"  "a.html"  "-rw-r--r--"
    T_chmod_x_check_mod_func  "$line"  "a.sh"    "-rwxr-xr-x"
  done ; done_func $?

  a1=`ls -l sub`
  ArrayClass.fromLines_method  lines  "$a1"  #//[out] lines
  for line  in "${lines[@]}" ;do
    T_chmod_x_check_mod_func  "$line"  "b.txt"   "-rw-r--r--"
    T_chmod_x_check_mod_func  "$line"  "b.html"  "-rw-r--r--"
    T_chmod_x_check_mod_func  "$line"  "b.sh"    "-rwxr-xr-x"
  done ; done_func $?


  #// clean
  popd
  rm_func  "$work"
}


function  T_chmod_x_check_mod_func()
{
  local  Line="$1"
  local  FileName="$2"
  local  Mod="$3"

  StringClass.indexOf_method  "$Line"  "$FileName"
  if [ "$g_Ret" -ge "0" ];then
    StringClass.indexOf_method  "$Line"  "$Mod"
    if [ "$g_Ret" == "-1" ];then  Error_func  ;fi
    echo  "$FileName"
  fi
}


 
#//*********************************************************************
#// <<< [T_InputCommandOpt_func] >>>
#//*********************************************************************
function  T_InputCommandOpt_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  ./T_Menu.sh  --T_InputCommandOpt_NoMenuCaption_func  99
}


if [ "${BASH_VERSINFO[0]}" -ge "4" ];then
  declare_AssociativeArrayClass="declare -A"
else
  declare_AssociativeArrayClass="declare"
fi

$declare_AssociativeArrayClass  g_InputCommandOpt


 
#//*********************************************************************
#// <<< [T_InputCommandOpt_NoMenuCaption_func] >>>
#//*********************************************************************
function  T_InputCommandOpt_NoMenuCaption_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  local  AppKey="$2"
  local  obj="g_InputCommandOpt"

  SetAttr_as_AssociativeArrayName_func  $obj  CommandReplace  \
    "1" "Dummy"

  ArrayClass.remove_method  g_Arguments  1
  InputCommand_func  $obj  ""  "$1"  "$AppKey"
}


 
#//*********************************************************************
#// <<< [T_InputOptionAuto_func] >>>
#//*********************************************************************
function  T_InputOptionAuto_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  ./T_Menu.sh  --T_InputOptionAuto_Sub_func  --value="abc"  --no_value
}

function  T_InputOptionAuto_Sub_func()
{
  local  value="default"
  local  no_value="0"
  local  no_option="0"

  ArrayClass.remove_method  g_Arguments  1

  InputOption_func  value  no_value  no_option

  Assert_func  '"$value" == "abc"'
  Assert_func  '"$no_value" == "1"'
  Assert_func  '"$no_option" == "0"'
}


 







#//--- start of bashlib include ------------------------------------------------------ 

#// <<< set up bashlib and call Main_func >>> 

#// bashlib is provided under 3-clause BSD license.
#// Copyright (C) 2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

g_BashLibPath="scriptlib/bashlib_inc.sh"; g_Ver="1.0"
g_StartInPath=`pwd`; cd "`dirname "$BASH_SOURCE"`"; g_Arguments=( "$BASH_SOURCE" "$@" )
for (( i = 0; i < 20; i ++ ));do
  if [ -e "$g_BashLibPath" ];then break ;else  g_BashLibPath="../$g_BashLibPath" ;fi ;done
if [ "$i" == "20" ];then  echo "${g_BashLibPath##*../} が見つかりません。
bashlib $g_Ver をダウンロードして scriptlib フォルダーをコピーしてください。"; exit 1 ;fi
source  "$g_BashLibPath"  #// include
CallMain_func
#//--- end of bashlib include --------------------------------------------------------
 
