#!/bin/bash -eE
                  #// Content-Type: text/plain; charset=utf-8
                  #// -eE オプションは、エラーが起きたら中断します
                  #// -x オプションは、１行ずつコマンドを表示します

g_AllArguments="$@"
g_FuncName=${1#--*}  #// cut -- from $1

function  Main_func()
{
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD"
  if [ "$g_FuncName" == "" ]; then
    echo  "関数一覧："
    echo  T_GlobalVarRetSpeed_func
    echo  T_EchoRetSpeed_func
    Error_func  "呼び出すスクリプト内の関数を指定してください。例 $BASH_SOURCE --T_Test1_func"
  fi
  $g_FuncName  "$@"
  ColorText_func  "Pass."  "Green" "Bold" ; echo_e_func  "$g_Ret"
}


 
#//*********************************************************************
#// <<< [T_GlobalVarRetSpeed_func] >>>
#//*********************************************************************
function  T_GlobalVarRetSpeed_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}
  echo  "time と一緒に起動して、時間を計測してください。"

  local  num
  local  ret

  for (( num = 0 ; $num < 10000 ; num ++ )) ;do
    GlobalVarRet_func ; ret="$g_Ret"
  done ; done_func $?
  echo  "$ret"
}


 
#//*********************************************************************
#// <<< [GlobalVarRet_func] >>>
#//*********************************************************************
export  g_Ret

function  GlobalVarRet_func()
{
  g_Ret="ret"
}


 
#//*********************************************************************
#// <<< [T_EchoRetSpeed_func] >>>
#//*********************************************************************
function  T_EchoRetSpeed_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}
  echo  "time と一緒に起動して、時間を計測してください。"

  local  num
  local  ret

  for (( num = 0 ; $num < 10000 ; num ++ )) ;do
    ret=`EchoRet_func`
  done ; done_func $?
  echo  "$ret"
}


 
#//*********************************************************************
#// <<< [EchoRet_func] >>>
#//*********************************************************************
function  EchoRet_func()
{
  echo  "ret"
}


 
#//*********************************************************************
#// <<< [T_StringReplaceSpeed_func] >>>
#//*********************************************************************
function  T_StringReplaceSpeed_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}
  echo  "time と一緒に起動して、時間を計測してください。"

  local  i

  for (( i = 0; $i < 10000; i++ )) ;do
    StringClass.replace_method  "abcde"  "c"  "xx"
  done ; done_func $?
}


 







#//--- start of bashlib include ------------------------------------------------------ 

#// <<< set up bashlib and call Main_func >>> 

#// bashlib is provided under 3-clause BSD license.
#// Copyright (C) 2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

g_BashLibPath="scriptlib/bashlib_inc.sh"; g_Ver="1.0"
g_StartInPath=`pwd`; cd "`dirname "$BASH_SOURCE"`"; g_Arguments=( "$BASH_SOURCE" "$@" )
for (( i = 0; i < 20; i ++ ));do
  if [ -e "$g_BashLibPath" ];then break ;else  g_BashLibPath="../$g_BashLibPath" ;fi ;done
if [ "$i" == "20" ];then  echo "${g_BashLibPath##*../} が見つかりません。
bashlib $g_Ver をダウンロードして scriptlib フォルダーをコピーしてください。"; exit 1 ;fi
source  "$g_BashLibPath"  #// include
CallMain_func
#//--- end of bashlib include --------------------------------------------------------
 
