#ifndef CALCULATE_GEOMETRY_H
#define CALCULATE_GEOMETRY_H

/*!
  \file
  \brief ֌W̌vZ

  \author Satofumi KAMIMURA

  $Id$
*/

#include "GridTypes.h"
#include "MathUtils.h"


namespace beego {
  /*!
    \brief ʒuƂ̋vZ
  */
  template<class T> T calculate_getLength_toPosition(const Position<T>& pos,
                                                     const Position<T>& line) {

    double diff_x = pos.x - line.x;
    double diff_y = pos.y - line.y;
    double radian = line.angle.to_rad();
    return static_cast<T>((diff_x * cos(radian) + diff_y * sin(radian)));
  }


  /*!
    \brief _Ƃ̋vZ
  */
  template<class T> T calculate_getLength_toPoint(const Position<T>& pos,
                                                  const Grid<T>& point) {

    double x_diff = pos.x - point.x;
    double y_diff = pos.y - point.y;
    return static_cast<T>(sqrt((x_diff * x_diff) + (y_diff * y_diff)));
  }


  /*!
    \brief Ƃ̋vZ
  */
  template<class T> T calculate_getLength_toLine(const Position<T>& pos,
                                                 const Grid<T> p0,
                                                 const Grid<T> p1) {

    Position<T> line(p0.x, p0.y, rad(atan2(p1.y - p0.y, p1.x - p0.x)));
    T length0 = calculate_getLength_toPosition<T>(pos, line);

    set_Position(&line, p1.x, p1.y, rad(atan2(p0.y - p1.y, p0.x - p1.x)));
    T length1 = calculate_getLength_toPosition<T>(pos, line);

    if (length0 * length1 < 0) {
      // [_Ƃ̋Ԃ
      double x_diff = p0.x - pos.x;
      double y_diff = p0.y - pos.y;
      double length_p0 = (x_diff * x_diff) + (y_diff * y_diff);

      x_diff = p1.x - pos.x;
      y_diff = p1.y - pos.y;
      double length_p1 = (x_diff * x_diff) + (y_diff * y_diff);

      double min_length = (length_p0 > length_p1) ? length_p1 : length_p0;
      return static_cast<T>(sqrt(min_length));

    } else {
      // Ƃ̋Ԃ
      set_Position(&line, p0.x, p0.y,
                   rad(atan2(p1.y - p0.y, p1.x - p0.x) + M_PI/2));
      T length = calculate_getLength_toPosition<T>(pos, line);
      return (length < 0) ? -length : length;
    }
  }
};

#endif /* !CALCULATE_GEOMETRY_H */
