#ifndef FILE_TO_ARGS_H
#define FILE_TO_ARGS_H

/*!
  \page file_to_args_page ftHg̓ǂݏo

  ֐ optionHandler(argc, argv) ƂɁAt@CɋLqftHgݒ邽߂̎dg݁Bt@C̋LqɁAargc, argv 𐶐B

  - \ref file_to_args_section_sample
  - \ref file_to_args_section_usage

  \n
  \section file_to_args_section_sample r[Sp̐ݒt@C
  \include beegoconf

  \n
  \section file_to_args_section_usage gp

  TvvO
\code
#include <iostream>
#include <string>

static std::string SerialPort = "/dev/ttyUSB0";

static void optionHandler(int argc, char *argv[]) {
  for (int i = 1; i < argc; ++i) {
    if (! strncmp("--port=", argv[i], 7)) {
      SerialPort = &argv[i][7];
    }
  }
}

int main(int argc, char *argv[]) {

  FileToArgs fileArgs;
  if (fileArgs.load("configfile.txt")) {
    optionHandler(fileArgs.argc, fileArgs.argv, argv[0]);
  }
  optionHandler(argc, argv);

  std::cout << "serial port: " << SerialPort << std::endl;

  return 0;
}
\endcode

  ݒt@C̏ڍא
\verbatim
# ftHgݒ
--port=/dev/usb/ttyUSB0

# programName  sloader ̂ƂLB--port=/dev/usb/ttyUSB0 ̐ݒ͏㏑
sloader --port=/dev/usb/ttyUSB1

# programName K\ .+loader ̂Ƃ̂ݗL (aloader, abcloader Ȃ)
# {IɁA̍sł̐ݒ́AOɐݒ肳ꂽڂ㏑
.+loader --port=/dev/usb/ttyUSB2
\endverbatim

  ݒt@Cɂ
  - '#' n܂śARgƂĖ
  - es̈Ƃď
  - sɋ󔒂ŋ؂ꂽQ̃g[Nꍇ
    - ŏ̃g[N programName vꍇ̂݁AQg[N
    - ŏ̃g[Nɂ́AK\p\ (v boost)

  \attention IuWFNgjƓɈneɂȂ邽߁A̓Rs[邱Ƃ]܂B
*/


/*!
  \file
  \brief t@C擾

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>


namespace beego {
  /*!
    \brief t@C̐
  */
  class FileToArgs {
    FileToArgs(const FileToArgs& rhs);
    FileToArgs& operator = (const FileToArgs& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    int argc;
    char **argv;

    FileToArgs(void);
    ~FileToArgs(void);

    /*!
      \brief ̓ǂݏo

      \param fname [i] ݒt@C
      \param programName [i] argv[0] ɓo^vO

      \attention ǂݏoéAfXgNgɔj

      <strong>Tv</strong>
      - \ref file_to_args_page
    */
    bool load(const char* fname, const char* programName = "");
  };
};

#endif /* !FILE_TO_ARGS_H */
