#ifndef MOVING_AVERAGE_H
#define MOVING_AVERAGE_H

/*!
  \file
  \brief ړς̌vZ

  \author Satofumi KAMIMURA

  $Id$
*/

namespace beego {
  /*!
    \brief ړς̃ev[g
  */
  template<class T> class MovingAverage {
    MovingAverage(const MovingAverage& rhs);
    MovingAverage& operator = (const MovingAverage& rhs);

    std::deque<T> buffer;
    size_t buffer_size;
    T average;
    T total;

    void buffer_set(size_t size, T value) {
      buffer.assign(size, value);
      average = value;
      total = average * size;
    }

  public:
    MovingAverage(size_t size) : buffer_size(size), total(0) {
      if (size == 0) {
        buffer_size = 1;
      }
      buffer_set(buffer_size, 0);
    }

    void setAverageValue(T value) {
      buffer_set(buffer_size, value);
    }

    T getAverage(void) {
      return average;
    }

    void push_back(T value) {

      total -= buffer.front();
      buffer.pop_front();
      total += value;
      buffer.push_back(value);

      average = total / static_cast<T>(buffer_size);
    }
  };
};

#endif /* !MOVING_AVERAGE_H */
