/*!
  \file
  \brief CalculateGeometry ̃eXg

  \author Satofumi KAMIMURA

  $Id$
*/

#include "TestCalculateGeometry.h"
#include "CalculateGeometry.h"


CPPUNIT_TEST_SUITE_REGISTRATION(CalculateGeometryTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(CalculateGeometryTest,
                                      "CalculateGeometryTest");

using namespace beego;


void CalculateGeometryTest::compileTest(void) {

  Position<int> pos(0, 0, deg(0));
  Position<int> line(1000, 0, deg(0));
  calculate_getLength_toPosition<int>(pos, line);

  Grid<int> point(0, 0);
  calculate_getLength_toPoint(pos, point);
}


void CalculateGeometryTest::toPositionTest(void) {

  Position<int> pos(0, 0, deg(0));
  Position<int> line(+1000, 0, deg(0));

  int length = calculate_getLength_toPosition<int>(pos, line);
  CPPUNIT_ASSERT_EQUAL(-1000, length);

  set_Position(&line, -1000, 0, deg(0));
  length = calculate_getLength_toPosition<int>(pos, line);
  CPPUNIT_ASSERT_EQUAL(+1000, length);

}


void CalculateGeometryTest::toPointTest(void) {

  Position<int> pos(0, 0, deg(0));
  Grid<int> point(1000, 0);

  int length = calculate_getLength_toPoint<int>(pos, point);
  CPPUNIT_ASSERT_EQUAL(1000, length);
}


void CalculateGeometryTest::toLineTest(void) {

  Position<int> pos(0, 0, deg(0));
  Grid<int> p0(0, 3000);
  Grid<int> p1(+4000, 3000);
  int length = calculate_getLength_toLine<int>(pos, p0, p1);
  CPPUNIT_ASSERT_EQUAL(3000, length);

  set_Position(&pos, +4000, 0, deg(0));
  length = calculate_getLength_toLine<int>(pos, p0, p1);
  CPPUNIT_ASSERT_DOUBLES_EQUAL(3000, length, 1);

  set_Position(&pos, +8000, 0, deg(0));
  length = calculate_getLength_toLine<int>(pos, p0, p1);
  CPPUNIT_ASSERT_DOUBLES_EQUAL(5000, length, 1);

  set_Position(&pos, -4000, 3000, deg(0));
  length = calculate_getLength_toLine<int>(pos, p0, p1);
  CPPUNIT_ASSERT_EQUAL(4000, length);

  set_Position(&pos, +6000, 3000, deg(0));
  length = calculate_getLength_toLine<int>(pos, p0, p1);
  CPPUNIT_ASSERT_EQUAL(2000, length);
}

