/*!
  \file
  \brief MovingAverage ̃eXg

  \author Satofumi KAMIMURA

  $Id$
*/

#include "TestMovingAverage.h"
#include "MovingAverage.h"


CPPUNIT_TEST_SUITE_REGISTRATION(MovingAverageTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(MovingAverageTest, "MovingAverageTest");

using namespace beego;


void MovingAverageTest::compileTest(void) {
  MovingAverage<int> buffer(1);
}


void MovingAverageTest::firstValueTest(void) {

  MovingAverage<int> int_buffer1(1);
  CPPUNIT_ASSERT_EQUAL(0, int_buffer1.getAverage());

  MovingAverage<int> int_buffer2(3);
  CPPUNIT_ASSERT_EQUAL(0, int_buffer2.getAverage());

  MovingAverage<double> double_buffer(3);
  CPPUNIT_ASSERT_EQUAL(0.0, double_buffer.getAverage());
}


void MovingAverageTest::setAverageValueTest(void) {

  MovingAverage<int> int_buffer1(1);
  int_buffer1.setAverageValue(2);
  CPPUNIT_ASSERT_EQUAL(2, int_buffer1.getAverage());

  MovingAverage<int> int_buffer2(3);
  int_buffer2.setAverageValue(4);
  CPPUNIT_ASSERT_EQUAL(4, int_buffer2.getAverage());

  MovingAverage<double> double_buffer(1);
  double_buffer.setAverageValue(2.34);
  CPPUNIT_ASSERT_EQUAL(2.34, double_buffer.getAverage());
}


void MovingAverageTest::pushTest(void) {

  MovingAverage<int> buffer(3);

  buffer.push_back(3);
  CPPUNIT_ASSERT_EQUAL(1, buffer.getAverage());

  buffer.push_back(3);
  CPPUNIT_ASSERT_EQUAL(2, buffer.getAverage());

  buffer.push_back(-6);
  CPPUNIT_ASSERT_EQUAL(0, buffer.getAverage());

  buffer.push_back(0);
  CPPUNIT_ASSERT_EQUAL(-1, buffer.getAverage());

  buffer.push_back(0);
  CPPUNIT_ASSERT_EQUAL(-2, buffer.getAverage());

  buffer.push_back(0);
  CPPUNIT_ASSERT_EQUAL(0, buffer.getAverage());
}
