/*!
  \file
  \brief PointerRingBuffer ̃eXg

  \author Satofumi KAMIMURA

  $Id$
*/

#include "TestPointerRingBuffer.h"
#include "PointerRingBuffer.h"


CPPUNIT_TEST_SUITE_REGISTRATION(PointerRingBufferTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(PointerRingBufferTest,
                                      "PointerRingBufferTest");


void PointerRingBufferTest::compileTest(void) {
  PointerRingBuffer<char*> buffer;
}


void PointerRingBufferTest::resizeTest(void) {
  PointerRingBuffer<char*> buffer;

  // 
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), buffer.size());
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), buffer.capacity());

  // TCY 1 ɐݒ
  char ch1;
  buffer.push_buffer(&ch1);
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), buffer.capacity());
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), buffer.size());

  // TCY 3 ɐݒ
  char ch2, ch3;
  buffer.push_buffer(&ch2);
  buffer.push_buffer(&ch3);
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(3), buffer.capacity());
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), buffer.size());
}


void PointerRingBufferTest::putTest(void) {

  PointerRingBuffer<char*> buffer;
  char ch1_buffer, ch2_buffer;
  buffer.push_buffer(&ch1_buffer);
  buffer.push_buffer(&ch2_buffer);
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(0), buffer.size());

  char* p = buffer.get_buffer();
  *p = '1';
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), buffer.size());

  p = buffer.get_buffer();
  *p = '2';
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(2), buffer.size());

  p = buffer.front();
  CPPUNIT_ASSERT_EQUAL('1', *p);

  buffer.rotate();
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), buffer.size());

  p = buffer.front();
  CPPUNIT_ASSERT_EQUAL('2', *p);
}
