/*!
  \file
  \brief SearchFilePath ̃eXg

  \author Satofumi KAMIMURA

  $Id$
*/

#include "TestSearchFilePath.h"
#include "SearchFilePath.h"


CPPUNIT_TEST_SUITE_REGISTRATION(SearchFilePathTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(SearchFilePathTest,
                                      "SearchFilePathTest");

using namespace beego;


void SearchFilePathTest::searchTest(void) {

  std::vector<std::string> try_path;
  try_path.push_back(".");
  try_path.push_back("..");

  std::string full_path;
  bool ret = searchFilePath(full_path, "ChangeLog", try_path);
  CPPUNIT_ASSERT_EQUAL(true, ret);
  CPPUNIT_ASSERT_EQUAL(std::string("../ChangeLog"), full_path);
}


void SearchFilePathTest::replaceTest(void) {

  // ~/.beego/beegoconf ȂƁAeXgɎs
  std::vector<std::string> try_path;
  try_path.push_back("~/.beego");
  std::string full_path;
  bool ret = searchFilePath(full_path, "beegoconf", try_path);
  CPPUNIT_ASSERT_EQUAL(true, ret);
}
