/*!
  \file
  \brief F-ZTAT ̊Ǘ

  \author Satofumi KAMIMURA

  lTX񋟂́uSH704x V[Ỹn[hEFA}jAvɏ]Ď

  $Id$
*/

#include "FZtatHandler.h"
#include "SFormatHandler.h"
#include "SerialCtrl.h"
#include "wctrl_data.h"

using namespace beego;


/*!
  \brief FZtatHandler ̓NX
*/
struct FZtatHandler::pImpl {
  enum {
    Timeout = 64,                // [msec]
    LongTimeout = 1000,                // [msec]
    FirstBaudrate = 19200,        // [bps]
    WriteBaudrate = 115200,
  };
  std::string error_message;
  long send_baudrate;
  SFormatHandler* sformat;

  /*!
    \brief f[^̑MǗ
  */
  class SendDataHandler {
  public:
    enum { DataLength = 32 };
    ConnectionInterface* con;
    unsigned long address;
    unsigned char write_data[DataLength];
    bool filled;
    size_t lines_counter;
    size_t lines_max;
    unsigned long start_address;

    SendDataHandler(void)
      : con(NULL), address(0x0), filled(false),
        lines_counter(0), lines_max(0), start_address(0x400000) {
      clear();
    }

    ~SendDataHandler(void) {
      delete con;
    }

    unsigned long getWriteAddress(unsigned long write_address) {
      return write_address & 0xffffffe0;
    }

    void clear(void) {
      memset(write_data, 0, DataLength);
    }

    void setData(SFormatHandler::srec_t* srec) {

      size_t offset = (srec->address == address) ? 0 : 16;
      for (size_t i = 0; i < 16; ++i) {
        write_data[i + offset] = srec->byte_data[i];
      }
    }


    static unsigned char calcChecksum(unsigned char data[], int data_length) {

      unsigned char sum = 0;
      for (int i = 0; i < data_length; ++i) {
        sum += data[i];
      }
      return sum;
    }


    void sendAddress(unsigned long next_address) {

      // ÄłȂƂ̂݁Ãf[^MɃAhX𑗐M
      if ((address + 32) == next_address) {
        return;
      }
      //fprintf(stderr, "send addres: %08x\n", address);

      enum { SendLength = 1 + 4 + 1 };
      unsigned char buffer[SendLength];
      buffer[0] = 'A';

      // Mf[^̍쐬
      unsigned long send_address = address;
      for (int i = 3; i >= 0; --i) {
        buffer[1 + i] = send_address & 0xff;
        send_address >>= 8;
      }

      // `FbNT̍쐬
      buffer[SendLength - 1] = calcChecksum(buffer, SendLength -1);

      int n = con->send((const char*)buffer, SendLength);
      if (n != SendLength) {
        // !!!
        fprintf(stderr, "$$$3\n");
      }
    }

    bool sendData(void) {
      //fprintf(stderr, "send!\n");

      // Mf[^̍쐬
      enum { SendLength = 1 + 32 + 1 };
      unsigned char buffer[SendLength];
      buffer[0] = 'D';

      // f[^̊i[
      memmove(&buffer[1], write_data, 32);

      // `FbNT̍쐬
      buffer[SendLength - 1] = calcChecksum(buffer, SendLength -1);

      // f[^M
      int n = con->send((const char*)buffer, SendLength);
      if (n != SendLength) {
        // !!!
        fprintf(stderr, "$$2\n");
        return false;
      }

      // ݉̊mF
      //if (pImpl::replyCheck(con, '0', "? ##1", "? ##2")) {
      char recv_ch = '#';
      n = con->recv(&recv_ch, 1, LongTimeout);
      if ((n < 1) || (recv_ch != '0')) {
        // !!! gC
        //fprintf(stderr, "n = %d, recv_ch = %c\n", n, recv_ch);
        //fprintf(stderr, "writing fail: address: %p\n", address);
        return false;
      }

      // I
      address += 32;
      return true;
    }
  };
  SendDataHandler args;


  pImpl(void)
    : error_message("no error."), send_baudrate(WriteBaudrate),
      sformat(NULL) {
  }


  bool sendWriteProgram(void) {

    // ̃rbg[g 0x00 AMA^[Qbg 0x00 M
    char ch = 0x00;
    char recv_ch = 0xff;
    for (int i = 0; i < 10; ++i) {
      args.con->send(&ch, 1);
      //delay(1);
      //fprintf(stderr, "?");
      int n = args.con->recv(&recv_ch, 1, 1);
      if (n > 0) {
        break;
      }
    }
    if (recv_ch != 0x00) {
      error_message = "in adjusting baudrate. (first step)";
      return false;
    }

    // 0x55  1byte M
    ch = 0x55;
    args.con->send(&ch, 1);

    // ^[Qbg 0xaa M
    if (! replyCheck(args.con, 0xaa, "? 00", "? 01")) {
      return false;
    }

    // ]vÕoCgʁAʂ̏ɑM
    size_t send_size = sizeof(write_program) -1;
    char size_data[] = { send_size >> 8, send_size };
    args.con->send(size_data, 2);

    // MvOoCg̃GR[obNM
    char recv_data[2];
    int n = args.con->recv(recv_data, 2, Timeout);
    if (n < 2) {
      // !!!
      error_message = "? 1";
      return false;
    }
    if (strncmp(size_data, recv_data, 2)) {
      // !!!
      error_message = "? 2";
      return false;
    }

    // ]vO 1byte ɑMAGR[obNM
    n = args.con->send(write_program, send_size);
    if (n != static_cast<int>(send_size)) {
      // !!!
      error_message = "??? 1";
      return false;
    }

    // MeƃGR[obNƂr
    char* buffer = new char[send_size];
    n = args.con->recv(buffer, send_size, Timeout);
    if (n != static_cast<int>(send_size)) {
      // !!!
      error_message = "??? 2";
      delete [] buffer;
      return false;
    }
    if (memcmp(write_program, buffer, send_size)) {
      // !!!
      error_message = "??? 3";
      return false;
    }
    delete [] buffer;

    //  0xaa 󂯎
    if (! replyCheck(args.con, 0xaa, "? 00A", "? 01A")) {
      fprintf(stderr, "erase fail?\n");
      return false;
    }

    return true;
  }


  static bool writeEachLine(SFormatHandler::srec_t* srec, void* args) {
    SendDataHandler* info = static_cast<SendDataHandler*>(args);
    if (! args) {
      // !!! G[bZ[WAOo͂ɂAƂH
      fprintf(stderr, "SendDataHandler is NULL\n");
      return false;
    }

    const char* output_format = "\r%3.1f %% complete. ";
    double percent = 100.0 * info->lines_counter / info->lines_max;
    fprintf(stderr, output_format, percent);
    ++info->lines_counter;

    if (srec->type >= 7) {
      info->start_address = srec->address;

    } else if ((srec->type >= 1) && (srec->type <= 3)) {
      // S[1-3] ̏݃f[^ȊOȂ΁A]f[^ƂĈȂ

      // AhXȂAf[^i[Ɠ]̏s
      unsigned long write_address = info->getWriteAddress(srec->address);
      if (info->address != write_address) {

        if (! info->filled) {
          // ŏ̃AhXݒ
          info->address = write_address;
          info->sendAddress(write_address);

        } else {
          // !!! f[^΁A]Kv
          // !!! AAhX̏ꍇɂ́AAhXKXVׂ

          // AhX̑M
          info->sendAddress(write_address);

          // f[^̑M
          if (! info->sendData()) {
            fprintf(stderr, "sendData() faile.\n");
            return false;
          }

          info->clear();
          info->filled = false;
        }
      }
      // f[^̒ǉ
      info->address = write_address;
      info->setData(srec);
      info->filled = true;
    }
    // ŏIs̏̌ŁAcĂf[^Ώ݂s
    if ((info->lines_counter >= info->lines_max) && (info->filled)) {

      // f[^Iɏ
      // !!! LƂ̋ʕȂƂ
      if (! info->sendData()) {
        fprintf(stderr, "sendData() faile.\n");
        return false;
      }
    }

    fprintf(stderr, output_format, 100.0);
    return true;
  }


  bool writeSrecData(SFormatHandler& sf) {

    // SFromatHandler::checkLines() Ɋ֐o^ď݂s
    return sf.eachLines(pImpl::writeEachLine, &args);
  }


  void encode(unsigned char* data, unsigned long value) {
    for (int i = 3; i >= 0; --i) {
      data[i] = value & 0xff;
      value >>= 8;
    }
  }


  bool changeBaudrate(void) {

    // {[[g𐔒lđM
    enum { SendLength = 1 + 4 + 1 };
    char buffer[SendLength];
    buffer[0] = 'B';
    encode((unsigned char *)&buffer[1], send_baudrate);
    buffer[SendLength - 1] =
      pImpl::SendDataHandler::calcChecksum((unsigned char*)buffer,
                                           SendLength - 1);
    args.con->send(buffer, SendLength);

    if (! replyCheck(args.con, '0', "? 00 a", "? 00 b")) {
      return false;
    }
    // AĂA{[[gۂɕύXA^[Qbgɒʒm
    args.con->changeBaudrate(send_baudrate);
    args.con->send("0", 1);

    // !!! f[^𑗂A莞ԓɉȂ΁Ađ
    // !!! ͘AMȂ̂ŁAꂪLȂ͍̂Ō̍ŝ
    // !!! {[[gp̍\ɂĂ悩

    return true;
  }


  bool replyCheck(ConnectionInterface* con,
                  unsigned char expected, const char* noRecv_message,
                  const char* unexpected_message) {

    unsigned char recv_ch;
    int n = con->recv((char *)&recv_ch, 1, Timeout);
    if (n < 1) {
      error_message = noRecv_message;
      return false;
    }
    if (recv_ch != expected) {
      fprintf(stderr, "expected: %02x, actual: %02x\n", expected, recv_ch);
      error_message = unexpected_message;
      return false;
    }
    return true;
  }
};


FZtatHandler::FZtatHandler(void) : pimpl(new pImpl) {
}


FZtatHandler::~FZtatHandler(void) {
}


const char* FZtatHandler::what(void) {
  return pimpl->error_message.c_str();
}


ConnectionInterface*& FZtatHandler::getConnection(void) {
  return pimpl->args.con;
}


void FZtatHandler::setTargetCpu(const char* type) {
  // !!!
}


bool FZtatHandler::connect(const char* serialDevice, long baudrate) {

  delete pimpl->args.con;

  // ڑ
  pimpl->args.con = new SerialCtrl;
  pimpl->send_baudrate = baudrate;
  bool ret = pimpl->args.con->connect(serialDevice, pImpl::FirstBaudrate);
  if (ret == false) {
    pimpl->error_message = pimpl->args.con->what();
    // "Coudn't connect to target CPU";
    return false;
  } else {
    return true;
  }
}


bool FZtatHandler::write(SFormatHandler& sformat) {
  if (pimpl->args.con == NULL) {
    pimpl->error_message = "call connect(), before call write().";
    return false;
  }
  pimpl->sformat = &sformat;

  // ^[Qbgɏ݃vO̓]
  fprintf(stderr, "send write program ... ");
  bool ret = pimpl->sendWriteProgram();
  if (! ret) {
    return ret;
  }
  fprintf(stderr, "O.K.\n");

  // ݃f[^̑M
  if (! sendSrecData(*pimpl->sformat)) {
    return false;
  }
  return true;
}


bool FZtatHandler::sendSrecData(SFormatHandler& sformat) {

  // ^[Qbg̉҂
  if (! pimpl->replyCheck(pimpl->args.con, 'S', "fail connection.", "? X2")) {
    return false;
  }

  // {[[g̕ύX
  if (! pimpl->changeBaudrate()) {
    fprintf(stderr, "changeBaudrate() is FAIL!\n");
    return false;
  }

  pimpl->sformat = &sformat;
  pimpl->args.lines_max = pimpl->sformat->getLinesNum();
  return pimpl->writeSrecData(sformat);
}


bool FZtatHandler::sendStartAddress(void) {
  pimpl->args.address = pimpl->args.start_address;
  pimpl->args.sendAddress(0xffffffff);
  if (! pimpl->replyCheck(pimpl->args.con, '0', "? Xx1", "? Xx2")) {
    return false;
  }
  return true;
}
