/*!
  \file
  \brief j^Ή FZtatHandler

  \author Satofumi KAMIMURA

  $Id$

  \todo V~[Vł悤ɒ
*/

#include "mFZtatHandler.h"
#include "FZtatHandler.h"
#include "WriteTargetSimulator.h"
#include "TcpipCtrl.h"
#include "TargetSimulatorPort.h"
#include "ConnectionLogger.h"

using namespace beego;


/*!
  \brief mFZtatHandler ̓NX
*/
struct mFZtatHandler::pImpl {
  FZtatHandler handler;
  TargetSimulator target;
  bool simulator;

  pImpl(void) : simulator(false) {
  }
};


mFZtatHandler::mFZtatHandler(void) : pimpl(new pImpl) {
}


mFZtatHandler::~mFZtatHandler(void) {
}


const char* mFZtatHandler::what(void) {
  return pimpl->handler.what();
}


void mFZtatHandler::setTargetCpu(const char* type) {
  pimpl->handler.setTargetCpu(type);
}


/*!
  \brief V~[^ւ TCP/IP ڑ

  \todo xt TCP/IP Abaudrate 𔽉f
*/
bool mFZtatHandler::connect(const char* serialDevice, long baudrate) {

  if (! pimpl->simulator) {
    return pimpl->handler.connect(serialDevice, baudrate);

  } else {
    // ̐ڑؒf
    ConnectionInterface*& con = pimpl->handler.getConnection();
    delete con;

    // V~[^̋N TCP/IP ڑ̍쐬
    pimpl->target.activate();
    con = new ConnectionLogger(new TcpipCtrl);
    return (! con->connect("localhost", TargetSimulatorPort)) ? true : false;
  }
}


bool mFZtatHandler::write(SFormatHandler& sformat) {
  return pimpl->handler.write(sformat);
}


void mFZtatHandler::activate(void) {
  pimpl->simulator = true;
}
