/*!
  \file
  \brief SCI 

  \author Satofumi KAMIMURA

  $Id$
*/

#include "tiny_sci.h"
#include "cpu_akiduki.h"


enum {
  FirstBaudrate = 115200,
  SCI_BIT_WAIT = (int)(CPU_CLOCK / FirstBaudrate),
};


int setBaudrate(long baudrate) {
  volatile int i;

  switch (baudrate) {

  case 9600:
    SCI1.BRR = 92;
    break;

  case 19200:
    SCI1.BRR = 46;
    break;

  case 38400:
    SCI1.BRR = 22;
    break;

  case 57600:
    SCI1.BRR = 15;
    break;

  case 115200:
    SCI1.BRR = 7;
    break;

  default:
    return -1;
  }

  for (i = 0; i < SCI_BIT_WAIT; ++i) /* wait 1 bit */
    ;

  return 0;
}


void initSCI(long baudrate) {

  SCI1.SCR.BYTE = 0x00;
  SCI1.SMR.BYTE = 0;                /* 8bit, 1stop, no parity */
  setBaudrate(baudrate);
  PFC.PACRL2.WORD |= 0x0140;        /* enable RxD1, TxD1 */
  SCI1.SCR.BYTE = 0x30;                /* TE = 1, RE = 1 */
  SCI1.SSR.BYTE &= ~0x40;
}


char getch(void) {
  char ch;

  while((SCI1.SSR.BYTE & 0x40) == 0) /* RDRF */
    ;
  ch = SCI1.RDR;
  SCI1.SSR.BYTE &= ~0x40;        /* clear RDRF */

  return ch;
}


void getstr(char *buffer, int len) {
  int i;

  for (i = 0; i < len; ++i) {
    buffer[i] = getch();
  }
}


void flush(void) {
  while ((SCI1.SSR.BYTE & 0x04) == 0) /* TEND */
    ;
}


void putch(char ch) {

  while ((SCI1.SSR.BYTE & 0x80) == 0) /* TDRE */
    ;
  SCI1.TDR = ch;
  SCI1.SSR.BYTE  &= ~0x80;
}


void putstr(const char* str) {

  for (; *str != '\0'; ++str) {
    putch(*str);
  }
}
