/*!
  \file
  \brief F-ZTAT ݂̍ۂ̃vgR

  \author Satofumi KAMIMURA

  $Id$
*/

//#define DEBUG

#include "write_rom.h"
#include "tiny_sci.h"

#ifdef DEBUG
#ifndef __sh__
#include <stdio.h>
#endif
#endif


extern int writeFlushRom(long addr, unsigned char *data);


enum { RetryTimes = 33 };


static unsigned long decode(unsigned char hh, unsigned char hl,
                            unsigned char lh, unsigned char ll) {
  return (hh << 24) | (hl << 16) | (lh << 8) | ll;
}


// `FbNT̊mF
static int check(const unsigned char* line, int size, unsigned char expected) {
  unsigned char actual = 0;
  int i;

  for (i = 0; i < size; ++i) {
    actual += line[i];
  }
  return (actual == expected) ? 0 : -1;
}


int adjustBaudrate(void) {
  unsigned char buffer[6];
  unsigned char check_sum = 0;
  long baudrate = 0;
  volatile int i;

  for (i = 0; i < RetryTimes; ++i) {

    // {[[gݒ̎󂯎
    enum { DataLength = 1 + 4 + 1 };
    getstr((char *)buffer, DataLength);

    if (buffer[0] != 'B') {
      putch('B');
      continue;
    }
    check_sum = buffer[DataLength - 1];
    if (check(buffer, DataLength - 1, check_sum)) {
      putch('B');
      continue;
    }
    putch('0');
    flush();

    // `FbNT܂ł{[[g̐lƂēǂݍ܂
    baudrate = decode(buffer[1], buffer[2], buffer[3], buffer[4]);
#ifdef DEBUG
#ifndef __sh__
    printf("baudrate: %ld\n", baudrate);
#endif
#endif

    // !!! {[[g܂́AƂłƃfobO
    if (! setBaudrate(baudrate)) {
      // {[[gύXɂf[^M
      // !!! ƂŁAvolatile int i 𕁒ʂ int i ɂĂ
      //if (1) {
      //putch('0');
      getch();
      return 0;

    } else {
      // w{[[g݂Ȃꍇ
      putch('E');
      return -1;
    }
  }

  // gC
  putch('F');
  return -1;
}


unsigned long recvAddress(void) {
  char buffer[1 + 4 + 1];
  unsigned long address = 0;
  buffer[0] = 'A';

  while (1) {
    getstr(&buffer[1], 4 + 1);
    if (! check((unsigned char *)buffer, 1 + 4, buffer[1 + 4])) {
      // !!! ߂ďނƂȂ悤ȃ`FbNsׂ
      // !!! Ô
      address = decode(buffer[1], buffer[2], buffer[3], buffer[4]);
      putch('0');
      break;

    } else {
      putch('A');
      getch();
    }
  }

  return address;
}


static void writeData(void) {
  unsigned long address = 0x0;

  // !!! ܂́AgCCɂɎĂ܂

  char buffer[1 + 32 + 1];
  while (1) {
    char first_ch;

    buffer[0] = getch();
    first_ch = buffer[0];

    if (first_ch == 'A') {
      // ݃AhXʒu̍XV
      address = recvAddress();

    } else if (first_ch == 'D') {
      // ݃f[^̎MƏ
      getstr(&buffer[1], 32 + 1);
      if (! check((unsigned char *)buffer, 1 + 32, buffer[1 + 32])) {

#ifdef DEBUG
#ifndef __sh__
        // ݓẽfobO\
        int j;
        printf("%08lx: ", address);
        for (j = 0; j < 32; ++j) {
          printf("%02x ", (unsigned char)buffer[1 + j]);
        }
        printf("\n");
#endif
#endif
        // 
        if (writeFlushRom(address, (unsigned char *)&buffer[1])) {
          // !!! gCǂ悤
          // !!! AŎsA߂...
          putch('E');
          // ł悢

        } else {

          // AhXʒui߂
          address += 32;
          putch('0');
        }
      }

    } else if (first_ch == 'Q') {
      // I
      return;

    } else {
      // !!! ႟A͂ẮH
      putch('E');
    }
  }
}


void writeRom(void) {

  // NbZ[W̑M
  putch('S');

  // {[[gύX
  if (adjustBaudrate()) {
    return;
  }

  // f[^M
  writeData();
}
