OUTPUT_FORMAT("coff-sh")
OUTPUT_ARCH(sh)
MEMORY
{
  rom(wx)   : o = 0x00000000, l = 256K
  ram(rw)   : o = 0x00400000, l = 1M
  stack(rw) : o = 0xfffff000, l = 4K
}
SECTIONS
{
  .text :
  {
     _vec_ram = . ;
   LONG(ABSOLUTE(start))	/* 0 */
   LONG(ABSOLUTE(_stack))	/* 1 */
   LONG(ABSOLUTE(start))	/* 2 */
   LONG(ABSOLUTE(_stack))	/* 3 */

    *(.text)
    *(.strings)
    _cp_start = . ;
  }  > rom
  .tors :
  AT ( ADDR(.text) + SIZEOF(.text) )
  {
    _data_start = .;
    ___ctors = . ;
    *(.ctors)
    ___ctors_end = . ;
    ___dtors = . ;
    *(.dtors)
    ___dtors_end = . ;
  } > stack
  .data :
  AT ( ADDR(.text) + SIZEOF(.text) + SIZEOF(.tors) )
  {
    *(.data)
     _edata = . ; 
     _cp_end = . ;
  }  > ramL
  .bss :
  {
     _bss_start = . ; 
    *(.bss)
    *(COMMON)
     _end = . ;  
  }  > ramL

  .stack  0xfffff000+4K-0x10 (NOLOAD) :
  {
     _stack = . ;
    *(.stack)
  }  > ramL

  .stab 0 (NOLOAD) :
  {
    *(.stab)
  }
  .stabstr 0 (NOLOAD) :
  {
    *(.stabstr)
  }
}
