/*!
  \file
  \brief S-Format [_[

  \author Satofumi KAMIMURA

  $Id$
*/

#include "DetectOS.h"
#include "SFormatHandler.h"
#include "FZtatHandler.h"
#include "ConnectionInterface.h"
#include "StandardInput.h"
#ifdef MONITOR
#include "LoaderTargetSimulator.h"
#endif
#include "FileToArgs.h"
#include "SearchFilePath.h"
#include <stdio.h>
#include <stdlib.h>
#include <fstream>

using namespace beego;


static const char* LogFileName = "sloader_log.txt";


// !!! ̂Ash2writer ƋʂɂłȂȁH
#if defined(LINUX_OS)
static const char* DefaultSerialDevice = "/dev/ttyS0";
static const long DefaultBaudrate = 115200;

#elif defined(WINDOWS_OS)
static const char* DefaultSerialDevice = "COM1";
static const long DefaultBaudrate = 115200;

#elif defined(MAC_OS)
// !!! ɔF邩́As
static const char* DefaultSerialDevice = "/dev/ttyS0";
static const long DefaultBaudrate = 115200;
#else
// !!! xbZ[W̕\
#endif


/*!
  \brief sloader ̈Ǘ
*/
class ArgsInfo {
public:
  const char* sformatFile;
  std::string serialDevice;
  long baudrate;
  long terminalBaudrate;
  const char* targetCpu;
  bool simulator;
  bool record ;

  ArgsInfo(void)
    : sformatFile(NULL), serialDevice(DefaultSerialDevice),
      baudrate(DefaultBaudrate), terminalBaudrate(DefaultBaudrate),
      targetCpu("SH7040"), simulator(false), record(false) {
  }
};


static void printHelp(const char* progname,
                      const char* device,
                      long baudrate, long terminal_baudrate) {
  printf("usage:\n"
         "\t%s [options] <S-Fromat file>\n"
         "\n"
         "options:\n"
         "-h, --help\t\tprint this message.\n"
         "-v, --version\t\tprint version message.\n"
         "--port=<PORT>\t\tspecify serial device. (default %s)\n"
         "--baudrate=<BAUDRATE>\tspecify send baudrate. (default %ld bps)\n"
         "--t_baudrate=<BAUDRATE>\tspecify terminal baudrate. "
         "(default %ld bps)\n"
         "-r, --record\treceive data record to \"%s\"\n"
         "\n",
         progname, device, baudrate, terminal_baudrate, LogFileName);
}


static void parseArgs(ArgsInfo& info, int argc, char* argv[]) {

  for (int i = 1; i < argc; ++i) {
    if ((! strcmp("-s", argv[i])) || (! strcmp("--simulator", argv[i]))) {
      // V~[V[h
      info.simulator = true;

    } else if (! strncmp("--port=", argv[i], 7)) {
      // ڑfoCX̍XV
      info.serialDevice = &argv[i][7];

    } else if (! strncmp("--baudrate=", argv[i], 11)) {
      // ʐM{[[g̍XV
      info.baudrate = atoi(&argv[i][11]);

    } else if (! strncmp("--t_baudrate=", argv[i], 13)) {
      // ʐM{[[g̍XV
      info.terminalBaudrate = atoi(&argv[i][13]);

    } else if ((! strcmp("-v", argv[i])) || (! strcmp("--version", argv[i]))) {
      // !!! Õo[W𔽉f
      printf("sh2writer 0.0.1\n\n");
      exit(0);

    } else if ((! strcmp("-h", argv[i])) || (! strcmp("--help", argv[i]))) {
      printHelp(argv[0], info.serialDevice.c_str(),
                info.baudrate, info.terminalBaudrate);
      exit(0);

    } else if ((! strcmp("-r", argv[i])) || (! strcmp("--record", argv[i]))) {
      info.record = true;

    } else {
      // S-Format ̃t@CƂēo^
      info.sformatFile = argv[i];
    }
  }
}


// !!! ̂Aminiterm ƓȂ̂ȂƂ
static void runTerminal(ConnectionInterface* con, long baudrate,
                        ArgsInfo& args_info, std::ofstream& fout) {

  // ^[Qbg̃f[^MA^[~iւ̓͑M
  con->changeBaudrate(baudrate);
  StandardInput sio;

  // ʐM
  char buf[BUFSIZ];
  while (1) {
    int n = con->recv(buf, BUFSIZ, 0);
    if (n > 0) {
      //write(1, buf, n);
      for (int i = 0; i < n; ++i) {
        char ch = buf[i];

        if (isprint(ch) || (ch == '\r') || (ch == '\n') || (ch == '\t')) {
          printf("%c", ch);
        } else {
          // sȊÕoCíA16i\
          printf("[%02x]", (unsigned char)ch);
        }
        fflush(stdout);
      }
      if (args_info.record) {
        // L^t@Cւ̏o
        fout.write(buf, n);
        fout.flush();
      }
    }
    n = sio.recv(buf, BUFSIZ, 100);
    if (n > 0) {
      con->send(buf, n);
    }
  }
}


int main(int argc, char *argv[]) {

  // ̉
  std::vector<std::string> search_path;
  search_path.push_back("./");
  search_path.push_back("~/.beego/");

  ArgsInfo args_info;
  std::string config_file;
  FileToArgs file;
  if (searchFilePath(config_file, "beegoconf", search_path)) {
    file.load(config_file.c_str());
    // ݒt@C̓eƂĈ
    parseArgs(args_info, file.argc, file.argv);
  }
  parseArgs(args_info, argc, argv);

  if (args_info.sformatFile == NULL) {
    printf("no data file.\nTrye '%s --help' for more information.\n", argv[0]);
    exit(1);
  }

  // L^t@CJ
  std::ofstream fout;
  if (args_info.record) {
    fout.open(LogFileName);
    if (! fout.is_open()) {
      perror(LogFileName);
      args_info.record = false;
    }
  }

  // ]t@C̃tH[}bgmF
  SFormatHandler sformat(args_info.sformatFile);
  if (! sformat.eachLines(NULL, NULL)) {
    printf("%s: %s\n", args_info.sformatFile, sformat.what());
    exit(1);
  }

  // vO̓]
  FZtatHandler fztat;
#ifdef MONITOR
  LoaderTargetSimulator simulator(fztat);
  if (args_info.simulator) {
    simulator.activate();
  }
#else
  if (0) {
  }
#endif
  else {
    if (! fztat.connect(args_info.serialDevice.c_str(), args_info.baudrate)) {
      printf("%s : %s.\n", fztat.what(), args_info.serialDevice.c_str());
      exit(1);
    }
  }
  ConnectionInterface*& con = fztat.getConnection();

  con->send("S", 1);
  if (! fztat.sendSrecData(sformat)) {
    // !!! error_message
    fprintf(stderr, "%s: %s\n", args_info.serialDevice.c_str(), fztat.what());
    exit(1);
  }
  // AhX̓]
  printf("\n");
  con->send("Q", 1);
  if (! fztat.sendStartAddress()) {
    fprintf(stderr, "send address fail.\n");
    exit(1);
  }
  enum { Timeout = 1000 };
  char recv_ch;
  con->recv(&recv_ch, 1, Timeout);


  // ^[~i
  runTerminal(con, args_info.terminalBaudrate, args_info, fout);

  return 0;
}
