/*
 * Decompiled with CFR 0.152.
 */
package watij;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import watij.WatijTestCase;
import watij.elements.Button;
import watij.elements.Buttons;
import watij.finders.FinderFactory;

public class UnicodeTest
extends WatijTestCase {
    private Properties properties = new Properties();

    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "unicode.html");
        FileInputStream is = new FileInputStream(HTML_ROOT + "..\\unicode.properties");
        try {
            this.properties.load(is);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            UnicodeTest.fail((String)"Unable to load unicode.properties from the 'res' directory");
        }
        try {
            ((InputStream)is).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testFrench() throws Exception {
        Buttons b = ie.buttons();
        String text = this.properties.getProperty("french");
        UnicodeTest.assertEquals((String)"French button text is not the same as the resource", (String)((Button)b.get(0)).text(), (String)text);
        UnicodeTest.assertTrue((String)"Text finder should find French button", (boolean)ie.button(FinderFactory.text(text)).exists());
        UnicodeTest.assertTrue((String)"Xpath finder should find French button", (boolean)ie.button(FinderFactory.xpath("//BUTTON[text() = '" + text + "']")).exists());
    }

    public void testSimplifiedChinese() throws Exception {
        Buttons b = ie.buttons();
        String text = this.properties.getProperty("simplified_chinese");
        UnicodeTest.assertEquals((String)"Simplified Chinese button text is not the same as the resource", (String)((Button)b.get(1)).text(), (String)text);
        UnicodeTest.assertTrue((String)"Text finder should find Simplified Chinese button", (boolean)ie.button(FinderFactory.text(text)).exists());
        UnicodeTest.assertTrue((String)"Xpath finder should find Simplified Chinese button", (boolean)ie.button(FinderFactory.xpath("//BUTTON[text() = '" + text + "']")).exists());
    }

    public static Test suite() {
        return new TestSuite(UnicodeTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)UnicodeTest.suite());
    }
}

