/*
 * Decompiled with CFR 0.152.
 */
package watij.finders;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import watij.finders.BaseFinder;
import watij.finders.Finder;
import watij.finders.Symbol;
import watij.utilities.Debug;
import watij.utilities.StringUtils;
import watij.utilities.Utils;

public class AttributeFinder
extends BaseFinder
implements Symbol {
    String name;
    String what;

    public AttributeFinder(String name) {
        this.name = name;
    }

    public AttributeFinder(String name, String what) {
        this.name = name;
        this.what = what;
    }

    public Finder newFinder(String what) throws Exception {
        return new AttributeFinder(this.name, what);
    }

    public boolean matches(Element element) throws Exception {
        Debug.getInstance().println("element tag =" + element.getTagName());
        Debug.getInstance().println("name=" + this.name + " what=" + this.what);
        return this.matches(element.getAttributeNode(this.name), this.what);
    }

    protected boolean matches(Attr attr, String what) {
        Debug.getInstance().println("Begin AttributeFinder.matches(Attr attr, String what)");
        Debug.getInstance().println("what=" + what);
        Debug.getInstance().println("attr=" + attr);
        if (attr == null) {
            Debug.getInstance().println("returning false");
            return false;
        }
        Debug.getInstance().println("attr name = " + attr.getName() + " attr value = " + attr.getValue());
        if (this.matchesNameWithValueEmpty(attr.getName(), what)) {
            Debug.getInstance().println("returning true");
            return true;
        }
        if (this.matchesNameAndValue(attr.getName(), attr.getValue(), what)) {
            Debug.getInstance().println("returning true");
            return true;
        }
        Debug.getInstance().println("returning false");
        return false;
    }

    protected boolean matchesNameWithValueEmpty(String attrName, String what) {
        return Utils.isEmpty(what) && attrName.equals(this.name);
    }

    protected boolean matchesNameAndValue(String attrName, String attrValue, String what) {
        return attrName.equals(this.name) && StringUtils.matchesOrEquals(what, attrValue);
    }
}

