package jp.sourceforge.cfneo.at4ie.api.impl.ie;

import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.cfneo.at4ie.api.AT4IERuntimeException;
import jp.sourceforge.cfneo.at4ie.api.ActionCommandEnum;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.impl.DummyInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.AT4IEInjectionInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.AT4IEScreenshotInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.AT4IEWaitInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.AssertAlertInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.AssertLocationInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.AssertSelectedInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.AssertSelectedOptionInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.AssertTitleInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.AssertValueInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.ClickAlertDialogOkInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.ClickAndWaitInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.ClickInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.CloseInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.GoBackInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.OpenInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.PauseInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.SelectInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.StoreInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.StoreTextInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.StoreValueInvoker;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker.TypeInvoker;

/**
 * ActionCommandɑΉInvokerNX̒`B
 * @author imaitakafumi
 *
 */
public class AT4IEInvokerMap {

	private Map<ActionCommandEnum, Class<? extends Invoker>> map;

	/**
	 * RXgN^B
	 */
	public AT4IEInvokerMap() {
		this.map = new HashMap<ActionCommandEnum, Class<? extends Invoker>>();
		this.setupMap();
	}

	/**
	 * ActionCommandɑΉInvoker̃NX擾B
	 * @param command
	 * @return
	 */
	public Class<? extends Invoker> getInvokerClass(ActionCommandEnum command) {
		try {
			return this.map.get(command);
		} catch (Exception e) {
			throw new AT4IERuntimeException(e);
		}
	}

	/**
	 * ActionCommandInvoker̋ۃNX}bsOB
	 */
	protected void setupMap() {
		/*
		 * nR}hB
		 */
		this.map.put(ActionCommandEnum.ACTION_OPEN, OpenInvoker.class);
		this.map.put(ActionCommandEnum.ACTION_CLICK, ClickInvoker.class);
		this.map.put(ActionCommandEnum.ACTION_CLICK_AND_WAIT, ClickAndWaitInvoker.class);
		this.map.put(ActionCommandEnum.ACTION_TYPE, TypeInvoker.class);
		this.map.put(ActionCommandEnum.ACTION_SELECT, SelectInvoker.class);
		this.map.put(ActionCommandEnum.ACTION_SELECT_WINDOW, DummyInvoker.class);		// TODO:AT4IEInvokerMap.ACTION_SELECT_WINDOW
		this.map.put(ActionCommandEnum.ACTION_GO_BACK, GoBackInvoker.class);
		this.map.put(ActionCommandEnum.ACTION_CLOSE, CloseInvoker.class);
		this.map.put(ActionCommandEnum.ACTION_PAUSE, PauseInvoker.class);
		this.map.put(ActionCommandEnum.ACTION_FIRE_EVENT, DummyInvoker.class);			// TODO:AT4IEInvokerMap.ACTION_FIRE_EVENT
		this.map.put(ActionCommandEnum.ACTION_WAIT_FOR_VALUE, DummyInvoker.class);		// TODO:AT4IEInvokerMap.ACTION_WAIT_FOR_VALUE
		this.map.put(ActionCommandEnum.ACTION_STORE, StoreInvoker.class);
		this.map.put(ActionCommandEnum.ACTION_STORE_VALUE, StoreValueInvoker.class);
		this.map.put(ActionCommandEnum.ACTION_STORE_TEXT, StoreTextInvoker.class);
		this.map.put(ActionCommandEnum.ACTION_STORE_ATTRIBUTE, DummyInvoker.class);		// TODO:AT4IEInvokerMap.ACTION_STORE_ATTRIBUTE
		this.map.put(ActionCommandEnum.ACTION_CHOOSE_CANCEL_ON_NEXT_CONFIRMATION, DummyInvoker.class);	// TODO:AT4IEInvokerMap.ACTION_CHOOSE_CANCEL_ON_NEXT_CONFIRMATION
		this.map.put(ActionCommandEnum.ACTION_ANSWER_ON_NEXT_PROMPT, DummyInvoker.class);	// TODO:AT4IEInvokerMap.ACTION_ANSWER_ON_NEXT_PROMPT
		this.map.put(ActionCommandEnum.ACTION_CLICK_ALERT_DIALOG_OK, ClickAlertDialogOkInvoker.class);

		/*
		 * nR}h(assert)B
		 */
		this.map.put(ActionCommandEnum.ASSERT_LOCATION, AssertLocationInvoker.class);
		this.map.put(ActionCommandEnum.ASSERT_TITLE, AssertTitleInvoker.class);
		this.map.put(ActionCommandEnum.ASSERT_VALUE, AssertValueInvoker.class);
		this.map.put(ActionCommandEnum.ASSERT_SELECTED, AssertSelectedInvoker.class);
		this.map.put(ActionCommandEnum.ASSERT_SELECTED_OPTIONS, AssertSelectedOptionInvoker.class);
		this.map.put(ActionCommandEnum.ASSERT_TEXT, DummyInvoker.class);				// TODO:AT4IEInvokerMap.ASSERT_TEXT
		this.map.put(ActionCommandEnum.ASSERT_ATTRIBUTE, DummyInvoker.class);			// TODO:AT4IEInvokerMap.ASSERT_ATTRIBUTE
		this.map.put(ActionCommandEnum.ASSERT_TEXT_PRESENT, DummyInvoker.class);		// TODO:AT4IEInvokerMap.ASSERT_TEXT_PRESENT
		this.map.put(ActionCommandEnum.ASSERT_TEXT_NOT_PRESENT, DummyInvoker.class);	// TODO:AT4IEInvokerMap.ASSERT_TEXT_NOT_PRESENT
		this.map.put(ActionCommandEnum.ASSERT_ELEMENT_PRESENT, DummyInvoker.class);		// TODO:AT4IEInvokerMap.ASSERT_ELEMENT_PRESENT
		this.map.put(ActionCommandEnum.ASSERT_ELEMENT_NOT_PRESENT, DummyInvoker.class);	// TODO:AT4IEInvokerMap.ASSERT_ELEMENT_NOT_PRESENT
		this.map.put(ActionCommandEnum.ASSERT_TABLE, DummyInvoker.class);				// TODO:AT4IEInvokerMap.ASSERT_TABLE
		this.map.put(ActionCommandEnum.ASSERT_VISIBLE, DummyInvoker.class);				// TODO:AT4IEInvokerMap.ASSERT_VISIBLE
		this.map.put(ActionCommandEnum.ASSERT_NOT_VISIBLE, DummyInvoker.class);			// TODO:AT4IEInvokerMap.ASSERT_NOT_VISIBLE
		this.map.put(ActionCommandEnum.ASSERT_EDIT_TABLE, DummyInvoker.class);			// TODO:AT4IEInvokerMap.ASSERT_EDIT_TABLE
		this.map.put(ActionCommandEnum.ASSERT_NOT_EDIT_TABLE, DummyInvoker.class);		// TODO:AT4IEInvokerMap.ASSERT_NOT_EDIT_TABLE
		this.map.put(ActionCommandEnum.ASSERT_ALERT, AssertAlertInvoker.class);
		this.map.put(ActionCommandEnum.ASSERT_CONFIRMATION, DummyInvoker.class);		// TODO:AT4IEInvokerMap.ASSERT_CONFIRMATION
		this.map.put(ActionCommandEnum.ASSERT_PROMPT, DummyInvoker.class);				// TODO:AT4IEInvokerMap.ASSERT_PROMPT

		/*
		 * nR}h(verify)B
		 */
		this.map.put(ActionCommandEnum.VERIFY_LOCATION, DummyInvoker.class);			// TODO:VERIFY_LOCATION
		this.map.put(ActionCommandEnum.VERIFY_TITLE, DummyInvoker.class);				// TODO:VERIFY_TITLE
		this.map.put(ActionCommandEnum.VERIFY_VALUE, DummyInvoker.class);				// TODO:VERIFY_VALUE
		this.map.put(ActionCommandEnum.VERIFY_SELECTED, DummyInvoker.class);			// TODO:AT4IEInvokerMap.VERIFY_SELECTED
		this.map.put(ActionCommandEnum.VERIFY_SELECTED_OPTIONS, DummyInvoker.class);	// TODO:AT4IEInvokerMap.VERIFY_SELECTED_OPTIONS
		this.map.put(ActionCommandEnum.VERIFY_TEXT, DummyInvoker.class);				// TODO:AT4IEInvokerMap.VERIFY_TEXT
		this.map.put(ActionCommandEnum.VERIFY_ATTRIBUTE, DummyInvoker.class);			// TODO:AT4IEInvokerMap.VERIFY_ATTRIBUTE
		this.map.put(ActionCommandEnum.VERIFY_TEXT_PRESENT, DummyInvoker.class);		// TODO:AT4IEInvokerMap.VERIFY_TEXT_PRESENT
		this.map.put(ActionCommandEnum.VERIFY_TEXT_NOT_PRESENT, DummyInvoker.class);	// TODO:AT4IEInvokerMap.VERIFY_TEXT_NOT_PRESENT
		this.map.put(ActionCommandEnum.VERIFY_ELEMENT_PRESENT, DummyInvoker.class);		// TODO:AT4IEInvokerMap.VERIFY_ELEMENT_PRESENT
		this.map.put(ActionCommandEnum.VERIFY_ELEMENT_NOT_PRESENT, DummyInvoker.class);	// TODO:AT4IEInvokerMap.VERIFY_ELEMENT_NOT_PRESENT
		this.map.put(ActionCommandEnum.VERIFY_TABLE, DummyInvoker.class);				// TODO:AT4IEInvokerMap.VERIFY_TABLE
		this.map.put(ActionCommandEnum.VERIFY_VISIBLE, DummyInvoker.class);				// TODO:AT4IEInvokerMap.VERIFY_VISIBLE
		this.map.put(ActionCommandEnum.VERIFY_NOT_VISIBLE, DummyInvoker.class);			// TODO:AT4IEInvokerMap.VERIFY_NOT_VISIBLE
		this.map.put(ActionCommandEnum.VERIFY_EDIT_TABLE, DummyInvoker.class);			// TODO:AT4IEInvokerMap.VERIFY_EDIT_TABLE
		this.map.put(ActionCommandEnum.VERIFY_NOT_EDIT_TABLE, DummyInvoker.class);		// TODO:AT4IEInvokerMap.VERIFY_NOT_EDIT_TABLE
		this.map.put(ActionCommandEnum.VERIFY_ALERT, DummyInvoker.class);				// TODO:VERIFY_ALERT
		this.map.put(ActionCommandEnum.VERIFY_CONFIRMATION, DummyInvoker.class);		// TODO:AT4IEInvokerMap.VERIFY_CONFIRMATION
		this.map.put(ActionCommandEnum.VERIFY_PROMPT, DummyInvoker.class);				// TODO:AT4IEInvokerMap.VERIFY_PROMPT

		/*
		 * IWiR}hB
		 */
		this.map.put(ActionCommandEnum.WAIT, AT4IEWaitInvoker.class);
		this.map.put(ActionCommandEnum.SCREEN_SHOT, AT4IEScreenshotInvoker.class);
		this.map.put(ActionCommandEnum.INJECTION, AT4IEInjectionInvoker.class);
	}
}
