package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import jp.sourceforge.cfneo.at4ie.api.AT4IEAssertException;
import jp.sourceforge.cfneo.at4ie.api.ActionCommandEnum;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.TargetBrowser;
import jp.sourceforge.cfneo.at4ie.api.TestCase;
import jp.sourceforge.cfneo.at4ie.api.impl.DefaultTestCase;
import jp.sourceforge.cfneo.at4ie.utils.AT4IEStringUtil;

import org.apache.log4j.Logger;

/**
 * command=waitInvokerB
 * ҋ@ׂInvokerB
 * @author imaitakafumi
 *
 */
public class AT4IEWaitInvoker extends Invoker {

	Logger logger = Logger.getLogger(AT4IEWaitInvoker.class);

	/**
	 * RXgN^B
	 * @param context
	 * @param browser
	 */
	public AT4IEWaitInvoker(Context context, TargetBrowser browser) {
		super(context, browser);
	}

	@Override
	public void invoke(TestCase testCase) throws AT4IEAssertException {
		logger.debug("WaitInvoker#invoke testCase=" + testCase.toString());
		String value = testCase.getElementValue();
		long millis = 0L;
		if (value != null && value.trim().length() > 0) {
			if (AT4IEStringUtil.isInteger(value)) {
				// l̏ꍇ
				millis = Long.valueOf(value);
			} else if (AT4IEStringUtil.isFloat(value)) {
				// s_̏ꍇ
				millis = new Double(value).longValue();
			} else if (AT4IEStringUtil.isTimeFormat(value)) {
				// ԕ\L̏ꍇ
				millis = AT4IEStringUtil.getLongValueFromTimeFormat(value);
			}
		}
		logger.debug("WaitInvoker#invoke millis=" + millis);
		millis *= 1000L;
		logger.debug("AT4IEWaitInvoker#invoke this.getContext()=" + this.getContext());
		new DefaultTestCase(this.getContext(),
				ActionCommandEnum.ACTION_PAUSE, millis, null).doTest();
	}

}
