package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import jp.sourceforge.cfneo.at4ie.api.AT4IEAssertException;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.TargetBrowser;
import jp.sourceforge.cfneo.at4ie.api.TestCase;
import jp.sourceforge.cfneo.at4ie.utils.LocatorUtil;

import org.apache.log4j.Logger;

/**
 * command=assertAlertInvokerB<br />
 * A[g_CAO̓e؂B
 * @author imaitakafumi
 *
 */
public class AssertAlertInvoker extends Invoker {

	Logger logger = Logger.getLogger(AssertAlertInvoker.class);

	/**
	 * RXgN^B
	 * @param context
	 * @param browser
	 */
	public AssertAlertInvoker(Context context, TargetBrowser browser) {
		super(context, browser);
	}

	@Override
	public void invoke(TestCase testCase) throws AT4IEAssertException {
		String expected = LocatorUtil.getLocatorValue(testCase.getTarget());
		String actual = this.getBrowser().getAlertDialogText();
		logger.debug("AssertAlertInvoker#invoke testCase=" + testCase.toString()
				+ " expected=[" + expected + "]/actual=[" + actual + "]");
		if (expected.equals(actual) == false) {
			throw new AT4IEAssertException(expected, actual);
		}
	}

}
