package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import jp.sourceforge.cfneo.at4ie.api.AT4IEAssertException;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.ElementLocatorEnum;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.TargetBrowser;
import jp.sourceforge.cfneo.at4ie.api.TestCase;
import jp.sourceforge.cfneo.at4ie.utils.LocatorUtil;

import org.apache.log4j.Logger;

/**
 * vf̃eLXg؂܂B̓eLXg܂ޑSĂ̗vfɑ΂ē삵܂B
 * ̃R}h́A`悳ꂽeLXgłΗvf textContent(Mozilla ̂悤ȃuEU)ł
 * innerText(IE ̂悤ȃuEU)łƂł܂B
 * @author imaitakafumi
 *
 */
public class AssertTextInvoker extends Invoker {

	Logger logger = Logger.getLogger(AssertTextInvoker.class);

	/**
	 * RXgN^B
	 * @param context
	 * @param browser
	 */
	public AssertTextInvoker(Context context, TargetBrowser browser) {
		super(context, browser);
	}

	@Override
	public void invoke(TestCase testCase) throws AT4IEAssertException {
		ElementLocatorEnum elem = LocatorUtil.getElementLocatorEnum(testCase.getTarget());
		String expected = testCase.getValue();
		String actual = null;
		logger.debug("elem=" + elem.toString());
		switch (elem) {
		case DOM:
			break;
		case ID:
			actual = super.getBrowser().getTextById(testCase.getElementValue());
		case IDENTIFIER:
			break;
		case LINK:
			break;
		case NAME:
			actual = super.getBrowser().getTextByName(testCase.getElementValue());
			break;
		case XPATH:
			break;
		case VALUE:
			break;
		case OTHER:
			break;
		}
		logger.debug("AssertAlertInvoker#invoke testCase=" + testCase.toString()
				+ " expected=[" + expected + "]/actual=[" + actual + "]");
		if (expected.equals(actual) == false) {
			throw new AT4IEAssertException(testCase.getElementValue(), actual);
		}
	}

}
