package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import jp.sourceforge.cfneo.at4ie.api.AT4IEAssertException;
import jp.sourceforge.cfneo.at4ie.api.AT4IERuntimeException;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.ElementLocatorEnum;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.TargetBrowser;
import jp.sourceforge.cfneo.at4ie.api.TestCase;
import jp.sourceforge.cfneo.at4ie.utils.LocatorUtil;

import org.apache.log4j.Logger;

/**
 * command=clickInvokerB<br />
 * uEŨ{^NbNB<br />
 * <br />
 * reference<br />
 * NA{^A`FbN{bNXAWI{^NbN܂B<br />
 * ʏ̃N̂悤ɃNbNƐVȃy[WɑJڂꍇ́A"clickAndWait"gpĉB<br />
 * @author imaitakafumi
 *
 */
public class ClickInvoker extends Invoker {

	Logger logger = Logger.getLogger(ClickInvoker.class);

	/**
	 * RXgN^B
	 * @param context
	 * @param browser
	 */
	public ClickInvoker(Context context, TargetBrowser browser) {
		super(context, browser);
	}

	@Override
	public void invoke(TestCase testCase) throws AT4IEAssertException {
		logger.debug("ClickInvoker#invoke testCase=" + testCase.toString());
		try {
			ElementLocatorEnum elem = LocatorUtil
					.getElementLocatorEnum(testCase.getTarget());
			logger.debug("ClickInvoker#invoke elem=" + elem.toString());
			switch (elem) {
			case DOM:
				break;
			case ID:
				super.getBrowser().clickButtonById(testCase.getElementValue());
				break;
			case IDENTIFIER:
				break;
			case LINK:
				super.getBrowser().clickLinkByName(testCase.getElementValue());
				break;
			case NAME:
				super.getBrowser().clickButtonByName(testCase.getElementValue());
				break;
			case XPATH:
				break;
			case VALUE:
				break;
			case OTHER:
				break;
			}
		} catch (Exception e) {
			throw new AT4IERuntimeException(e);
		}
	}

}
